/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.oauth;

import com.ning.http.client.FluentStringsMap;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilderBase;
import com.ning.http.client.SignatureCalculator;
import com.ning.http.client.oauth.ConsumerKey;
import com.ning.http.client.oauth.RequestToken;
import com.ning.http.client.oauth.ThreadSafeHMAC;
import com.ning.http.util.Base64;
import com.ning.http.util.UTF8Codec;
import com.ning.http.util.UTF8UrlEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class OAuthSignatureCalculator
implements SignatureCalculator {
    public static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String KEY_OAUTH_CONSUMER_KEY = "oauth_consumer_key";
    private static final String KEY_OAUTH_NONCE = "oauth_nonce";
    private static final String KEY_OAUTH_SIGNATURE = "oauth_signature";
    private static final String KEY_OAUTH_SIGNATURE_METHOD = "oauth_signature_method";
    private static final String KEY_OAUTH_TIMESTAMP = "oauth_timestamp";
    private static final String KEY_OAUTH_TOKEN = "oauth_token";
    private static final String KEY_OAUTH_VERSION = "oauth_version";
    private static final String OAUTH_VERSION_1_0 = "1.0";
    private static final String OAUTH_SIGNATURE_METHOD = "HMAC-SHA1";
    protected final Random random;
    protected final byte[] nonceBuffer = new byte[16];
    protected final ThreadSafeHMAC mac;
    protected final ConsumerKey consumerAuth;
    protected final RequestToken userAuth;

    public OAuthSignatureCalculator(ConsumerKey consumerAuth, RequestToken userAuth) {
        this.mac = new ThreadSafeHMAC(consumerAuth, userAuth);
        this.consumerAuth = consumerAuth;
        this.userAuth = userAuth;
        this.random = new Random((long)System.identityHashCode(this) + System.currentTimeMillis());
    }

    @Override
    public void calculateAndAddSignature(String baseURL, Request request, RequestBuilderBase<?> requestBuilder) {
        String method = request.getMethod();
        String nonce = this.generateNonce();
        long timestamp = System.currentTimeMillis() / 1000L;
        String signature = this.calculateSignature(method, baseURL, timestamp, nonce, request.getParams(), request.getQueryParams());
        String headerValue = this.constructAuthHeader(signature, nonce, timestamp);
        requestBuilder.setHeader(HEADER_AUTHORIZATION, headerValue);
    }

    public String calculateSignature(String method, String baseURL, long oauthTimestamp, String nonce, FluentStringsMap formParams, FluentStringsMap queryParams) {
        String key;
        int i;
        StringBuilder signedText = new StringBuilder(100);
        signedText.append(method);
        signedText.append('&');
        if (baseURL.startsWith("http:")) {
            i = baseURL.indexOf(":80/", 4);
            if (i > 0) {
                baseURL = baseURL.substring(0, i) + baseURL.substring(i + 3);
            }
        } else if (baseURL.startsWith("https:") && (i = baseURL.indexOf(":443/", 5)) > 0) {
            baseURL = baseURL.substring(0, i) + baseURL.substring(i + 4);
        }
        signedText.append(UTF8UrlEncoder.encode(baseURL));
        OAuthParameterSet allParameters = new OAuthParameterSet();
        allParameters.add(KEY_OAUTH_CONSUMER_KEY, this.consumerAuth.getKey());
        allParameters.add(KEY_OAUTH_NONCE, nonce);
        allParameters.add(KEY_OAUTH_SIGNATURE_METHOD, OAUTH_SIGNATURE_METHOD);
        allParameters.add(KEY_OAUTH_TIMESTAMP, String.valueOf(oauthTimestamp));
        allParameters.add(KEY_OAUTH_TOKEN, this.userAuth.getKey());
        allParameters.add(KEY_OAUTH_VERSION, OAUTH_VERSION_1_0);
        if (formParams != null) {
            for (Map.Entry<String, List<String>> entry : formParams) {
                key = entry.getKey();
                for (String value : entry.getValue()) {
                    allParameters.add(key, value);
                }
            }
        }
        if (queryParams != null) {
            for (Map.Entry<String, List<String>> entry : queryParams) {
                key = entry.getKey();
                for (String value : entry.getValue()) {
                    allParameters.add(key, value);
                }
            }
        }
        String encodedParams = allParameters.sortAndConcat();
        signedText.append('&');
        UTF8UrlEncoder.appendEncoded(signedText, encodedParams);
        byte[] rawBase = UTF8Codec.toUTF8(signedText.toString());
        byte[] rawSignature = this.mac.digest(rawBase);
        return Base64.encode(rawSignature);
    }

    public String constructAuthHeader(String signature, String nonce, long oauthTimestamp) {
        StringBuilder sb = new StringBuilder(200);
        sb.append("OAuth ");
        sb.append(KEY_OAUTH_CONSUMER_KEY).append("=\"").append(this.consumerAuth.getKey()).append("\", ");
        sb.append(KEY_OAUTH_TOKEN).append("=\"").append(this.userAuth.getKey()).append("\", ");
        sb.append(KEY_OAUTH_SIGNATURE_METHOD).append("=\"").append(OAUTH_SIGNATURE_METHOD).append("\", ");
        sb.append(KEY_OAUTH_SIGNATURE).append("=\"");
        UTF8UrlEncoder.appendEncoded(sb, signature).append("\", ");
        sb.append(KEY_OAUTH_TIMESTAMP).append("=\"").append(oauthTimestamp).append("\", ");
        sb.append(KEY_OAUTH_NONCE).append("=\"");
        UTF8UrlEncoder.appendEncoded(sb, nonce);
        sb.append("\", ");
        sb.append(KEY_OAUTH_VERSION).append("=\"").append(OAUTH_VERSION_1_0).append("\"");
        return sb.toString();
    }

    private synchronized String generateNonce() {
        this.random.nextBytes(this.nonceBuffer);
        return Base64.encode(this.nonceBuffer);
    }

    static final class Parameter
    implements Comparable<Parameter> {
        private final String key;
        private final String value;

        public Parameter(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String key() {
            return this.key;
        }

        public String value() {
            return this.value;
        }

        @Override
        public int compareTo(Parameter other) {
            int diff = this.key.compareTo(other.key);
            if (diff == 0) {
                diff = this.value.compareTo(other.value);
            }
            return diff;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parameter parameter = (Parameter)o;
            if (!this.key.equals(parameter.key)) {
                return false;
            }
            return this.value.equals(parameter.value);
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }
    }

    static final class OAuthParameterSet {
        private final ArrayList<Parameter> allParameters = new ArrayList();

        public OAuthParameterSet add(String key, String value) {
            Parameter p = new Parameter(UTF8UrlEncoder.encode(key), UTF8UrlEncoder.encode(value));
            this.allParameters.add(p);
            return this;
        }

        public String sortAndConcat() {
            Object[] params = this.allParameters.toArray(new Parameter[this.allParameters.size()]);
            Arrays.sort(params);
            StringBuilder encodedParams = new StringBuilder(100);
            for (Object param : params) {
                if (encodedParams.length() > 0) {
                    encodedParams.append('&');
                }
                encodedParams.append(((Parameter)param).key()).append('=').append(((Parameter)param).value());
            }
            return encodedParams.toString();
        }
    }
}

