/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.listener;

import com.ning.http.client.AsyncCompletionHandlerBase;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.Response;
import com.ning.http.client.listener.TransferListener;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferCompletionHandler
extends AsyncCompletionHandlerBase {
    private static final Logger logger = LoggerFactory.getLogger(TransferCompletionHandler.class);
    private final ConcurrentLinkedQueue<TransferListener> listeners = new ConcurrentLinkedQueue();
    private final boolean accumulateResponseBytes;
    private TransferAdapter transferAdapter;
    private AtomicLong bytesTransferred = new AtomicLong();
    private AtomicLong totalBytesToTransfer = new AtomicLong(0L);

    public TransferCompletionHandler() {
        this(false);
    }

    public TransferCompletionHandler(boolean accumulateResponseBytes) {
        this.accumulateResponseBytes = accumulateResponseBytes;
    }

    public TransferCompletionHandler addTransferListener(TransferListener t) {
        this.listeners.offer(t);
        return this;
    }

    public TransferCompletionHandler removeTransferListener(TransferListener t) {
        this.listeners.remove(t);
        return this;
    }

    public void transferAdapter(TransferAdapter transferAdapter) {
        this.transferAdapter = transferAdapter;
    }

    @Override
    public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        this.fireOnHeaderReceived(headers.getHeaders());
        return super.onHeadersReceived(headers);
    }

    @Override
    public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
        AsyncHandler.STATE s = AsyncHandler.STATE.CONTINUE;
        if (this.accumulateResponseBytes) {
            s = super.onBodyPartReceived(content);
        }
        this.fireOnBytesReceived(content.getBodyPartBytes());
        return s;
    }

    @Override
    public Response onCompleted(Response response) throws Exception {
        this.fireOnEnd();
        return response;
    }

    @Override
    public AsyncHandler.STATE onHeaderWriteCompleted() {
        Object list = this.transferAdapter.getHeaders().get("Content-Length");
        if (list != null && list.size() > 0 && list.get(0) != "") {
            this.totalBytesToTransfer.set(Long.valueOf((String)list.get(0)));
        }
        this.fireOnHeadersSent(this.transferAdapter.getHeaders());
        return AsyncHandler.STATE.CONTINUE;
    }

    @Override
    public AsyncHandler.STATE onContentWriteCompleted() {
        return AsyncHandler.STATE.CONTINUE;
    }

    @Override
    public AsyncHandler.STATE onContentWriteProgress(long amount, long current, long total) {
        if (this.bytesTransferred.get() == -1L) {
            return AsyncHandler.STATE.CONTINUE;
        }
        if (this.totalBytesToTransfer.get() == 0L) {
            this.totalBytesToTransfer.set(total);
        }
        this.bytesTransferred.addAndGet(amount);
        if (this.transferAdapter != null) {
            byte[] bytes = new byte[(int)amount];
            this.transferAdapter.getBytes(bytes);
            this.fireOnBytesSent(bytes);
        }
        return AsyncHandler.STATE.CONTINUE;
    }

    @Override
    public void onThrowable(Throwable t) {
        this.fireOnThrowable(t);
    }

    private void fireOnHeadersSent(FluentCaseInsensitiveStringsMap headers) {
        for (TransferListener l : this.listeners) {
            try {
                l.onRequestHeadersSent(headers);
            }
            catch (Throwable t) {
                l.onThrowable(t);
            }
        }
    }

    private void fireOnHeaderReceived(FluentCaseInsensitiveStringsMap headers) {
        for (TransferListener l : this.listeners) {
            try {
                l.onResponseHeadersReceived(headers);
            }
            catch (Throwable t) {
                l.onThrowable(t);
            }
        }
    }

    private void fireOnEnd() {
        long count = this.bytesTransferred.getAndSet(-1L);
        if (count != this.totalBytesToTransfer.get() && this.transferAdapter != null) {
            byte[] bytes = new byte[8192];
            int leftBytes = (int)(this.totalBytesToTransfer.get() - count);
            int length = 8192;
            while (leftBytes > 0) {
                if (leftBytes > 8192) {
                    leftBytes -= 8192;
                } else {
                    length = leftBytes;
                    leftBytes = 0;
                }
                if (length < 8192) {
                    bytes = new byte[length];
                }
                this.transferAdapter.getBytes(bytes);
                this.fireOnBytesSent(bytes);
            }
        }
        for (TransferListener l : this.listeners) {
            try {
                l.onRequestResponseCompleted();
            }
            catch (Throwable t) {
                l.onThrowable(t);
            }
        }
    }

    private void fireOnBytesReceived(byte[] b) {
        for (TransferListener l : this.listeners) {
            try {
                l.onBytesReceived(ByteBuffer.wrap(b));
            }
            catch (Throwable t) {
                l.onThrowable(t);
            }
        }
    }

    private void fireOnBytesSent(byte[] b) {
        for (TransferListener l : this.listeners) {
            try {
                l.onBytesSent(ByteBuffer.wrap(b));
            }
            catch (Throwable t) {
                l.onThrowable(t);
            }
        }
    }

    private void fireOnThrowable(Throwable t) {
        for (TransferListener l : this.listeners) {
            try {
                l.onThrowable(t);
            }
            catch (Throwable t2) {
                logger.warn("onThrowable", t2);
            }
        }
    }

    public static abstract class TransferAdapter {
        private final FluentCaseInsensitiveStringsMap headers;

        public TransferAdapter(FluentCaseInsensitiveStringsMap headers) throws IOException {
            this.headers = headers;
        }

        public FluentCaseInsensitiveStringsMap getHeaders() {
            return this.headers;
        }

        public abstract void getBytes(byte[] var1);
    }
}

