/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.consumers;

import com.ning.http.client.BodyConsumer;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;

public class AppendableBodyConsumer
implements BodyConsumer {
    private final Appendable appendable;
    private final String encoding;

    public AppendableBodyConsumer(Appendable appendable, String encoding) {
        this.appendable = appendable;
        this.encoding = encoding;
    }

    public AppendableBodyConsumer(Appendable appendable) {
        this.appendable = appendable;
        this.encoding = "UTF-8";
    }

    @Override
    public void consume(ByteBuffer byteBuffer) throws IOException {
        this.appendable.append(new String(byteBuffer.array(), this.encoding));
    }

    @Override
    public void close() throws IOException {
        if (Closeable.class.isAssignableFrom(this.appendable.getClass())) {
            ((Closeable)Closeable.class.cast(this.appendable)).close();
        }
    }
}

