/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty.netty4;

import com.ning.http.client.providers.netty.netty4.WebSocketFrame;
import java.nio.charset.Charset;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.util.CharsetUtil;

public class ContinuationWebSocketFrame
extends WebSocketFrame {
    private String aggregatedText = null;

    public ContinuationWebSocketFrame() {
        this.setBinaryData(ChannelBuffers.EMPTY_BUFFER);
    }

    public ContinuationWebSocketFrame(ChannelBuffer binaryData) {
        this.setBinaryData(binaryData);
    }

    public ContinuationWebSocketFrame(boolean finalFragment, int rsv, ChannelBuffer binaryData) {
        this.setFinalFragment(finalFragment);
        this.setRsv(rsv);
        this.setBinaryData(binaryData);
    }

    public ContinuationWebSocketFrame(boolean finalFragment, int rsv, ChannelBuffer binaryData, String aggregatedText) {
        this.setFinalFragment(finalFragment);
        this.setRsv(rsv);
        this.setBinaryData(binaryData);
        this.aggregatedText = aggregatedText;
    }

    public ContinuationWebSocketFrame(boolean finalFragment, int rsv, String text) {
        this.setFinalFragment(finalFragment);
        this.setRsv(rsv);
        this.setText(text);
    }

    public String getText() {
        if (this.getBinaryData() == null) {
            return null;
        }
        return this.getBinaryData().toString(CharsetUtil.UTF_8);
    }

    public void setText(String text) {
        if (text == null || text.equalsIgnoreCase("")) {
            this.setBinaryData(ChannelBuffers.EMPTY_BUFFER);
        } else {
            this.setBinaryData(ChannelBuffers.copiedBuffer((CharSequence)text, (Charset)CharsetUtil.UTF_8));
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(data: " + this.getBinaryData() + ')';
    }

    public String getAggregatedText() {
        return this.aggregatedText;
    }

    public void setAggregatedText(String aggregatedText) {
        this.aggregatedText = aggregatedText;
    }
}

