/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.Response;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BodyDeferringAsyncHandler
implements AsyncHandler<Response> {
    private final Response.ResponseBuilder responseBuilder = new Response.ResponseBuilder();
    private final CountDownLatch headersArrived = new CountDownLatch(1);
    private final OutputStream output;
    private volatile boolean responseSet;
    private volatile Response response;
    private volatile Throwable t;

    public BodyDeferringAsyncHandler(OutputStream os) {
        this.output = os;
        this.responseSet = false;
    }

    @Override
    public void onThrowable(Throwable t) {
        this.t = t;
        this.headersArrived.countDown();
        try {
            this.closeOut();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
        this.responseBuilder.reset();
        this.responseBuilder.accumulate(responseStatus);
        return AsyncHandler.STATE.CONTINUE;
    }

    @Override
    public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        this.responseBuilder.accumulate(headers);
        return AsyncHandler.STATE.CONTINUE;
    }

    @Override
    public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
        if (!this.responseSet) {
            this.response = this.responseBuilder.build();
            this.responseSet = true;
            this.headersArrived.countDown();
        }
        bodyPart.writeTo(this.output);
        return AsyncHandler.STATE.CONTINUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeOut() throws IOException {
        try {
            this.output.flush();
        }
        finally {
            this.output.close();
        }
    }

    @Override
    public Response onCompleted() throws IOException {
        this.headersArrived.countDown();
        this.closeOut();
        if (this.t != null) {
            IOException ioe = new IOException(this.t.getMessage());
            ioe.initCause(this.t);
            throw ioe;
        }
        return this.responseBuilder.build();
    }

    public Response getResponse() throws InterruptedException, IOException {
        this.headersArrived.await();
        if (this.t != null) {
            IOException ioe = new IOException(this.t.getMessage());
            ioe.initCause(this.t);
            throw ioe;
        }
        return this.response;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BodyDeferringInputStream
    extends FilterInputStream {
        private final Future<Response> future;
        private final BodyDeferringAsyncHandler bdah;

        public BodyDeferringInputStream(Future<Response> future, BodyDeferringAsyncHandler bdah, InputStream in) {
            super(in);
            this.future = future;
            this.bdah = bdah;
        }

        @Override
        public void close() throws IOException {
            super.close();
            try {
                this.getLastResponse();
            }
            catch (Exception e) {
                IOException ioe = new IOException(e.getMessage());
                ioe.initCause(e);
                throw ioe;
            }
        }

        public Response getAsapResponse() throws InterruptedException, IOException {
            return this.bdah.getResponse();
        }

        public Response getLastResponse() throws InterruptedException, ExecutionException {
            return this.future.get();
        }
    }
}

