/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty;

import com.ning.http.client.Cookie;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.Response;
import com.ning.http.client.providers.netty.ResponseBodyPart;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferInputStream;
import org.jboss.netty.buffer.ChannelBuffers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NettyAsyncResponse
implements Response {
    private static final String HEADERS_NOT_COMPUTED = "Response's headers hasn't been computed by your AsyncHandler.";
    private static final String BODY_NOT_COMPUTED = "Response's body hasn't been computed by your AsyncHandler.";
    private static final SimpleDateFormat[] RFC2822_LIKE_DATE_FORMATS = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US), new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z", Locale.US), new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US), new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss Z", Locale.US)};
    private final URI uri;
    private final Collection<HttpResponseBodyPart> bodyParts;
    private final HttpResponseHeaders headers;
    private final HttpResponseStatus status;
    private final List<Cookie> cookies = new ArrayList<Cookie>();

    public NettyAsyncResponse(HttpResponseStatus status, HttpResponseHeaders headers, Collection<HttpResponseBodyPart> bodyParts) {
        this.status = status;
        this.headers = headers;
        this.bodyParts = bodyParts;
        this.uri = status.getUrl();
    }

    @Override
    public int getStatusCode() {
        return this.status.getStatusCode();
    }

    @Override
    public String getStatusText() {
        return this.status.getStatusText();
    }

    @Override
    public String getResponseBody() throws IOException {
        String contentType = this.getContentType();
        String charset = "ISO-8859-1";
        if (contentType != null) {
            for (String part : contentType.split(";")) {
                if (!part.startsWith("charset=")) continue;
                charset = part.substring("charset=".length());
            }
        }
        return this.contentToString(charset);
    }

    String contentToString(String charset) throws UnsupportedEncodingException {
        this.checkBodyParts();
        StringBuilder b = new StringBuilder();
        for (HttpResponseBodyPart bp : this.bodyParts) {
            b.append(new String(bp.getBodyPartBytes(), charset));
        }
        return b.toString();
    }

    @Override
    public InputStream getResponseBodyAsStream() throws IOException {
        this.checkBodyParts();
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        for (HttpResponseBodyPart bp : this.bodyParts) {
            if (!bp.getClass().isAssignableFrom(ResponseBodyPart.class)) continue;
            buf.writeBytes(bp.getBodyPartBytes());
        }
        return new ChannelBufferInputStream(buf);
    }

    private void checkBodyParts() {
        if (this.bodyParts == null || this.bodyParts.size() == 0) {
            throw new IllegalStateException(BODY_NOT_COMPUTED);
        }
    }

    @Override
    public String getResponseBodyExcerpt(int maxLength) throws IOException {
        String response;
        this.checkBodyParts();
        String contentType = this.getContentType();
        String charset = "ISO-8859-1";
        if (contentType != null) {
            for (String part : contentType.split(";")) {
                if (!part.startsWith("charset=")) continue;
                charset = part.substring("charset=".length());
            }
        }
        return (response = this.contentToString(charset)).length() <= maxLength ? response : response.substring(0, maxLength);
    }

    @Override
    public URI getUri() throws MalformedURLException {
        return this.uri;
    }

    @Override
    public String getContentType() {
        if (this.headers == null) {
            throw new IllegalStateException(HEADERS_NOT_COMPUTED);
        }
        return this.headers.getHeaders().getFirstValue("Content-Type");
    }

    @Override
    public String getHeader(String name) {
        if (this.headers == null) {
            throw new IllegalStateException();
        }
        return this.headers.getHeaders().getFirstValue(name);
    }

    @Override
    public List<String> getHeaders(String name) {
        if (this.headers == null) {
            throw new IllegalStateException(HEADERS_NOT_COMPUTED);
        }
        return this.headers.getHeaders().get(name);
    }

    @Override
    public FluentCaseInsensitiveStringsMap getHeaders() {
        if (this.headers == null) {
            throw new IllegalStateException(HEADERS_NOT_COMPUTED);
        }
        return this.headers.getHeaders();
    }

    @Override
    public boolean isRedirected() {
        return this.status.getStatusCode() >= 300 && this.status.getStatusCode() <= 399;
    }

    @Override
    public List<Cookie> getCookies() {
        if (this.headers == null) {
            throw new IllegalStateException(HEADERS_NOT_COMPUTED);
        }
        if (this.cookies.isEmpty()) {
            for (Map.Entry<String, List<String>> header : this.headers.getHeaders().entrySet()) {
                if (!header.getKey().equalsIgnoreCase("Set-Cookie")) continue;
                List<String> v = header.getValue();
                for (String value : v) {
                    Cookie cookie = this.parseCookie(value);
                    this.cookies.add(cookie);
                }
            }
        }
        return Collections.unmodifiableList(this.cookies);
    }

    private Cookie parseCookie(String value) {
        String[] fields = value.split(";\\s*");
        String[] cookie = fields[0].split("=");
        String cookieName = cookie[0];
        String cookieValue = cookie[1];
        int maxAge = -1;
        String path = null;
        String domain = null;
        boolean secure = false;
        boolean maxAgeSet = false;
        boolean expiresSet = false;
        for (int j = 1; j < fields.length; ++j) {
            if ("secure".equalsIgnoreCase(fields[j])) {
                secure = true;
                continue;
            }
            if (fields[j].indexOf(61) <= 0) continue;
            String[] f = fields[j].split("=");
            if (!maxAgeSet && "max-age".equalsIgnoreCase(f[0])) {
                try {
                    maxAge = Integer.valueOf(f[1]);
                }
                catch (NumberFormatException e1) {
                    maxAge = -1;
                }
                maxAgeSet = true;
                continue;
            }
            if (!maxAgeSet && !expiresSet && "expires".equalsIgnoreCase(f[0])) {
                try {
                    maxAge = this.convertExpireField(f[1]);
                }
                catch (ParseException e) {
                    try {
                        maxAge = Integer.valueOf(f[1]);
                    }
                    catch (NumberFormatException e1) {
                        // empty catch block
                    }
                }
                expiresSet = true;
                continue;
            }
            if ("domain".equalsIgnoreCase(f[0])) {
                domain = f[1];
                continue;
            }
            if (!"path".equalsIgnoreCase(f[0])) continue;
            path = f[1];
        }
        return new Cookie(domain, cookieName, cookieValue, path, maxAge, secure);
    }

    private int convertExpireField(String timestring) throws ParseException {
        ParseException exception = null;
        for (SimpleDateFormat sdf : RFC2822_LIKE_DATE_FORMATS) {
            try {
                long expire = sdf.parse(timestring).getTime();
                return (int)(expire - System.currentTimeMillis()) / 1000;
            }
            catch (ParseException e) {
                exception = e;
            }
        }
        throw exception;
    }

    @Override
    public boolean hasResponseStatus() {
        return this.status != null;
    }

    @Override
    public boolean hasResponseHeaders() {
        return this.headers != null;
    }

    @Override
    public boolean hasResponseBody() {
        return this.bodyParts != null && this.bodyParts.size() > 0;
    }
}

