/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.jdk;

import com.ning.http.client.Cookie;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.Response;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDKResponse
implements Response {
    private static final String HEADERS_NOT_COMPUTED = "Response's headers hasn't been computed by your AsyncHandler.";
    private static final String BODY_NOT_COMPUTED = "Response's body hasn't been computed by your AsyncHandler.";
    private final URI uri;
    private final Collection<HttpResponseBodyPart> bodyParts;
    private final HttpResponseHeaders headers;
    private final HttpResponseStatus status;
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    private AtomicBoolean contentComputed = new AtomicBoolean(false);
    private String content;

    public JDKResponse(HttpResponseStatus status, HttpResponseHeaders headers, Collection<HttpResponseBodyPart> bodyParts) {
        this.bodyParts = bodyParts;
        this.headers = headers;
        this.status = status;
        this.uri = this.status.getUrl();
    }

    @Override
    public int getStatusCode() {
        return this.status.getStatusCode();
    }

    @Override
    public String getStatusText() {
        return this.status.getStatusText();
    }

    @Override
    public String getResponseBody() throws IOException {
        String contentType = this.getContentType();
        String charset = "ISO-8859-1";
        if (contentType != null) {
            for (String part : contentType.split(";")) {
                if (!part.startsWith("charset=")) continue;
                charset = part.substring("charset=".length());
            }
        }
        if (!this.contentComputed.get()) {
            this.contentToString(charset);
        }
        return this.content;
    }

    String contentToString(String charset) throws UnsupportedEncodingException {
        this.checkBodyParts();
        StringBuilder b = new StringBuilder();
        for (HttpResponseBodyPart bp : this.bodyParts) {
            b.append(new String(bp.getBodyPartBytes(), charset));
        }
        this.content = b.toString();
        return this.content;
    }

    @Override
    public InputStream getResponseBodyAsStream() throws IOException {
        this.checkBodyParts();
        if (this.contentComputed.get()) {
            return new ByteArrayInputStream(this.content.getBytes("ISO-8859-1"));
        }
        return new ByteArrayCollectionInputStream(this.bodyParts.toArray(new HttpResponseBodyPart[this.bodyParts.size()]));
    }

    private void checkBodyParts() {
        if (this.bodyParts == null || this.bodyParts.size() == 0) {
            throw new IllegalStateException(BODY_NOT_COMPUTED);
        }
    }

    @Override
    public String getResponseBodyExcerpt(int maxLength) throws IOException {
        String contentType = this.getContentType();
        String charset = "ISO-8859-1";
        if (contentType != null) {
            for (String part : contentType.split(";")) {
                if (!part.startsWith("charset=")) continue;
                charset = part.substring("charset=".length());
            }
        }
        if (!this.contentComputed.get()) {
            this.contentToString(charset);
        }
        return this.content.length() <= maxLength ? this.content : this.content.substring(0, maxLength);
    }

    @Override
    public URI getUri() throws MalformedURLException {
        return this.uri;
    }

    @Override
    public String getContentType() {
        if (this.headers == null) {
            throw new IllegalStateException(HEADERS_NOT_COMPUTED);
        }
        return this.headers.getHeaders().getFirstValue("Content-Type");
    }

    @Override
    public String getHeader(String name) {
        if (this.headers == null) {
            throw new IllegalStateException();
        }
        return this.headers.getHeaders().getFirstValue(name);
    }

    @Override
    public List<String> getHeaders(String name) {
        if (this.headers == null) {
            throw new IllegalStateException(HEADERS_NOT_COMPUTED);
        }
        return this.headers.getHeaders().get(name);
    }

    @Override
    public FluentCaseInsensitiveStringsMap getHeaders() {
        if (this.headers == null) {
            throw new IllegalStateException(HEADERS_NOT_COMPUTED);
        }
        return this.headers.getHeaders();
    }

    @Override
    public boolean isRedirected() {
        return this.status.getStatusCode() >= 300 && this.status.getStatusCode() <= 399;
    }

    @Override
    public List<Cookie> getCookies() {
        if (this.headers == null) {
            throw new IllegalStateException(HEADERS_NOT_COMPUTED);
        }
        if (this.cookies.isEmpty()) {
            for (Map.Entry<String, List<String>> header : this.headers.getHeaders().entrySet()) {
                if (!header.getKey().equalsIgnoreCase("Set-Cookie")) continue;
                for (String value : header.getValue()) {
                    String[] fields = value.split(";\\s*");
                    String[] cookie = fields[0].split("=");
                    String cookieName = cookie[0];
                    String cookieValue = cookie[1];
                    String expires = "-1";
                    String path = null;
                    String domain = null;
                    boolean secure = false;
                    for (int j = 1; j < fields.length; ++j) {
                        if ("secure".equalsIgnoreCase(fields[j])) {
                            secure = true;
                            continue;
                        }
                        if (fields[j].indexOf(61) <= 0) continue;
                        String[] f = fields[j].split("=");
                        if ("expires".equalsIgnoreCase(f[0])) {
                            expires = f[1];
                            continue;
                        }
                        if ("domain".equalsIgnoreCase(f[0])) {
                            domain = f[1];
                            continue;
                        }
                        if (!"path".equalsIgnoreCase(f[0])) continue;
                        path = f[1];
                    }
                    this.cookies.add(new Cookie(domain, cookieName, cookieValue, path, Integer.valueOf(expires), secure));
                }
            }
        }
        return Collections.unmodifiableList(this.cookies);
    }

    @Override
    public boolean hasResponseStatus() {
        return this.bodyParts != null;
    }

    @Override
    public boolean hasResponseHeaders() {
        return this.headers != null;
    }

    @Override
    public boolean hasResponseBody() {
        return this.bodyParts != null && this.bodyParts.size() > 0;
    }

    private static class ByteArrayCollectionInputStream
    extends InputStream {
        private final HttpResponseBodyPart[] parts;
        private int currentPos = 0;
        private int bytePos = -1;
        private byte[] active;
        private int available = 0;

        public ByteArrayCollectionInputStream(HttpResponseBodyPart[] parts) {
            this.parts = parts;
            this.active = parts[0].getBodyPartBytes();
            this.computeLength(parts);
        }

        private void computeLength(HttpResponseBodyPart[] parts) {
            if (this.available == 0) {
                for (HttpResponseBodyPart p : parts) {
                    this.available += p.getBodyPartBytes().length;
                }
            }
        }

        public int available() throws IOException {
            return this.available;
        }

        public int read() throws IOException {
            if (++this.bytePos >= this.active.length) {
                if (++this.currentPos >= this.parts.length) {
                    return -1;
                }
                this.bytePos = 0;
                this.active = this.parts[this.currentPos].getBodyPartBytes();
            }
            return this.active[this.bytePos];
        }
    }
}

