/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.jdk;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.AsyncHttpProviderConfig;
import com.ning.http.client.Body;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.MaxRedirectException;
import com.ning.http.client.PerRequestConfig;
import com.ning.http.client.ProgressAsyncHandler;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.logging.LogManager;
import com.ning.http.client.logging.Logger;
import com.ning.http.client.providers.jdk.JDKAsyncHttpProviderConfig;
import com.ning.http.client.providers.jdk.JDKFuture;
import com.ning.http.client.providers.jdk.JDKResponse;
import com.ning.http.client.providers.jdk.ResponseBodyPart;
import com.ning.http.client.providers.jdk.ResponseHeaders;
import com.ning.http.client.providers.jdk.ResponseStatus;
import com.ning.http.multipart.MultipartRequestEntity;
import com.ning.http.util.AsyncHttpProviderUtils;
import com.ning.http.util.AuthenticatorUtils;
import com.ning.http.util.SslUtils;
import com.ning.http.util.UTF8UrlEncoder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import javax.naming.AuthenticationException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDKAsyncHttpProvider
implements AsyncHttpProvider<HttpURLConnection> {
    private static final Logger logger = LogManager.getLogger(JDKAsyncHttpProvider.class);
    private static final String NTLM_DOMAIN = "http.auth.ntlm.domain";
    private final AsyncHttpClientConfig config;
    private final AtomicBoolean isClose = new AtomicBoolean(false);
    private static final int MAX_BUFFERED_BYTES = 8192;
    private final AtomicInteger maxConnections = new AtomicInteger();
    private String jdkNtlmDomain;
    private Authenticator jdkAuthenticator;

    public JDKAsyncHttpProvider(AsyncHttpClientConfig config) {
        this.config = config;
        AsyncHttpProviderConfig<?, ?> providerConfig = config.getAsyncHttpProviderConfig();
        if (providerConfig != null && JDKAsyncHttpProviderConfig.class.isAssignableFrom(providerConfig.getClass())) {
            this.configure((JDKAsyncHttpProviderConfig)JDKAsyncHttpProviderConfig.class.cast(providerConfig));
        }
    }

    private void configure(JDKAsyncHttpProviderConfig config) {
    }

    @Override
    public <T> Future<T> execute(Request request, AsyncHandler<T> handler) throws IOException {
        if (this.isClose.get()) {
            throw new IOException("Closed");
        }
        if (this.config.getMaxTotalConnections() > -1 && this.maxConnections.get() + 1 > this.config.getMaxTotalConnections()) {
            throw new IOException(String.format("Too many connections %s", this.config.getMaxTotalConnections()));
        }
        ProxyServer proxyServer = request.getProxyServer() != null ? request.getProxyServer() : this.config.getProxyServer();
        Realm realm = request.getRealm() != null ? request.getRealm() : this.config.getRealm();
        Proxy proxy = null;
        if (proxyServer != null || realm != null) {
            try {
                proxy = this.configureProxyAndAuth(proxyServer, realm);
            }
            catch (AuthenticationException e) {
                throw new IOException(e.getMessage());
            }
        }
        HttpURLConnection urlConnection = this.createUrlConnection(request);
        JDKFuture<T> f = new JDKFuture<T>(handler, this.config.getRequestTimeoutInMs());
        f.touch();
        f.setInnerFuture(this.config.executorService().submit(new AsyncHttpUrlConnection<T>(urlConnection, request, handler, f)));
        this.maxConnections.incrementAndGet();
        return f;
    }

    private HttpURLConnection createUrlConnection(Request request) throws IOException {
        ProxyServer proxyServer = request.getProxyServer() != null ? request.getProxyServer() : this.config.getProxyServer();
        Realm realm = request.getRealm() != null ? request.getRealm() : this.config.getRealm();
        Proxy proxy = null;
        if (proxyServer != null || realm != null) {
            try {
                proxy = this.configureProxyAndAuth(proxyServer, realm);
            }
            catch (AuthenticationException e) {
                throw new IOException(e.getMessage());
            }
        }
        HttpURLConnection urlConnection = null;
        urlConnection = proxy == null ? (HttpURLConnection)AsyncHttpProviderUtils.createUri(request.getUrl()).toURL().openConnection() : (HttpURLConnection)AsyncHttpProviderUtils.createUri(request.getUrl()).toURL().openConnection(proxy);
        if (request.getUrl().startsWith("https")) {
            HttpsURLConnection secure = (HttpsURLConnection)urlConnection;
            SSLContext sslContext = this.config.getSSLContext();
            if (sslContext == null) {
                try {
                    sslContext = SslUtils.getSSLContext();
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IOException(e.getMessage());
                }
                catch (GeneralSecurityException e) {
                    throw new IOException(e.getMessage());
                }
            }
            secure.setSSLSocketFactory(sslContext.getSocketFactory());
            secure.setHostnameVerifier(new HostnameVerifier(){

                public boolean verify(String s, SSLSession sslSession) {
                    return true;
                }
            });
        }
        return urlConnection;
    }

    @Override
    public void close() {
        this.isClose.set(true);
    }

    @Override
    public Response prepareResponse(HttpResponseStatus status, HttpResponseHeaders headers, Collection<HttpResponseBodyPart> bodyParts) {
        return new JDKResponse(status, headers, bodyParts);
    }

    private Proxy configureProxyAndAuth(final ProxyServer proxyServer, final Realm realm) throws AuthenticationException {
        boolean hasAuthentication;
        Proxy proxy = null;
        if (proxyServer != null) {
            String proxyHost = proxyServer.getHost().startsWith("http://") ? proxyServer.getHost().substring("http://".length()) : proxyServer.getHost();
            InetSocketAddress addr = new InetSocketAddress(proxyHost, proxyServer.getPort());
            proxy = new Proxy(Proxy.Type.HTTP, addr);
        }
        final boolean hasProxy = proxyServer != null && proxyServer.getPrincipal() != null;
        boolean bl = hasAuthentication = realm != null && realm.getPrincipal() != null;
        if (hasProxy || hasAuthentication) {
            Field f = null;
            try {
                f = Authenticator.class.getDeclaredField("theAuthenticator");
                f.setAccessible(true);
                this.jdkAuthenticator = (Authenticator)f.get(Authenticator.class);
            }
            catch (NoSuchFieldException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
            Authenticator.setDefault(new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    if (hasProxy && this.getRequestingHost().equals(proxyServer.getHost()) && this.getRequestingPort() == proxyServer.getPort()) {
                        String password = "";
                        if (proxyServer.getPassword() != null) {
                            password = proxyServer.getPassword();
                        }
                        return new PasswordAuthentication(proxyServer.getPrincipal(), password.toCharArray());
                    }
                    if (hasAuthentication) {
                        return new PasswordAuthentication(realm.getPrincipal(), realm.getPassword().toCharArray());
                    }
                    return super.getPasswordAuthentication();
                }
            });
        } else {
            Authenticator.setDefault(null);
        }
        return proxy;
    }

    private InputStream getInputStream(HttpURLConnection urlConnection) throws IOException {
        if (urlConnection.getResponseCode() < 400) {
            return urlConnection.getInputStream();
        }
        InputStream ein = urlConnection.getErrorStream();
        return ein != null ? ein : new ByteArrayInputStream(new byte[0]);
    }

    static /* synthetic */ HttpURLConnection access$200(JDKAsyncHttpProvider x0, Request x1) throws IOException {
        return x0.createUrlConnection(x1);
    }

    static /* synthetic */ InputStream access$300(JDKAsyncHttpProvider x0, HttpURLConnection x1) throws IOException {
        return x0.getInputStream(x1);
    }

    static /* synthetic */ AtomicInteger access$400(JDKAsyncHttpProvider x0) {
        return x0.maxConnections;
    }

    static /* synthetic */ String access$500(JDKAsyncHttpProvider x0) {
        return x0.jdkNtlmDomain;
    }

    static /* synthetic */ Authenticator access$600(JDKAsyncHttpProvider x0) {
        return x0.jdkAuthenticator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class AsyncHttpUrlConnection<T>
    implements Callable<T> {
        private HttpURLConnection urlConnection;
        private Request request;
        private final AsyncHandler<T> asyncHandler;
        private final JDKFuture future;
        private int currentRedirectCount;
        private AtomicBoolean isAuth = new AtomicBoolean(false);
        private byte[] cachedBytes;
        private int cachedBytesLenght;

        public AsyncHttpUrlConnection(HttpURLConnection urlConnection, Request request, AsyncHandler<T> asyncHandler, JDKFuture future) {
            this.urlConnection = urlConnection;
            this.request = request;
            this.asyncHandler = asyncHandler;
            this.future = future;
            this.request = request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        public T call() throws Exception {
            block34: {
                block32: {
                    block33: {
                        block35: {
                            block30: {
                                block31: {
                                    state = AsyncHandler.STATE.ABORT;
                                    uri = null;
                                    try {
                                        uri = AsyncHttpProviderUtils.createUri(this.request.getRawUrl());
                                    }
                                    catch (IllegalArgumentException u) {
                                        uri = AsyncHttpProviderUtils.createUri(this.request.getUrl());
                                    }
                                    this.configure(uri, this.urlConnection, this.request);
                                    this.urlConnection.connect();
                                    statusCode = this.urlConnection.getResponseCode();
                                    if (JDKAsyncHttpProvider.access$000().isDebugEnabled()) {
                                        JDKAsyncHttpProvider.access$000().debug(String.format(AsyncHttpProviderUtils.currentThread() + "\n\nRequest %s\n\nResponse %s\n", new Object[]{this.request, statusCode}), new Object[0]);
                                    }
                                    v0 = redirectEnabled = this.request.isRedirectEnabled() != false || JDKAsyncHttpProvider.access$100(JDKAsyncHttpProvider.this).isRedirectEnabled() != false;
                                    if (!redirectEnabled || statusCode != 302 && statusCode != 301) ** GOTO lbl43
                                    if (this.currentRedirectCount++ >= JDKAsyncHttpProvider.access$100(JDKAsyncHttpProvider.this).getMaxRedirects()) ** GOTO lbl42
                                    location = this.urlConnection.getHeaderField("Location");
                                    if (location.startsWith("/")) {
                                        location = AsyncHttpProviderUtils.getBaseUrl(uri) + location;
                                    }
                                    if (location.equals(uri.toString())) break block30;
                                    newUri = AsyncHttpProviderUtils.createUri(location);
                                    builder = new RequestBuilder(this.request);
                                    newUrl = newUri.toString();
                                    if (JDKAsyncHttpProvider.access$000().isDebugEnabled()) {
                                        JDKAsyncHttpProvider.access$000().debug(String.format(AsyncHttpProviderUtils.currentThread() + "Redirecting to %s", new Object[]{newUrl}), new Object[0]);
                                    }
                                    this.request = builder.setUrl(newUrl).build();
                                    this.urlConnection = JDKAsyncHttpProvider.access$200(JDKAsyncHttpProvider.this, this.request);
                                    var9_19 = this.call();
                                    if (JDKAsyncHttpProvider.access$100(JDKAsyncHttpProvider.this).getMaxTotalConnections() == -1) break block31;
                                    JDKAsyncHttpProvider.access$400(JDKAsyncHttpProvider.this).decrementAndGet();
                                }
                                this.urlConnection.disconnect();
                                if (JDKAsyncHttpProvider.access$500(JDKAsyncHttpProvider.this) != null) {
                                    System.setProperty("http.auth.ntlm.domain", JDKAsyncHttpProvider.access$500(JDKAsyncHttpProvider.this));
                                }
                                Authenticator.setDefault(JDKAsyncHttpProvider.access$600(JDKAsyncHttpProvider.this));
                                return var9_19;
                            }
                            break block35;
lbl42:
                            // 1 sources

                            throw new MaxRedirectException("Maximum redirect reached: " + JDKAsyncHttpProvider.access$100(JDKAsyncHttpProvider.this).getMaxRedirects());
                        }
                        v1 = realm = this.request.getRealm() != null ? this.request.getRealm() : JDKAsyncHttpProvider.access$100(JDKAsyncHttpProvider.this).getRealm();
                        if (statusCode != 401 || this.isAuth.getAndSet(true) || realm == null) break block32;
                        wwwAuth = this.urlConnection.getHeaderField("WWW-Authenticate");
                        if (JDKAsyncHttpProvider.access$000().isDebugEnabled()) {
                            JDKAsyncHttpProvider.access$000().debug(String.format(AsyncHttpProviderUtils.currentThread() + "Sending authentication to %s", new Object[]{this.request.getUrl()}), new Object[0]);
                        }
                        nr = new Realm.RealmBuilder().clone(realm).parseWWWAuthenticateHeader(wwwAuth).setUri(URI.create(this.request.getUrl()).getPath()).setMethodName(this.request.getReqType()).setScheme(realm.getAuthScheme()).setUsePreemptiveAuth(true).build();
                        builder = new RequestBuilder(this.request);
                        this.request = ((RequestBuilder)builder.setRealm(nr)).build();
                        this.urlConnection = JDKAsyncHttpProvider.access$200(JDKAsyncHttpProvider.this, this.request);
                        var9_20 = this.call();
                        if (JDKAsyncHttpProvider.access$100(JDKAsyncHttpProvider.this).getMaxTotalConnections() == -1) break block33;
                        JDKAsyncHttpProvider.access$400(JDKAsyncHttpProvider.this).decrementAndGet();
                    }
                    this.urlConnection.disconnect();
                    if (JDKAsyncHttpProvider.access$500(JDKAsyncHttpProvider.this) != null) {
                        System.setProperty("http.auth.ntlm.domain", JDKAsyncHttpProvider.access$500(JDKAsyncHttpProvider.this));
                    }
                    Authenticator.setDefault(JDKAsyncHttpProvider.access$600(JDKAsyncHttpProvider.this));
                    return var9_20;
                }
                state = this.asyncHandler.onStatusReceived(new ResponseStatus(uri, this.urlConnection, JDKAsyncHttpProvider.this));
                if (state == AsyncHandler.STATE.CONTINUE) {
                    state = this.asyncHandler.onHeadersReceived(new ResponseHeaders(uri, this.urlConnection, JDKAsyncHttpProvider.this));
                }
                if (state == AsyncHandler.STATE.CONTINUE) {
                    is /* !! */  = JDKAsyncHttpProvider.access$300(JDKAsyncHttpProvider.this, this.urlConnection);
                    contentEncoding = this.urlConnection.getHeaderField("Content-Encoding");
                    v2 = isGZipped = contentEncoding == null ? false : "gzip".equalsIgnoreCase(contentEncoding);
                    if (isGZipped) {
                        is /* !! */  = new GZIPInputStream(is /* !! */ );
                    }
                    lengthWrapper = new int[1];
                    bytes = AsyncHttpProviderUtils.readFully(is /* !! */ , lengthWrapper);
                    if (lengthWrapper[0] > 0) {
                        body = new byte[lengthWrapper[0]];
                        System.arraycopy(bytes, 0, body, 0, lengthWrapper[0]);
                        this.future.touch();
                        this.asyncHandler.onBodyPartReceived(new ResponseBodyPart(uri, body, JDKAsyncHttpProvider.this));
                    }
                }
                if (ProgressAsyncHandler.class.isAssignableFrom(this.asyncHandler.getClass())) {
                    ((ProgressAsyncHandler)ProgressAsyncHandler.class.cast(this.asyncHandler)).onHeaderWriteCompleted();
                    ((ProgressAsyncHandler)ProgressAsyncHandler.class.cast(this.asyncHandler)).onContentWriteCompleted();
                }
                is /* !! */  = this.asyncHandler.onCompleted();
                if (JDKAsyncHttpProvider.access$100(JDKAsyncHttpProvider.this).getMaxTotalConnections() == -1) break block34;
                JDKAsyncHttpProvider.access$400(JDKAsyncHttpProvider.this).decrementAndGet();
            }
            this.urlConnection.disconnect();
            if (JDKAsyncHttpProvider.access$500(JDKAsyncHttpProvider.this) != null) {
                System.setProperty("http.auth.ntlm.domain", JDKAsyncHttpProvider.access$500(JDKAsyncHttpProvider.this));
            }
            Authenticator.setDefault(JDKAsyncHttpProvider.access$600(JDKAsyncHttpProvider.this));
            return (T)is /* !! */ ;
            {
                catch (Throwable t) {
                    try {
                        try {
                            ex = new RuntimeException();
                            ex.initCause(t);
                            throw ex;
                        }
                        catch (Throwable t) {
                            if (JDKAsyncHttpProvider.access$000().isDebugEnabled()) {
                                JDKAsyncHttpProvider.access$000().debug(t);
                            }
                            try {
                                this.future.abort(this.filterException(t));
                            }
                            catch (Throwable t2) {
                                JDKAsyncHttpProvider.access$000().error(t2);
                            }
                            if (JDKAsyncHttpProvider.access$100(JDKAsyncHttpProvider.this).getMaxTotalConnections() != -1) {
                                JDKAsyncHttpProvider.access$400(JDKAsyncHttpProvider.this).decrementAndGet();
                            }
                            this.urlConnection.disconnect();
                            if (JDKAsyncHttpProvider.access$500(JDKAsyncHttpProvider.this) != null) {
                                System.setProperty("http.auth.ntlm.domain", JDKAsyncHttpProvider.access$500(JDKAsyncHttpProvider.this));
                            }
                            Authenticator.setDefault(JDKAsyncHttpProvider.access$600(JDKAsyncHttpProvider.this));
                        }
                    }
                    catch (Throwable var12_24) {
                        if (JDKAsyncHttpProvider.access$100(JDKAsyncHttpProvider.this).getMaxTotalConnections() != -1) {
                            JDKAsyncHttpProvider.access$400(JDKAsyncHttpProvider.this).decrementAndGet();
                        }
                        this.urlConnection.disconnect();
                        if (JDKAsyncHttpProvider.access$500(JDKAsyncHttpProvider.this) != null) {
                            System.setProperty("http.auth.ntlm.domain", JDKAsyncHttpProvider.access$500(JDKAsyncHttpProvider.this));
                        }
                        Authenticator.setDefault(JDKAsyncHttpProvider.access$600(JDKAsyncHttpProvider.this));
                        throw var12_24;
                    }
                }
            }
            return null;
        }

        private Throwable filterException(Throwable t) {
            if (UnknownHostException.class.isAssignableFrom(t.getClass())) {
                t = new ConnectException(t.getMessage());
            }
            if (SocketTimeoutException.class.isAssignableFrom(t.getClass())) {
                int responseTimeoutInMs = JDKAsyncHttpProvider.this.config.getRequestTimeoutInMs();
                if (this.request.getPerRequestConfig() != null && this.request.getPerRequestConfig().getRequestTimeoutInMs() != -1) {
                    responseTimeoutInMs = this.request.getPerRequestConfig().getRequestTimeoutInMs();
                }
                t = new TimeoutException(String.format("No response received after %s", responseTimeoutInMs));
            }
            if (SSLHandshakeException.class.isAssignableFrom(t.getClass())) {
                ConnectException t2 = new ConnectException();
                t2.initCause(t);
                t = t2;
            }
            return t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void configure(URI uri, HttpURLConnection urlConnection, Request request) throws IOException, AuthenticationException {
            Realm realm;
            ProxyServer proxyServer;
            FluentCaseInsensitiveStringsMap h;
            PerRequestConfig conf = request.getPerRequestConfig();
            int requestTimeout = conf != null && conf.getRequestTimeoutInMs() != 0 ? conf.getRequestTimeoutInMs() : JDKAsyncHttpProvider.this.config.getRequestTimeoutInMs();
            urlConnection.setConnectTimeout(JDKAsyncHttpProvider.this.config.getConnectionTimeoutInMs());
            if (requestTimeout != -1) {
                urlConnection.setReadTimeout(requestTimeout);
            }
            urlConnection.setInstanceFollowRedirects(false);
            String host = uri.getHost();
            String method = request.getReqType();
            if (request.getVirtualHost() != null) {
                host = request.getVirtualHost();
            }
            if (uri.getPort() == -1) {
                urlConnection.setRequestProperty("Host", host);
            } else {
                urlConnection.setRequestProperty("Host", host + ":" + uri.getPort());
            }
            if (JDKAsyncHttpProvider.this.config.isCompressionEnabled()) {
                urlConnection.setRequestProperty("Accept-Encoding", "gzip");
            }
            boolean contentTypeSet = false;
            if (!method.equalsIgnoreCase("CONNECT") && (h = request.getHeaders()) != null) {
                for (String name : h.keySet()) {
                    if ("host".equalsIgnoreCase(name)) continue;
                    Iterator i$ = h.get(name).iterator();
                    while (i$.hasNext()) {
                        String value = (String)i$.next();
                        urlConnection.setRequestProperty(name, value);
                    }
                }
            }
            String ka = JDKAsyncHttpProvider.this.config.getAllowPoolingConnection() ? "keep-alive" : "close";
            urlConnection.setRequestProperty("Connection", ka);
            ProxyServer proxyServer2 = proxyServer = request.getProxyServer() != null ? request.getProxyServer() : JDKAsyncHttpProvider.this.config.getProxyServer();
            if (proxyServer != null) {
                urlConnection.setRequestProperty("Proxy-Connection", ka);
                if (proxyServer.getPrincipal() != null) {
                    urlConnection.setRequestProperty("Proxy-Authorization", AuthenticatorUtils.computeBasicAuthentication(proxyServer));
                }
            }
            Realm realm2 = realm = request.getRealm() != null ? request.getRealm() : JDKAsyncHttpProvider.this.config.getRealm();
            if (realm != null && realm.getUsePreemptiveAuth()) {
                switch (realm.getAuthScheme()) {
                    case BASIC: {
                        urlConnection.setRequestProperty("Authorization", AuthenticatorUtils.computeBasicAuthentication(realm));
                        break;
                    }
                    case DIGEST: {
                        if (realm.getNonce() == null || realm.getNonce().equals("")) break;
                        try {
                            urlConnection.setRequestProperty("Authorization", AuthenticatorUtils.computeDigestAuthentication(realm));
                            break;
                        }
                        catch (NoSuchAlgorithmException e) {
                            throw new SecurityException(e);
                        }
                    }
                    default: {
                        throw new IllegalStateException(String.format(AsyncHttpProviderUtils.currentThread() + "Invalid Authentication %s", realm.toString()));
                    }
                }
            }
            if (realm != null && realm.getDomain() != null && realm.getScheme() == Realm.AuthScheme.NTLM) {
                JDKAsyncHttpProvider.this.jdkNtlmDomain = System.getProperty(JDKAsyncHttpProvider.NTLM_DOMAIN);
                System.setProperty(JDKAsyncHttpProvider.NTLM_DOMAIN, realm.getDomain());
            }
            if (request.getHeaders().getFirstValue("Accept") == null) {
                urlConnection.setRequestProperty("Accept", "*/*");
            }
            if (request.getHeaders().getFirstValue("User-Agent") == null && JDKAsyncHttpProvider.this.config.getUserAgent() != null) {
                urlConnection.setRequestProperty("User-Agent", JDKAsyncHttpProvider.this.config.getUserAgent());
            } else {
                urlConnection.setRequestProperty("User-Agent", AsyncHttpProviderUtils.constructUserAgent(JDKAsyncHttpProvider.class));
            }
            if (request.getCookies() != null && !request.getCookies().isEmpty()) {
                urlConnection.setRequestProperty("Cookie", AsyncHttpProviderUtils.encodeCookies(request.getCookies()));
            }
            String reqType = request.getReqType();
            urlConnection.setRequestMethod(reqType);
            if (!"POST".equals(reqType)) {
                if (!"PUT".equals(reqType)) return;
            }
            urlConnection.setRequestProperty("Content-Length", "0");
            urlConnection.setDoOutput(true);
            if (this.cachedBytes != null) {
                urlConnection.setRequestProperty("Content-Length", String.valueOf(this.cachedBytesLenght));
                urlConnection.setFixedLengthStreamingMode(this.cachedBytesLenght);
                urlConnection.getOutputStream().write(this.cachedBytes, 0, this.cachedBytesLenght);
                return;
            }
            if (request.getByteData() != null) {
                urlConnection.setRequestProperty("Content-Length", String.valueOf(request.getByteData().length));
                urlConnection.setFixedLengthStreamingMode(request.getByteData().length);
                urlConnection.getOutputStream().write(request.getByteData());
                return;
            }
            if (request.getStringData() != null) {
                urlConnection.setRequestProperty("Content-Length", String.valueOf(request.getStringData().length()));
                urlConnection.getOutputStream().write(request.getStringData().getBytes("UTF-8"));
                return;
            }
            if (request.getStreamData() != null) {
                int[] lengthWrapper = new int[1];
                this.cachedBytes = AsyncHttpProviderUtils.readFully(request.getStreamData(), lengthWrapper);
                this.cachedBytesLenght = lengthWrapper[0];
                urlConnection.setRequestProperty("Content-Length", String.valueOf(this.cachedBytesLenght));
                urlConnection.setFixedLengthStreamingMode(this.cachedBytesLenght);
                urlConnection.getOutputStream().write(this.cachedBytes, 0, this.cachedBytesLenght);
                return;
            }
            if (request.getParams() != null) {
                StringBuilder sb = new StringBuilder();
                for (Map.Entry<String, List<String>> paramEntry : request.getParams()) {
                    String key = paramEntry.getKey();
                    for (String value : paramEntry.getValue()) {
                        if (sb.length() > 0) {
                            sb.append("&");
                        }
                        UTF8UrlEncoder.appendEncoded(sb, key);
                        sb.append("=");
                        UTF8UrlEncoder.appendEncoded(sb, value);
                    }
                }
                urlConnection.setRequestProperty("Content-Length", String.valueOf(sb.length()));
                urlConnection.setFixedLengthStreamingMode(sb.length());
                if (!request.getHeaders().containsKey("Content-Type")) {
                    urlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                }
                urlConnection.getOutputStream().write(sb.toString().getBytes("UTF-8"));
                return;
            }
            if (request.getParts() != null) {
                int lenght = (int)request.getLength();
                if (lenght != -1) {
                    urlConnection.setRequestProperty("Content-Length", String.valueOf(lenght));
                    urlConnection.setFixedLengthStreamingMode(lenght);
                }
                if (lenght == -1) {
                    lenght = 8192;
                }
                MultipartRequestEntity mre = AsyncHttpProviderUtils.createMultipartRequestEntity(request.getParts(), request.getParams());
                urlConnection.setRequestProperty("Content-Type", mre.getContentType());
                urlConnection.setRequestProperty("Content-Length", String.valueOf(mre.getContentLength()));
                ChannelBuffer b = ChannelBuffers.dynamicBuffer((int)lenght);
                mre.writeRequest(urlConnection.getOutputStream());
                return;
            }
            if (request.getEntityWriter() != null) {
                int lenght = (int)request.getLength();
                if (lenght != -1) {
                    urlConnection.setRequestProperty("Content-Length", String.valueOf(lenght));
                    urlConnection.setFixedLengthStreamingMode(lenght);
                }
                request.getEntityWriter().writeEntity(urlConnection.getOutputStream());
                return;
            }
            if (request.getFile() != null) {
                File file = request.getFile();
                if (!file.isFile()) {
                    throw new IOException(String.format(Thread.currentThread() + "File %s is not a file or doesn't exist", file.getAbsolutePath()));
                }
                urlConnection.setRequestProperty("Content-Length", String.valueOf(file.length()));
                urlConnection.setFixedLengthStreamingMode((int)file.length());
                FileInputStream fis = new FileInputStream(file);
                try {
                    OutputStream os = urlConnection.getOutputStream();
                    byte[] buffer = new byte[16384];
                    while (true) {
                        int read;
                        if ((read = fis.read(buffer)) < 0) {
                            return;
                        }
                        os.write(buffer, 0, read);
                    }
                }
                finally {
                    fis.close();
                }
            }
            if (request.getBodyGenerator() == null) return;
            Body body = request.getBodyGenerator().createBody();
            try {
                int length = (int)body.getContentLength();
                if (length < 0) {
                    length = (int)request.getLength();
                }
                if (length >= 0) {
                    urlConnection.setRequestProperty("Content-Length", String.valueOf(length));
                    urlConnection.setFixedLengthStreamingMode(length);
                }
                OutputStream os = urlConnection.getOutputStream();
                ByteBuffer buffer = ByteBuffer.allocate(8192);
                while (true) {
                    buffer.clear();
                    if (body.read(buffer) >= 0L) {
                        os.write(buffer.array(), buffer.arrayOffset(), buffer.position());
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                try {
                    body.close();
                    throw throwable;
                }
                catch (IOException e) {
                    logger.warn(e, "Failed to close request body: %s", e.getMessage());
                }
                throw throwable;
            }
            try {
                body.close();
                return;
            }
            catch (IOException e) {
                logger.warn(e, "Failed to close request body: %s", e.getMessage());
                return;
            }
        }
    }
}

