/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.logging;

import com.ning.http.client.logging.JulLoggerProvider;
import com.ning.http.client.logging.Logger;
import com.ning.http.client.logging.LoggerProvider;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogManager {
    private static final AtomicReference<LoggerProvider> providerRef = new AtomicReference();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initProvider() {
        String providerClass = System.getProperty("com.ning.http.client.logging.LoggerProvider.class", JulLoggerProvider.class.getName());
        LoggerProvider providerToUse = null;
        try {
            Class<?> clazz = Class.forName(providerClass);
            if (LoggerProvider.class.isAssignableFrom(clazz)) {
                providerToUse = (LoggerProvider)clazz.newInstance();
            } else {
                providerToUse = new JulLoggerProvider();
                providerToUse.getLogger(LogManager.class).warn("Specified logger provider class %s does not implement the %s interface", providerClass, LoggerProvider.class.getName());
            }
            providerRef.set(providerToUse);
        }
        catch (Throwable ex) {
            try {
                providerToUse = new JulLoggerProvider();
                providerToUse.getLogger(LogManager.class).warn(ex, "Could not instantiate the logger provider class %s", providerClass);
                providerRef.set(providerToUse);
            }
            catch (Throwable throwable) {
                providerRef.set(providerToUse);
                throw throwable;
            }
        }
    }

    public static Logger getLogger(Class<?> clazz) {
        LoggerProvider provider = providerRef.get();
        if (provider == null) {
            LogManager.initProvider();
        }
        return providerRef.get().getLogger(clazz);
    }

    public static void setProvider(LoggerProvider provider) {
        providerRef.set(provider);
    }
}

