/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client;

import com.ning.http.client.Cookie;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.HttpContent;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Response {
    public int getStatusCode();

    public String getStatusText();

    public InputStream getResponseBodyAsStream() throws IOException;

    public String getResponseBodyExcerpt(int var1) throws IOException;

    public String getResponseBody() throws IOException;

    public URI getUri() throws MalformedURLException;

    public String getContentType();

    public String getHeader(String var1);

    public List<String> getHeaders(String var1);

    public FluentCaseInsensitiveStringsMap getHeaders();

    public boolean isRedirected();

    public String toString();

    public List<Cookie> getCookies();

    public boolean hasResponseStatus();

    public boolean hasResponseHeaders();

    public boolean hasResponseBody();

    public static class ResponseBuilder {
        private final Collection<HttpResponseBodyPart> bodies = Collections.synchronizedCollection(new ArrayList());
        private HttpResponseStatus status;
        private HttpResponseHeaders headers;

        public ResponseBuilder accumulate(HttpContent httpContent) {
            if (httpContent instanceof HttpResponseStatus) {
                this.status = (HttpResponseStatus)httpContent;
            } else if (httpContent instanceof HttpResponseHeaders) {
                this.headers = (HttpResponseHeaders)httpContent;
            } else if (httpContent instanceof HttpResponseBodyPart) {
                this.bodies.add((HttpResponseBodyPart)httpContent);
            }
            return this;
        }

        public Response build() {
            return this.status == null ? null : this.status.provider().prepareResponse(this.status, this.headers, this.bodies);
        }
    }
}

