/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.Request;
import com.ning.http.client.logging.LogManager;
import com.ning.http.client.logging.Logger;
import com.ning.http.client.providers.netty.NettyAsyncHttpProvider;
import com.ning.http.client.providers.netty.NettyResponseFuture;
import com.ning.http.util.AsyncHttpProviderUtils;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.ssl.SslHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NettyConnectListener<T>
implements ChannelFutureListener {
    private final AsyncHttpClientConfig config;
    private final NettyResponseFuture<T> future;
    private final HttpRequest nettyRequest;
    private final AtomicBoolean handshakeDone = new AtomicBoolean(false);

    private NettyConnectListener(AsyncHttpClientConfig config, NettyResponseFuture<T> future, HttpRequest nettyRequest) {
        this.config = config;
        this.future = future;
        this.nettyRequest = nettyRequest;
    }

    public NettyResponseFuture<T> future() {
        return this.future;
    }

    public final void operationComplete(ChannelFuture f) throws Exception {
        if (f.isSuccess()) {
            if (!this.handshakeDone.getAndSet(true) && f.getChannel().getPipeline().get("sslHandler") != null) {
                ((SslHandler)f.getChannel().getPipeline().get("sslHandler")).handshake().addListener((ChannelFutureListener)this);
                return;
            }
            f.getChannel().getPipeline().getContext(NettyAsyncHttpProvider.class).setAttachment(this.future);
            this.future.provider().writeRequest(f.getChannel(), this.config, this.future, this.nettyRequest);
        } else {
            if ((ClosedChannelException.class.isAssignableFrom(f.getCause().getClass()) || this.future.getState() != NettyResponseFuture.STATE.NEW) && this.future.provider().remotelyClosed(f.getChannel(), this.future)) {
                return;
            }
            ConnectException e = new ConnectException(f.getCause() != null ? f.getCause().getMessage() : this.future.getURI().toString());
            e.initCause(f.getCause());
            this.future.abort(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder<T> {
        private final Logger log = LogManager.getLogger(Builder.class);
        private final AsyncHttpClientConfig config;
        private final Request request;
        private final AsyncHandler<T> asyncHandler;
        private NettyResponseFuture<T> future;
        private final NettyAsyncHttpProvider provider;

        public Builder(AsyncHttpClientConfig config, Request request, AsyncHandler<T> asyncHandler, NettyAsyncHttpProvider provider) {
            this.config = config;
            this.request = request;
            this.asyncHandler = asyncHandler;
            this.future = null;
            this.provider = provider;
        }

        public Builder(AsyncHttpClientConfig config, Request request, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> future, NettyAsyncHttpProvider provider) {
            this.config = config;
            this.request = request;
            this.asyncHandler = asyncHandler;
            this.future = future;
            this.provider = provider;
        }

        public NettyConnectListener<T> build() throws IOException {
            URI uri = AsyncHttpProviderUtils.createUri(this.request.getRawUrl().replace(" ", "%20"));
            HttpRequest nettyRequest = NettyAsyncHttpProvider.buildRequest(this.config, this.request, uri, true, null);
            if (this.future == null) {
                this.future = new NettyResponseFuture<T>(uri, this.request, this.asyncHandler, nettyRequest, NettyAsyncHttpProvider.requestTimeout(this.config, this.request.getPerRequestConfig()), this.provider);
            }
            return new NettyConnectListener(this.config, this.future, nettyRequest);
        }
    }
}

