/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.Body;
import com.ning.http.client.ConnectionsPool;
import com.ning.http.client.Cookie;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.MaxRedirectException;
import com.ning.http.client.PerRequestConfig;
import com.ning.http.client.ProgressAsyncHandler;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.RandomAccessBody;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.logging.LogManager;
import com.ning.http.client.logging.Logger;
import com.ning.http.client.providers.jdk.JDKAsyncHttpProvider;
import com.ning.http.client.providers.netty.BodyChunkedInput;
import com.ning.http.client.providers.netty.BodyFileRegion;
import com.ning.http.client.providers.netty.NettyAsyncHttpProviderConfig;
import com.ning.http.client.providers.netty.NettyAsyncResponse;
import com.ning.http.client.providers.netty.NettyConnectListener;
import com.ning.http.client.providers.netty.NettyConnectionsPool;
import com.ning.http.client.providers.netty.NettyResponseFuture;
import com.ning.http.client.providers.netty.ResponseBodyPart;
import com.ning.http.client.providers.netty.ResponseHeaders;
import com.ning.http.client.providers.netty.ResponseStatus;
import com.ning.http.multipart.MultipartRequestEntity;
import com.ning.http.util.AsyncHttpProviderUtils;
import com.ning.http.util.AuthenticatorUtils;
import com.ning.http.util.SslUtils;
import com.ning.http.util.UTF8UrlEncoder;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLEngine;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelFutureProgressListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.DefaultChannelFuture;
import org.jboss.netty.channel.DefaultFileRegion;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.FileRegion;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.oio.OioClientSocketChannelFactory;
import org.jboss.netty.handler.codec.http.CookieEncoder;
import org.jboss.netty.handler.codec.http.DefaultCookie;
import org.jboss.netty.handler.codec.http.DefaultHttpChunkTrailer;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpClientCodec;
import org.jboss.netty.handler.codec.http.HttpContentDecompressor;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedFile;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.jboss.netty.handler.timeout.IdleState;
import org.jboss.netty.handler.timeout.IdleStateHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NettyAsyncHttpProvider
extends IdleStateHandler
implements AsyncHttpProvider<HttpResponse> {
    private static final String HTTP_HANDLER = "httpHandler";
    static final String SSL_HANDLER = "sslHandler";
    private static final String HTTPS = "https";
    private static final String HTTP = "http";
    private static final Logger log = LogManager.getLogger(NettyAsyncHttpProvider.class);
    private final ClientBootstrap plainBootstrap;
    private final ClientBootstrap secureBootstrap;
    private static final int MAX_BUFFERED_BYTES = 8192;
    private final AsyncHttpClientConfig config;
    private final AtomicBoolean isClose = new AtomicBoolean(false);
    private final ClientSocketChannelFactory socketChannelFactory;
    private final ChannelGroup openChannels = new DefaultChannelGroup("asyncHttpClient");
    private final ConnectionsPool<String, Channel> connectionsPool;
    private final JDKAsyncHttpProvider ntlmProvider;
    private final AtomicInteger maxConnections = new AtomicInteger();
    private final NettyAsyncHttpProviderConfig asyncHttpProviderConfig;
    private boolean executeConnectAsync = false;
    public static final ThreadLocal<Boolean> IN_IO_THREAD = new ThreadLocalBoolean();

    public NettyAsyncHttpProvider(AsyncHttpClientConfig config) {
        super((Timer)new HashedWheelTimer(), 0L, 0L, (long)config.getIdleConnectionTimeoutInMs(), TimeUnit.MILLISECONDS);
        this.asyncHttpProviderConfig = config.getAsyncHttpProviderConfig() != null && NettyAsyncHttpProviderConfig.class.isAssignableFrom(config.getAsyncHttpProviderConfig().getClass()) ? (NettyAsyncHttpProviderConfig)NettyAsyncHttpProviderConfig.class.cast(config.getAsyncHttpProviderConfig()) : null;
        this.socketChannelFactory = this.asyncHttpProviderConfig != null && this.asyncHttpProviderConfig.getProperty("useBlockingIO") != null ? new OioClientSocketChannelFactory((Executor)config.executorService()) : new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)config.executorService());
        this.plainBootstrap = new ClientBootstrap((ChannelFactory)this.socketChannelFactory);
        this.secureBootstrap = new ClientBootstrap((ChannelFactory)this.socketChannelFactory);
        this.config = config;
        NettyConnectionsPool cp = config.getConnectionsPool();
        if (cp == null) {
            cp = new NettyConnectionsPool(config);
        }
        this.connectionsPool = cp;
        this.configureNetty();
        this.ntlmProvider = new JDKAsyncHttpProvider(config);
    }

    void configureNetty() {
        if (this.asyncHttpProviderConfig != null) {
            for (Map.Entry<String, Object> entry : this.asyncHttpProviderConfig.propertiesSet()) {
                this.plainBootstrap.setOption(entry.getKey(), entry.getValue());
            }
        }
        this.plainBootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast(NettyAsyncHttpProvider.HTTP_HANDLER, (ChannelHandler)new HttpClientCodec());
                if (NettyAsyncHttpProvider.this.config.isCompressionEnabled()) {
                    pipeline.addLast("inflater", (ChannelHandler)new HttpContentDecompressor());
                }
                pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
                pipeline.addLast("httpProcessor", (ChannelHandler)NettyAsyncHttpProvider.this);
                return pipeline;
            }
        });
        if (this.asyncHttpProviderConfig != null) {
            if (this.asyncHttpProviderConfig.getProperty("asyncConnect") != null) {
                this.executeConnectAsync = true;
            } else if (this.asyncHttpProviderConfig.getProperty("allowNestedRequest") != null) {
                DefaultChannelFuture.setUseDeadLockChecker((boolean)false);
            }
        }
    }

    void constructSSLPipeline(final NettyConnectListener<?> cl) {
        this.secureBootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                try {
                    pipeline.addLast(NettyAsyncHttpProvider.SSL_HANDLER, (ChannelHandler)new SslHandler(NettyAsyncHttpProvider.this.createSSLEngine()));
                }
                catch (Throwable ex) {
                    NettyAsyncHttpProvider.this.abort(cl.future(), ex);
                }
                pipeline.addLast(NettyAsyncHttpProvider.HTTP_HANDLER, (ChannelHandler)new HttpClientCodec());
                if (NettyAsyncHttpProvider.this.config.isCompressionEnabled()) {
                    pipeline.addLast("inflater", (ChannelHandler)new HttpContentDecompressor());
                }
                pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
                pipeline.addLast("httpProcessor", (ChannelHandler)NettyAsyncHttpProvider.this);
                return pipeline;
            }
        });
        if (this.asyncHttpProviderConfig != null) {
            for (Map.Entry<String, Object> entry : this.asyncHttpProviderConfig.propertiesSet()) {
                this.secureBootstrap.setOption(entry.getKey(), entry.getValue());
            }
        }
    }

    private Channel lookupInCache(URI uri) {
        block8: {
            final Channel channel = this.connectionsPool.removeConnection(AsyncHttpProviderUtils.getBaseUrl(uri));
            if (channel != null) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format(NettyAsyncHttpProvider.currentThread() + "Using cached Channel %s", uri, channel), new Object[0]);
                }
                if (channel.isOpen() && channel.isBound()) {
                    try {
                        return this.config.executorService().submit(new Callable<Boolean>(){

                            @Override
                            public Boolean call() {
                                try {
                                    channel.setReadable(true);
                                }
                                catch (Exception ex) {
                                    if (log.isDebugEnabled()) {
                                        log.debug(ex);
                                    }
                                    NettyAsyncHttpProvider.this.connectionsPool.removeAllConnections(channel);
                                    return new Boolean(false);
                                }
                                return new Boolean(true);
                            }
                        }).get() != false ? channel : null;
                    }
                    catch (Throwable e) {
                    }
                } else {
                    return null;
                }
                try {
                    return this.verifyChannelPipeline(channel, uri.getScheme());
                }
                catch (Exception ex) {
                    if (!log.isDebugEnabled()) break block8;
                    log.debug(NettyAsyncHttpProvider.currentThread() + ex.getMessage(), new Object[0]);
                    log.debug(ex);
                }
            }
        }
        return null;
    }

    private SSLEngine createSSLEngine() throws IOException, GeneralSecurityException {
        SSLEngine sslEngine = this.config.getSSLEngineFactory().newSSLEngine();
        if (sslEngine == null) {
            sslEngine = SslUtils.getSSLEngine();
        }
        return sslEngine;
    }

    private Channel verifyChannelPipeline(Channel channel, String scheme) throws IOException, GeneralSecurityException {
        if (channel.getPipeline().get(SSL_HANDLER) != null && HTTP.equalsIgnoreCase(scheme)) {
            channel.getPipeline().remove(SSL_HANDLER);
        } else {
            if (channel.getPipeline().get(HTTP_HANDLER) != null && HTTP.equalsIgnoreCase(scheme)) {
                return channel;
            }
            if (channel.getPipeline().get(SSL_HANDLER) == null && HTTPS.equalsIgnoreCase(scheme)) {
                channel.getPipeline().addFirst(SSL_HANDLER, (ChannelHandler)new SslHandler(this.createSSLEngine()));
            }
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <T> void writeRequest(Channel channel, AsyncHttpClientConfig config, NettyResponseFuture<T> future, HttpRequest nettyRequest) {
        block29: {
            try {
                if (!(channel.isOpen() && channel.isConnected() || this.remotelyClosed(channel, future))) {
                    this.abort(future, new ConnectException());
                    return;
                }
                Body body = null;
                if (!future.getNettyRequest().getMethod().equals((Object)HttpMethod.CONNECT)) {
                    if (future.getRequest().getBodyGenerator() != null) {
                        try {
                            body = future.getRequest().getBodyGenerator().createBody();
                        }
                        catch (IOException ex) {
                            throw new IllegalStateException(ex);
                        }
                        long length = body.getContentLength();
                        if (length >= 0L) {
                            nettyRequest.setHeader("Content-Length", (Object)length);
                        }
                    } else {
                        body = null;
                    }
                }
                try {
                    channel.write((Object)nettyRequest).addListener((ChannelFutureListener)new ProgressListener(true, future.getAsyncHandler(), future));
                }
                catch (Throwable cause) {
                    if (log.isDebugEnabled()) {
                        log.debug(cause);
                    }
                    if (future.provider().remotelyClosed(channel, future)) {
                        return;
                    }
                    future.abort(cause);
                }
                if (future.getNettyRequest().getMethod().equals((Object)HttpMethod.CONNECT)) break block29;
                RandomAccessFile raf = null;
                if (future.getRequest().getFile() != null) {
                    File file = future.getRequest().getFile();
                    long fileLength = 0L;
                    try {
                        raf = new RandomAccessFile(file, "r");
                        fileLength = raf.length();
                        if (channel.getPipeline().get(SslHandler.class) != null) {
                            ChannelFuture writeFuture = channel.write((Object)new ChunkedFile(raf, 0L, fileLength, 8192));
                            writeFuture.addListener((ChannelFutureListener)new ProgressListener(false, future.getAsyncHandler(), future));
                        } else {
                            DefaultFileRegion region = new DefaultFileRegion(raf.getChannel(), 0L, fileLength);
                            ChannelFuture writeFuture = channel.write((Object)region);
                            writeFuture.addListener((ChannelFutureListener)new ProgressListener(false, future.getAsyncHandler(), future, (FileRegion)region){
                                final /* synthetic */ FileRegion val$region;
                                {
                                    this.val$region = fileRegion;
                                    super(x0, x1, x2);
                                }

                                public void operationComplete(ChannelFuture cf) {
                                    this.val$region.releaseExternalResources();
                                    super.operationComplete(cf);
                                }
                            });
                        }
                        break block29;
                    }
                    finally {
                        if (raf != null) {
                            try {
                                raf.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                }
                if (body != null) {
                    ChannelFuture writeFuture = channel.getPipeline().get(SslHandler.class) == null && body instanceof RandomAccessBody ? channel.write((Object)new BodyFileRegion((RandomAccessBody)body)) : channel.write((Object)new BodyChunkedInput(body));
                    final Body b = body;
                    writeFuture.addListener((ChannelFutureListener)new ProgressListener(false, future.getAsyncHandler(), future){

                        public void operationComplete(ChannelFuture cf) {
                            try {
                                b.close();
                            }
                            catch (IOException e) {
                                log.warn(e, "Failed to close request body: %s", e.getMessage());
                            }
                            super.operationComplete(cf);
                        }
                    });
                }
            }
            catch (Throwable ioe) {
                if (future.provider().remotelyClosed(channel, future)) {
                    return;
                }
                this.abort(future, ioe);
            }
        }
        try {
            future.touch();
            int delay = NettyAsyncHttpProvider.requestTimeout(config, future.getRequest().getPerRequestConfig());
            if (delay != -1) {
                ReaperFuture reaperFuture = new ReaperFuture(channel, future);
                ScheduledFuture<?> scheduledFuture = config.reaper().scheduleAtFixedRate(reaperFuture, delay, delay, TimeUnit.MILLISECONDS);
                reaperFuture.setScheduledFuture(scheduledFuture);
                future.setReaperFuture(reaperFuture);
            }
        }
        catch (RejectedExecutionException ex) {
            this.abort(future, ex);
        }
    }

    protected static final HttpRequest buildRequest(AsyncHttpClientConfig config, Request request, URI uri, boolean allowConnect, ChannelBuffer buffer) throws IOException {
        String method = request.getReqType();
        if (allowConnect && (request.getProxyServer() != null || config.getProxyServer() != null) && HTTPS.equalsIgnoreCase(uri.getScheme())) {
            method = HttpMethod.CONNECT.toString();
        }
        return NettyAsyncHttpProvider.construct(config, request, new HttpMethod(method), uri, buffer);
    }

    private static HttpRequest construct(AsyncHttpClientConfig config, Request request, HttpMethod m, URI uri, ChannelBuffer buffer) throws IOException {
        ProxyServer proxyServer;
        Realm realm;
        DefaultHttpRequest nettyRequest;
        String host = uri.getHost();
        if (request.getVirtualHost() != null) {
            host = request.getVirtualHost();
        }
        if (m.equals((Object)HttpMethod.CONNECT)) {
            uri = URI.create(uri.getHost() + ":" + AsyncHttpProviderUtils.getPort(uri));
            nettyRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_0, m, uri.toString());
        } else if (config.getProxyServer() != null || request.getProxyServer() != null) {
            nettyRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, m, uri.toString());
        } else {
            StringBuilder path = new StringBuilder(uri.getRawPath());
            if (uri.getQuery() != null) {
                path.append("?").append(uri.getRawQuery());
            }
            nettyRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, m, path.toString());
        }
        if (uri.getPort() == -1) {
            nettyRequest.setHeader("Host", (Object)host);
        } else {
            nettyRequest.setHeader("Host", (Object)(host + ":" + uri.getPort()));
        }
        if (!m.equals((Object)HttpMethod.CONNECT)) {
            FluentCaseInsensitiveStringsMap h = request.getHeaders();
            if (h != null) {
                for (String name : h.keySet()) {
                    if ("host".equalsIgnoreCase(name)) continue;
                    Iterator i$ = h.get(name).iterator();
                    while (i$.hasNext()) {
                        String value = (String)i$.next();
                        nettyRequest.addHeader(name, (Object)value);
                    }
                }
            }
            if (config.isCompressionEnabled()) {
                nettyRequest.setHeader("Accept-Encoding", (Object)"gzip");
            }
        }
        Realm realm2 = realm = request.getRealm() != null ? request.getRealm() : config.getRealm();
        if (realm != null && realm.getUsePreemptiveAuth()) {
            switch (realm.getAuthScheme()) {
                case BASIC: {
                    nettyRequest.setHeader("Authorization", (Object)AuthenticatorUtils.computeBasicAuthentication(realm));
                    break;
                }
                case DIGEST: {
                    if (realm.getNonce() == null || realm.getNonce().equals("")) break;
                    try {
                        nettyRequest.setHeader("Authorization", (Object)AuthenticatorUtils.computeDigestAuthentication(realm));
                        break;
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new SecurityException(e);
                    }
                }
                default: {
                    throw new IllegalStateException(String.format(NettyAsyncHttpProvider.currentThread() + "Invalid Authentication %s", realm.toString()));
                }
            }
        }
        String ka = config.getKeepAlive() ? "keep-alive" : "close";
        nettyRequest.setHeader("Connection", (Object)ka);
        ProxyServer proxyServer2 = proxyServer = request.getProxyServer() != null ? request.getProxyServer() : config.getProxyServer();
        if (proxyServer != null) {
            nettyRequest.setHeader("Proxy-Connection", (Object)ka);
            if (proxyServer.getPrincipal() != null) {
                nettyRequest.setHeader("Proxy-Authorization", (Object)AuthenticatorUtils.computeBasicAuthentication(proxyServer));
            }
        }
        if (request.getHeaders().getFirstValue("Accept") == null) {
            nettyRequest.setHeader("Accept", (Object)"*/*");
        }
        if (request.getHeaders().getFirstValue("User-Agent") == null && config.getUserAgent() != null) {
            nettyRequest.setHeader("User-Agent", (Object)config.getUserAgent());
        }
        if (!m.equals((Object)HttpMethod.CONNECT)) {
            String reqType;
            if (request.getCookies() != null && !request.getCookies().isEmpty()) {
                CookieEncoder httpCookieEncoder = new CookieEncoder(false);
                for (Cookie c : request.getCookies()) {
                    DefaultCookie cookie = new DefaultCookie(c.getName(), c.getValue());
                    cookie.setPath(c.getPath());
                    cookie.setMaxAge(c.getMaxAge());
                    cookie.setDomain(c.getDomain());
                    httpCookieEncoder.addCookie((org.jboss.netty.handler.codec.http.Cookie)cookie);
                }
                nettyRequest.setHeader("Cookie", (Object)httpCookieEncoder.encode());
            }
            if ("POST".equals(reqType = request.getReqType()) || "PUT".equals(reqType)) {
                nettyRequest.setHeader("Content-Length", (Object)"0");
                if (buffer != null && buffer.writerIndex() != 0) {
                    nettyRequest.setHeader("Content-Length", (Object)buffer.writerIndex());
                    nettyRequest.setContent(buffer);
                } else if (request.getByteData() != null) {
                    nettyRequest.setHeader("Content-Length", (Object)String.valueOf(request.getByteData().length));
                    nettyRequest.setContent(ChannelBuffers.copiedBuffer((byte[])request.getByteData()));
                } else if (request.getStringData() != null) {
                    nettyRequest.setHeader("Content-Length", (Object)String.valueOf(request.getStringData().length()));
                    nettyRequest.setContent(ChannelBuffers.copiedBuffer((String)request.getStringData(), (String)"UTF-8"));
                } else if (request.getStreamData() != null) {
                    int[] lengthWrapper = new int[1];
                    byte[] bytes = AsyncHttpProviderUtils.readFully(request.getStreamData(), lengthWrapper);
                    int length = lengthWrapper[0];
                    nettyRequest.setHeader("Content-Length", (Object)String.valueOf(length));
                    nettyRequest.setContent(ChannelBuffers.copiedBuffer((byte[])bytes, (int)0, (int)length));
                } else if (request.getParams() != null) {
                    StringBuilder sb = new StringBuilder();
                    for (Map.Entry<String, List<String>> paramEntry : request.getParams()) {
                        String key = paramEntry.getKey();
                        for (String value : paramEntry.getValue()) {
                            if (sb.length() > 0) {
                                sb.append("&");
                            }
                            UTF8UrlEncoder.appendEncoded(sb, key);
                            sb.append("=");
                            UTF8UrlEncoder.appendEncoded(sb, value);
                        }
                    }
                    nettyRequest.setHeader("Content-Length", (Object)String.valueOf(sb.length()));
                    nettyRequest.setContent(ChannelBuffers.copiedBuffer((byte[])sb.toString().getBytes("UTF-8")));
                    if (!request.getHeaders().containsKey("Content-Type")) {
                        nettyRequest.setHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                    }
                } else if (request.getParts() != null) {
                    int lenght = NettyAsyncHttpProvider.computeAndSetContentLength(request, (HttpRequest)nettyRequest);
                    if (lenght == -1) {
                        lenght = 8192;
                    }
                    MultipartRequestEntity mre = AsyncHttpProviderUtils.createMultipartRequestEntity(request.getParts(), request.getParams());
                    nettyRequest.setHeader("Content-Type", (Object)mre.getContentType());
                    nettyRequest.setHeader("Content-Length", (Object)String.valueOf(mre.getContentLength()));
                    ChannelBuffer b = ChannelBuffers.dynamicBuffer((int)lenght);
                    mre.writeRequest((OutputStream)new ChannelBufferOutputStream(b));
                    nettyRequest.setContent(b);
                } else if (request.getEntityWriter() != null) {
                    int lenght = NettyAsyncHttpProvider.computeAndSetContentLength(request, (HttpRequest)nettyRequest);
                    if (lenght == -1) {
                        lenght = 8192;
                    }
                    ChannelBuffer b = ChannelBuffers.dynamicBuffer((int)lenght);
                    request.getEntityWriter().writeEntity((OutputStream)new ChannelBufferOutputStream(b));
                    nettyRequest.setHeader("Content-Length", (Object)b.writerIndex());
                    nettyRequest.setContent(b);
                } else if (request.getFile() != null) {
                    File file = request.getFile();
                    if (!file.isFile()) {
                        throw new IOException(String.format(NettyAsyncHttpProvider.currentThread() + "File %s is not a file or doesn't exist", file.getAbsolutePath()));
                    }
                    nettyRequest.setHeader("Content-Length", (Object)file.length());
                }
            }
        }
        return nettyRequest;
    }

    @Override
    public void close() {
        this.isClose.set(true);
        this.connectionsPool.destroy();
        this.openChannels.close();
        this.releaseExternalResources();
        this.config.reaper().shutdown();
        this.config.executorService().shutdown();
        this.socketChannelFactory.releaseExternalResources();
        this.plainBootstrap.releaseExternalResources();
        this.secureBootstrap.releaseExternalResources();
    }

    @Override
    public Response prepareResponse(HttpResponseStatus status, HttpResponseHeaders headers, Collection<HttpResponseBodyPart> bodyParts) {
        return new NettyAsyncResponse(status, headers, bodyParts);
    }

    @Override
    public <T> Future<T> execute(Request request, AsyncHandler<T> asyncHandler) throws IOException {
        return this.doConnect(request, asyncHandler, null, true);
    }

    private <T> void execute(Request request, NettyResponseFuture<T> f) throws IOException {
        this.doConnect(request, f.getAsyncHandler(), f, true);
    }

    private <T> void execute(Request request, NettyResponseFuture<T> f, boolean useCache) throws IOException {
        this.doConnect(request, f.getAsyncHandler(), f, useCache);
    }

    private <T> Future<T> doConnect(Request request, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> f, boolean useCache) throws IOException {
        ChannelFuture channelFuture;
        boolean useSSl;
        Realm realm;
        if (this.isClose.get()) {
            throw new IOException("Closed");
        }
        Realm realm2 = realm = request.getRealm() != null ? request.getRealm() : this.config.getRealm();
        if (realm != null && realm.getScheme() == Realm.AuthScheme.NTLM) {
            if (log.isDebugEnabled()) {
                log.debug(NettyAsyncHttpProvider.currentThread() + "NTLM not supported by this provider. Using the " + JDKAsyncHttpProvider.class.getName(), new Object[0]);
            }
            return this.ntlmProvider.execute(request, asyncHandler);
        }
        URI uri = AsyncHttpProviderUtils.createUri(request.getUrl());
        Channel channel = null;
        if (useCache) {
            channel = f != null && f.channel() != null ? f.channel() : this.lookupInCache(uri);
        }
        if (channel != null && channel.isOpen() && channel.isConnected()) {
            ChannelBuffer b = null;
            if (f != null && f.getRequest().getFile() == null && !f.getNettyRequest().getMethod().getName().equals(HttpMethod.CONNECT.getName())) {
                b = f.getNettyRequest().getContent();
            }
            HttpRequest nettyRequest = NettyAsyncHttpProvider.buildRequest(this.config, request, uri, false, b);
            if (f == null) {
                f = new NettyResponseFuture<T>(uri, request, asyncHandler, nettyRequest, NettyAsyncHttpProvider.requestTimeout(this.config, request.getPerRequestConfig()), this);
            } else {
                f.setNettyRequest(nettyRequest);
            }
            f.setState(NettyResponseFuture.STATE.POOLED);
            if (log.isDebugEnabled()) {
                log.debug(String.format(NettyAsyncHttpProvider.currentThread() + "\n\nCached Request %s\n", request.toString()), new Object[0]);
            }
            channel.getPipeline().getContext(NettyAsyncHttpProvider.class).setAttachment(f);
            this.writeRequest(channel, this.config, f, nettyRequest);
            return f;
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format(NettyAsyncHttpProvider.currentThread() + "\n\nNon cached Request %s\n", request.toString()), new Object[0]);
        }
        if (!this.connectionsPool.canCacheConnection() || this.config.getMaxTotalConnections() > -1 && this.maxConnections.get() + 1 > this.config.getMaxTotalConnections()) {
            throw new IOException(String.format("Too many connections %s", this.config.getMaxTotalConnections()));
        }
        NettyConnectListener<T> c = new NettyConnectListener.Builder<T>(this.config, request, asyncHandler, f, this).build();
        ProxyServer proxyServer = request.getProxyServer() != null ? request.getProxyServer() : this.config.getProxyServer();
        boolean bl = useSSl = uri.getScheme().compareToIgnoreCase(HTTPS) == 0 && proxyServer == null;
        if (useSSl) {
            this.constructSSLPipeline(c);
        }
        if (this.config.getMaxTotalConnections() != -1) {
            this.maxConnections.incrementAndGet();
        }
        ClientBootstrap bootstrap = useSSl ? this.secureBootstrap : this.plainBootstrap;
        try {
            channelFuture = proxyServer == null ? bootstrap.connect((SocketAddress)new InetSocketAddress(uri.getHost(), AsyncHttpProviderUtils.getPort(uri))) : bootstrap.connect((SocketAddress)new InetSocketAddress(proxyServer.getHost(), proxyServer.getPort()));
            bootstrap.setOption("connectTimeout", (Object)this.config.getConnectionTimeoutInMs());
        }
        catch (Throwable t) {
            log.error(String.format(NettyAsyncHttpProvider.currentThread() + "doConnect", new Object[0]), t);
            this.abort(c.future(), t.getCause());
            return c.future();
        }
        boolean directInvokation = true;
        if (IN_IO_THREAD.get().booleanValue() && DefaultChannelFuture.isUseDeadLockChecker()) {
            directInvokation = false;
        }
        if (directInvokation && !this.executeConnectAsync && request.getFile() == null) {
            channelFuture.awaitUninterruptibly();
            try {
                c.operationComplete(channelFuture);
            }
            catch (Exception e) {
                IOException ioe = new IOException(e.getMessage());
                ioe.initCause(e);
                throw ioe;
            }
        } else {
            channelFuture.addListener(c);
        }
        this.openChannels.add((Object)channelFuture.getChannel());
        return c.future();
    }

    protected static int requestTimeout(AsyncHttpClientConfig config, PerRequestConfig perRequestConfig) {
        int prRequestTimeout;
        int result = perRequestConfig != null ? ((prRequestTimeout = perRequestConfig.getRequestTimeoutInMs()) != 0 ? prRequestTimeout : config.getRequestTimeoutInMs()) : config.getRequestTimeoutInMs();
        return result;
    }

    protected void channelIdle(ChannelHandlerContext ctx, IdleState state, long lastActivityTimeMillis) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(String.format(NettyAsyncHttpProvider.currentThread() + "Channel Idle: %s", ctx.getChannel()), new Object[0]);
        }
        NettyResponseFuture future = (NettyResponseFuture)ctx.getAttachment();
        this.abort(future, new IOException("No response received. Connection timed out after " + this.config.getIdleConnectionTimeoutInMs()));
        this.closeChannel(ctx);
    }

    private void closeChannel(final ChannelHandlerContext ctx) {
        if (this.config.getMaxTotalConnections() != -1) {
            this.maxConnections.decrementAndGet();
        }
        this.connectionsPool.removeAllConnections(ctx.getChannel());
        ctx.setAttachment((Object)new DiscardEvent());
        this.config.executorService().submit(new Runnable(){

            public void run() {
                ctx.getChannel().close().awaitUninterruptibly();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(final ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        block46: {
            super.messageReceived(ctx, e);
            IN_IO_THREAD.set(Boolean.TRUE);
            if (log.isDebugEnabled()) {
                log.debug(String.format(NettyAsyncHttpProvider.currentThread() + "Message Received %s. Attachment Type is %s", e.getClass().getName(), ctx.getAttachment() != null ? ctx.getAttachment().getClass().getName() : "No attach"), new Object[0]);
                if (ctx.getAttachment() == null) {
                    log.warn(NettyAsyncHttpProvider.currentThread() + "ChannelHandlerContext wasn't having any attachment", new Object[0]);
                }
            }
            if (ctx.getAttachment() instanceof DiscardEvent) {
                this.config.executorService().submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() {
                        try {
                            ctx.getChannel().setReadable(true);
                        }
                        catch (Exception ex) {
                            if (log.isDebugEnabled()) {
                                log.debug(ex);
                            }
                            NettyAsyncHttpProvider.this.connectionsPool.removeAllConnections(ctx.getChannel());
                            return new Boolean(false);
                        }
                        return new Boolean(true);
                    }
                }).get();
                return;
            }
            if (ctx.getAttachment() instanceof AsyncCallable) {
                HttpChunk chunk = (HttpChunk)e.getMessage();
                if (chunk.isLast()) {
                    AsyncCallable ac = (AsyncCallable)ctx.getAttachment();
                    ctx.setAttachment(ac.future());
                    ac.call();
                }
                return;
            }
            if (!(ctx.getAttachment() instanceof NettyResponseFuture)) {
                return;
            }
            final NettyResponseFuture future = (NettyResponseFuture)ctx.getAttachment();
            future.touch();
            HttpRequest nettyRequest = future.getNettyRequest();
            AsyncHandler handler = future.getAsyncHandler();
            try {
                if (e.getMessage() instanceof HttpResponse) {
                    boolean redirectEnabled;
                    Realm realm;
                    HttpResponse response = (HttpResponse)e.getMessage();
                    if (log.isDebugEnabled()) {
                        log.debug(String.format(NettyAsyncHttpProvider.currentThread() + "\n\nRequest %s\n\nResponse %s\n", nettyRequest.toString(), response.toString()), new Object[0]);
                    }
                    future.setHttpResponse(response);
                    int statusCode = response.getStatus().getCode();
                    String ka = response.getHeader("Connection");
                    future.setKeepAlive(ka == null || ka.toLowerCase().equals("keep-alive"));
                    String wwwAuth = response.getHeader("WWW-Authenticate");
                    Request request = future.getRequest();
                    Realm realm2 = realm = request.getRealm() != null ? request.getRealm() : this.config.getRealm();
                    if (statusCode == 401 && wwwAuth != null && realm != null && !future.getAndSetAuth(true)) {
                        final Realm nr = new Realm.RealmBuilder().clone(realm).setScheme(realm.getAuthScheme()).setUri(URI.create(request.getUrl()).getPath()).setMethodName(request.getReqType()).setUsePreemptiveAuth(true).parseWWWAuthenticateHeader(wwwAuth).build();
                        if (log.isDebugEnabled()) {
                            log.debug(String.format(NettyAsyncHttpProvider.currentThread() + "Sending authentication to %s", request.getUrl()), new Object[0]);
                        }
                        if (this.config.getKeepAlive()) {
                            future.attachChannel(ctx.getChannel());
                        }
                        final RequestBuilder builder = new RequestBuilder(future.getRequest());
                        future.setState(NettyResponseFuture.STATE.NEW);
                        if (!future.getURI().getPath().equalsIgnoreCase(realm.getUri())) {
                            builder.setUrl(future.getURI().toString());
                        }
                        if (response.isChunked()) {
                            ctx.setAttachment((Object)new AsyncCallable(future){

                                public Object call() throws Exception {
                                    NettyAsyncHttpProvider.this.nextRequest(((RequestBuilder)builder.setRealm(nr)).build(), future);
                                    return null;
                                }
                            });
                        } else {
                            this.nextRequest(((RequestBuilder)builder.setRealm(nr)).build(), future);
                        }
                        return;
                    }
                    String proxyAuth = response.getHeader("Proxy-Authenticate");
                    if (statusCode == 407 && proxyAuth != null && future.getRequest().getRealm() != null && !future.getAndSetAuth(true)) {
                        if (log.isDebugEnabled()) {
                            log.debug(String.format(NettyAsyncHttpProvider.currentThread() + "Sending proxy authentication to %s", request.getUrl()), new Object[0]);
                        }
                        if (response.isChunked()) {
                            ctx.setAttachment((Object)new AsyncCallable(future){

                                public Object call() throws Exception {
                                    NettyAsyncHttpProvider.this.nextRequest(future.getRequest(), future);
                                    return null;
                                }
                            });
                        } else {
                            this.nextRequest(future.getRequest(), future);
                        }
                        return;
                    }
                    if (future.getNettyRequest().getMethod().equals((Object)HttpMethod.CONNECT) && statusCode == 200) {
                        ProxyServer proxyServer;
                        ProxyServer proxyServer2 = proxyServer = request.getProxyServer() != null ? request.getProxyServer() : this.config.getProxyServer();
                        if (log.isDebugEnabled() && proxyServer != null) {
                            log.debug(String.format(NettyAsyncHttpProvider.currentThread() + "Connected to %s:%s", proxyServer.getHost(), proxyServer.getPort()), new Object[0]);
                        }
                        if (this.config.getKeepAlive()) {
                            future.attachChannel(ctx.getChannel());
                        }
                        RequestBuilder builder = new RequestBuilder(future.getRequest());
                        try {
                            this.upgradeProtocol(ctx.getChannel().getPipeline(), request.getUrl(), proxyServer);
                        }
                        catch (Throwable ex) {
                            this.abort(future, ex);
                        }
                        this.nextRequest(builder.build(), future);
                        return;
                    }
                    boolean bl = redirectEnabled = request.isRedirectEnabled() ? true : this.config.isRedirectEnabled();
                    if (redirectEnabled && (statusCode == 302 || statusCode == 301)) {
                        if (future.incrementAndGetCurrentRedirectCount() < this.config.getMaxRedirects()) {
                            future.getAndSetAuth(false);
                            String location = response.getHeader("Location");
                            if (location.startsWith("/")) {
                                location = AsyncHttpProviderUtils.getBaseUrl(future.getURI()) + location;
                            }
                            if (!location.equalsIgnoreCase(future.getURI().toString())) {
                                URI uri = AsyncHttpProviderUtils.createUri(location);
                                final RequestBuilder builder = new RequestBuilder(future.getRequest());
                                final URI initialConnectionUri = future.getURI();
                                final boolean initialConnectionKeepAlive = future.getKeepAlive();
                                future.setURI(uri);
                                final String newUrl = uri.toString();
                                if (log.isDebugEnabled()) {
                                    log.debug(String.format(NettyAsyncHttpProvider.currentThread() + "Redirecting to %s", newUrl), new Object[0]);
                                }
                                if (response.isChunked()) {
                                    ctx.setAttachment((Object)new AsyncCallable(future){

                                        public Object call() throws Exception {
                                            if (initialConnectionKeepAlive) {
                                                NettyAsyncHttpProvider.this.connectionsPool.addConnection(AsyncHttpProviderUtils.getBaseUrl(initialConnectionUri), ctx.getChannel());
                                            } else {
                                                NettyAsyncHttpProvider.this.closeChannel(ctx);
                                            }
                                            NettyAsyncHttpProvider.this.nextRequest(builder.setUrl(newUrl).build(), future);
                                            return null;
                                        }
                                    });
                                } else {
                                    if (initialConnectionKeepAlive) {
                                        this.connectionsPool.addConnection(AsyncHttpProviderUtils.getBaseUrl(initialConnectionUri), ctx.getChannel());
                                    } else {
                                        this.closeChannel(ctx);
                                    }
                                    this.nextRequest(builder.setUrl(newUrl).build(), future);
                                }
                                return;
                            }
                        } else {
                            throw new MaxRedirectException("Maximum redirect reached: " + this.config.getMaxRedirects());
                        }
                    }
                    if (!future.getAndSetStatusReceived(true) && this.updateStatusAndInterrupt(handler, new ResponseStatus(future.getURI(), response, this))) {
                        this.finishUpdate(future, ctx, response.isChunked());
                        return;
                    }
                    if (this.updateHeadersAndInterrupt(handler, new ResponseHeaders(future.getURI(), response, this))) {
                        this.finishUpdate(future, ctx, response.isChunked());
                        return;
                    }
                    if (!response.isChunked()) {
                        if (response.getContent().readableBytes() != 0) {
                            this.updateBodyAndInterrupt(handler, new ResponseBodyPart(future.getURI(), response, this));
                        }
                        this.finishUpdate(future, ctx, false);
                        return;
                    }
                    if (nettyRequest.getMethod().equals((Object)HttpMethod.HEAD)) {
                        this.markAsDoneAndCacheConnection(future, ctx, ctx.getChannel().isReadable());
                    }
                    break block46;
                }
                if (e.getMessage() instanceof HttpChunk) {
                    HttpChunk chunk = (HttpChunk)e.getMessage();
                    if (handler != null && (chunk.isLast() || this.updateBodyAndInterrupt(handler, new ResponseBodyPart(future.getURI(), null, this, chunk)))) {
                        if (chunk instanceof DefaultHttpChunkTrailer) {
                            this.updateHeadersAndInterrupt(handler, new ResponseHeaders(future.getURI(), future.getHttpResponse(), this, (HttpChunkTrailer)chunk));
                        }
                        this.finishUpdate(future, ctx, !chunk.isLast());
                    }
                }
            }
            catch (Exception t) {
                try {
                    this.abort(future, t);
                }
                finally {
                    this.finishUpdate(future, ctx, false);
                    throw t;
                }
            }
        }
    }

    private void nextRequest(final Request request, final NettyResponseFuture<?> future) throws IOException {
        if (!this.executeConnectAsync && request.getFile() == null) {
            this.config.executorService().submit(new Runnable(){

                public void run() {
                    block2: {
                        try {
                            NettyAsyncHttpProvider.this.execute(request, future);
                        }
                        catch (IOException e) {
                            if (!log.isDebugEnabled()) break block2;
                            log.debug(e);
                        }
                    }
                }
            });
        } else {
            this.execute(request, future);
        }
    }

    private void abort(NettyResponseFuture<?> future, Throwable t) {
        if (this.config.getMaxTotalConnections() != -1) {
            this.maxConnections.decrementAndGet();
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format(NettyAsyncHttpProvider.currentThread() + "abording Future %s", future), new Object[0]);
            log.debug(t);
        }
        future.abort(t);
    }

    private void upgradeProtocol(ChannelPipeline p, String scheme, ProxyServer proxyServer) throws IOException, GeneralSecurityException {
        if (p.get(HTTP_HANDLER) != null) {
            p.remove(HTTP_HANDLER);
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Connecting to proxy %s for scheme %s", proxyServer, scheme), new Object[0]);
        }
        if (scheme.startsWith(HTTPS)) {
            if (p.get(SSL_HANDLER) == null) {
                p.addFirst(HTTP_HANDLER, (ChannelHandler)new HttpClientCodec());
                p.addFirst(SSL_HANDLER, (ChannelHandler)new SslHandler(this.createSSLEngine()));
            } else {
                p.addAfter(SSL_HANDLER, HTTP_HANDLER, (ChannelHandler)new HttpClientCodec());
            }
        } else {
            p.addFirst(HTTP_HANDLER, (ChannelHandler)new HttpClientCodec());
        }
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.connectionsPool.removeAllConnections(ctx.getChannel());
        Exception exception = null;
        try {
            super.channelClosed(ctx, e);
        }
        catch (Exception ex) {
            exception = ex;
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format(NettyAsyncHttpProvider.currentThread() + "Channel Closed: %s", e.getChannel()), new Object[0]);
        }
        if (ctx.getAttachment() instanceof AsyncCallable) {
            AsyncCallable ac = (AsyncCallable)ctx.getAttachment();
            ctx.setAttachment(ac.future());
            ac.call();
            return;
        }
        if (!this.isClose.get() && ctx.getAttachment() instanceof NettyResponseFuture) {
            NettyResponseFuture future = (NettyResponseFuture)ctx.getAttachment();
            if (future != null && !future.isDone()) {
                this.remotelyClosed(ctx.getChannel(), future);
            }
        } else {
            this.closeChannel(ctx);
        }
    }

    protected boolean remotelyClosed(Channel channel, NettyResponseFuture<?> future) {
        if (this.isClose.get()) {
            return false;
        }
        this.connectionsPool.removeAllConnections(channel);
        if (future == null && channel.getPipeline().getContext(NettyAsyncHttpProvider.class).getAttachment() != null && NettyResponseFuture.class.isAssignableFrom(channel.getPipeline().getContext(NettyAsyncHttpProvider.class).getAttachment().getClass())) {
            future = (NettyResponseFuture)channel.getPipeline().getContext(NettyAsyncHttpProvider.class).getAttachment();
        }
        if (future == null) {
            return false;
        }
        if (!this.config.getKeepAlive() || future.isDone() || !future.canRetry() || future.isCancelled() || future.channel() != null) {
            return false;
        }
        future.setState(NettyResponseFuture.STATE.RECONNECTED);
        if (log.isDebugEnabled()) {
            log.debug(String.format(NettyAsyncHttpProvider.currentThread() + "Trying to recover request %s", future.getNettyRequest()), new Object[0]);
        }
        try {
            this.nextRequest(future.getRequest(), future);
            return true;
        }
        catch (IOException iox) {
            future.setState(NettyResponseFuture.STATE.CLOSED);
            future.abort(iox);
            log.error(String.format(NettyAsyncHttpProvider.currentThread() + "Remotely Closed", new Object[0]), iox);
            return false;
        }
    }

    private void markAsDoneAndCacheConnection(final NettyResponseFuture<?> future, final ChannelHandlerContext ctx, final boolean cache) throws MalformedURLException {
        block3: {
            try {
                future.done(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        if (future.getKeepAlive() && cache) {
                            NettyAsyncHttpProvider.this.connectionsPool.addConnection(AsyncHttpProviderUtils.getBaseUrl(future.getURI()), ctx.getChannel());
                        }
                        return false;
                    }
                });
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) break block3;
                log.debug(NettyAsyncHttpProvider.currentThread(), t);
            }
        }
        if (!future.getKeepAlive()) {
            this.closeChannel(ctx);
        }
    }

    private void finishUpdate(final NettyResponseFuture<?> future, final ChannelHandlerContext ctx, boolean isChunked) throws IOException {
        if (isChunked && future.getKeepAlive()) {
            ctx.setAttachment((Object)new AsyncCallable(future){

                public Object call() throws Exception {
                    NettyAsyncHttpProvider.this.markAsDoneAndCacheConnection(future, ctx, ctx.getChannel().isReadable());
                    return null;
                }
            });
        } else {
            this.markAsDoneAndCacheConnection(future, ctx, this.markChannelNotReadable(ctx));
        }
    }

    private boolean markChannelNotReadable(final ChannelHandlerContext ctx) {
        ctx.setAttachment((Object)new DiscardEvent());
        try {
            return this.config.executorService().submit(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    try {
                        ctx.getChannel().setReadable(false);
                    }
                    catch (Exception ex) {
                        if (log.isDebugEnabled()) {
                            log.debug(ex);
                        }
                        NettyAsyncHttpProvider.this.connectionsPool.removeAllConnections(ctx.getChannel());
                        return new Boolean(false);
                    }
                    return new Boolean(true);
                }
            }).get();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private final boolean updateStatusAndInterrupt(AsyncHandler handler, HttpResponseStatus c) throws Exception {
        return handler.onStatusReceived(c) != AsyncHandler.STATE.CONTINUE;
    }

    private final boolean updateHeadersAndInterrupt(AsyncHandler handler, HttpResponseHeaders c) throws Exception {
        return handler.onHeadersReceived(c) != AsyncHandler.STATE.CONTINUE;
    }

    private final boolean updateBodyAndInterrupt(AsyncHandler handler, HttpResponseBodyPart c) throws Exception {
        return handler.onBodyPartReceived(c) != AsyncHandler.STATE.CONTINUE;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Channel channel = e.getChannel();
        Throwable cause = e.getCause();
        NettyResponseFuture<?> future = null;
        try {
            if (cause != null && ClosedChannelException.class.isAssignableFrom(cause.getClass())) {
                return;
            }
            if (ctx.getAttachment() instanceof NettyResponseFuture) {
                future = (NettyResponseFuture<?>)ctx.getAttachment();
                future.attachChannel(null);
                if (NettyAsyncHttpProvider.abortOnReadCloseException(cause) || NettyAsyncHttpProvider.abortOnWriteCloseException(cause)) {
                    log.debug(NettyAsyncHttpProvider.currentThread() + String.format("Trying to recover from dead Channel: %s ", channel), new Object[0]);
                    if (this.remotelyClosed(channel, future)) {
                        return;
                    }
                }
            } else if (ctx.getAttachment() instanceof AsyncCallable) {
                future = ((AsyncCallable)ctx.getAttachment()).future();
            }
        }
        catch (Throwable t) {
            cause = t;
        }
        if (future != null) {
            try {
                this.abort(future, cause);
            }
            catch (Throwable t) {
                log.error(NettyAsyncHttpProvider.currentThread(), t);
            }
        }
        if (log.isDebugEnabled()) {
            log.error(NettyAsyncHttpProvider.currentThread() + String.format("Exception Caught: %s Attachment was %s", cause != null ? cause.getMessage() : "unavailable cause", ctx.getAttachment()), new Object[0]);
            log.error(cause);
        }
    }

    protected static boolean abortOnConnectCloseException(Throwable cause) {
        try {
            for (StackTraceElement element : cause.getStackTrace()) {
                if (!element.getClassName().equals("sun.nio.ch.SocketChannelImpl") || !element.getMethodName().equals("checkConnect")) continue;
                return true;
            }
            if (cause.getCause() != null) {
                return NettyAsyncHttpProvider.abortOnConnectCloseException(cause.getCause());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    protected static boolean abortOnReadCloseException(Throwable cause) {
        for (StackTraceElement element : cause.getStackTrace()) {
            if (!element.getClassName().equals("sun.nio.ch.SocketDispatcher") || !element.getMethodName().equals("read")) continue;
            return true;
        }
        if (cause.getCause() != null) {
            return NettyAsyncHttpProvider.abortOnReadCloseException(cause.getCause());
        }
        return false;
    }

    protected static boolean abortOnWriteCloseException(Throwable cause) {
        for (StackTraceElement element : cause.getStackTrace()) {
            if (!element.getClassName().equals("sun.nio.ch.SocketDispatcher") || !element.getMethodName().equals("write")) continue;
            return true;
        }
        if (cause.getCause() != null) {
            return NettyAsyncHttpProvider.abortOnReadCloseException(cause.getCause());
        }
        return false;
    }

    private static final int computeAndSetContentLength(Request request, HttpRequest r) {
        int lenght = (int)request.getLength();
        if (lenght == -1 && r.getHeader("Content-Length") != null) {
            lenght = Integer.valueOf(r.getHeader("Content-Length"));
        }
        if (lenght != -1) {
            r.setHeader("Content-Length", (Object)String.valueOf(lenght));
        }
        return lenght;
    }

    static final String currentThread() {
        return AsyncHttpProviderUtils.currentThread();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ThreadLocalBoolean
    extends ThreadLocal<Boolean> {
        private final boolean defaultValue;

        public ThreadLocalBoolean() {
            this(false);
        }

        public ThreadLocalBoolean(boolean defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        protected Boolean initialValue() {
            return this.defaultValue ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AsyncCallable
    implements Callable<Object> {
        private final NettyResponseFuture<?> future;

        public AsyncCallable(NettyResponseFuture<?> future) {
            this.future = future;
        }

        @Override
        public abstract Object call() throws Exception;

        public NettyResponseFuture<?> future() {
            return this.future;
        }
    }

    private final class ReaperFuture
    implements Future,
    Runnable {
        private Future scheduledFuture;
        private Channel channel;
        private NettyResponseFuture nettyResponseFuture;

        public ReaperFuture(Channel channel, NettyResponseFuture nettyResponseFuture) {
            this.channel = channel;
            this.nettyResponseFuture = nettyResponseFuture;
        }

        public void setScheduledFuture(Future scheduledFuture) {
            this.scheduledFuture = scheduledFuture;
        }

        public synchronized boolean cancel(boolean mayInterruptIfRunning) {
            this.channel = null;
            this.nettyResponseFuture = null;
            return this.scheduledFuture.cancel(mayInterruptIfRunning);
        }

        public Object get() throws InterruptedException, ExecutionException {
            return this.scheduledFuture.get();
        }

        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.scheduledFuture.get(timeout, unit);
        }

        public boolean isCancelled() {
            return this.scheduledFuture.isCancelled();
        }

        public boolean isDone() {
            return this.scheduledFuture.isDone();
        }

        public synchronized void run() {
            if (this.nettyResponseFuture != null && this.nettyResponseFuture.hasExpired()) {
                if (log.isDebugEnabled()) {
                    log.debug(NettyAsyncHttpProvider.currentThread() + "Request Timeout expired for " + this.nettyResponseFuture, new Object[0]);
                }
                int requestTimeout = NettyAsyncHttpProvider.this.config.getRequestTimeoutInMs();
                PerRequestConfig p = this.nettyResponseFuture.getRequest().getPerRequestConfig();
                if (p != null && p.getRequestTimeoutInMs() != -1) {
                    requestTimeout = p.getRequestTimeoutInMs();
                }
                NettyAsyncHttpProvider.this.abort(this.nettyResponseFuture, new TimeoutException(String.format("No response received after %s", requestTimeout)));
                NettyAsyncHttpProvider.this.markChannelNotReadable(this.channel.getPipeline().getContext(NettyAsyncHttpProvider.class));
                this.nettyResponseFuture = null;
                this.channel = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProgressListener
    implements ChannelFutureProgressListener {
        private final boolean notifyHeaders;
        private final AsyncHandler asyncHandler;
        private final NettyResponseFuture<?> future;

        public ProgressListener(boolean notifyHeaders, AsyncHandler asyncHandler, NettyResponseFuture<?> future) {
            this.notifyHeaders = notifyHeaders;
            this.asyncHandler = asyncHandler;
            this.future = future;
        }

        public void operationComplete(ChannelFuture cf) {
            Throwable cause = cf.getCause();
            if (cause != null && this.future.getState() != NettyResponseFuture.STATE.NEW) {
                if (IllegalStateException.class.isAssignableFrom(cause.getClass())) {
                    if (log.isDebugEnabled()) {
                        log.debug(cause);
                    }
                    if (this.future.provider().remotelyClosed(cf.getChannel(), this.future)) {
                        return;
                    }
                    this.future.abort(cause);
                }
                if (ClosedChannelException.class.isAssignableFrom(cause.getClass()) || NettyAsyncHttpProvider.abortOnReadCloseException(cause) || NettyAsyncHttpProvider.abortOnWriteCloseException(cause)) {
                    if (log.isDebugEnabled()) {
                        log.debug(NettyAsyncHttpProvider.currentThread(), cf.getCause());
                    }
                    if (this.future.provider().remotelyClosed(cf.getChannel(), this.future)) {
                        return;
                    }
                    this.future.abort(cause);
                } else {
                    this.future.abort(cause);
                }
                return;
            }
            this.future.touch();
            if (ProgressAsyncHandler.class.isAssignableFrom(this.asyncHandler.getClass())) {
                if (this.notifyHeaders) {
                    ((ProgressAsyncHandler)ProgressAsyncHandler.class.cast(this.asyncHandler)).onHeaderWriteCompleted();
                } else {
                    ((ProgressAsyncHandler)ProgressAsyncHandler.class.cast(this.asyncHandler)).onContentWriteCompleted();
                }
            }
        }

        public void operationProgressed(ChannelFuture cf, long amount, long current, long total) {
            if (ProgressAsyncHandler.class.isAssignableFrom(this.asyncHandler.getClass())) {
                ((ProgressAsyncHandler)ProgressAsyncHandler.class.cast(this.asyncHandler)).onContentWriteProgress(amount, current, total);
            }
        }
    }

    static final class DiscardEvent {
        DiscardEvent() {
        }
    }
}

