/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty;

import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ConnectionsPool;
import com.ning.http.client.logging.LogManager;
import com.ning.http.client.logging.Logger;
import com.ning.http.client.providers.netty.NettyAsyncHttpProvider;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.channel.Channel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NettyConnectionsPool
implements ConnectionsPool<String, Channel> {
    private static final Logger log = LogManager.getLogger(NettyAsyncHttpProvider.class);
    private final ConcurrentHashMap<String, Channel> connectionsPool = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, AtomicInteger> connectionsPerHost = new ConcurrentHashMap();
    private final AsyncHttpClientConfig config;

    public NettyConnectionsPool(AsyncHttpClientConfig config) {
        this.config = config;
    }

    @Override
    public boolean addConnection(String uri, Channel connection) {
        AtomicInteger connectionPerHost;
        if (log.isDebugEnabled()) {
            log.debug(String.format(NettyAsyncHttpProvider.currentThread() + "Adding uri: %s for channel %s", uri, connection), new Object[0]);
        }
        if ((connectionPerHost = this.connectionsPerHost.get(uri)) == null) {
            connectionPerHost = new AtomicInteger(1);
            this.connectionsPerHost.put(uri, connectionPerHost);
        }
        if (this.config.getMaxConnectionPerHost() != -1 && connectionPerHost.get() >= this.config.getMaxConnectionPerHost()) {
            log.warn("Maximum connections per hosts reached " + this.config.getMaxConnectionPerHost(), new Object[0]);
            return false;
        }
        this.connectionsPool.put(uri, connection);
        connectionPerHost.incrementAndGet();
        return true;
    }

    @Override
    public Channel getConnection(String uri) {
        Channel channel = this.connectionsPool.get(uri);
        if (channel != null && !channel.isOpen()) {
            this.removeConnection(uri);
            return null;
        }
        return channel;
    }

    @Override
    public Channel removeConnection(String uri) {
        Channel channel = this.connectionsPool.remove(uri);
        if (!(channel == null || channel.isConnected() && channel.isOpen())) {
            this.removeAllConnections(channel);
            return null;
        }
        return channel;
    }

    @Override
    public boolean removeAllConnections(Channel connection) {
        boolean isRemoved = false;
        Iterator<Map.Entry<String, Channel>> i = this.connectionsPool.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, Channel> e = i.next();
            if (!e.getValue().equals(connection)) continue;
            if (log.isDebugEnabled()) {
                log.debug(String.format(NettyAsyncHttpProvider.currentThread() + "Removing uri: %s for channel %s", e.getKey(), e.getValue()), new Object[0]);
            }
            i.remove();
            isRemoved = true;
        }
        return isRemoved;
    }

    @Override
    public boolean canCacheConnection() {
        return this.config.getMaxTotalConnections() == -1 || this.connectionsPool.size() < this.config.getMaxTotalConnections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        try {
            Iterator<Map.Entry<String, Channel>> i = this.connectionsPool.entrySet().iterator();
            while (i.hasNext()) {
                Channel channel = i.next().getValue();
                this.removeAllConnections(channel);
                channel.close();
            }
        }
        finally {
            this.connectionsPool.clear();
        }
    }
}

