/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client;

import com.ning.http.client.Cookie;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.FluentStringsMap;
import com.ning.http.client.Part;
import com.ning.http.client.PerRequestConfig;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.util.UTF8UrlEncoder;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RequestBuilderBase<T extends RequestBuilderBase<T>> {
    private final Class<T> derived;
    protected final RequestImpl request;

    protected RequestBuilderBase(Class<T> derived, String reqType) {
        this.derived = derived;
        this.request = new RequestImpl();
        this.request.reqType = reqType;
    }

    protected RequestBuilderBase(Class<T> derived, Request prototype) {
        this.derived = derived;
        this.request = new RequestImpl(prototype);
    }

    public T setUrl(String url) {
        this.request.url = this.buildUrl(url);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    private String buildUrl(String url) {
        URI uri = URI.create(url);
        StringBuilder buildedUrl = new StringBuilder();
        if (uri.getScheme() != null) {
            buildedUrl.append(uri.getScheme());
            buildedUrl.append("://");
        }
        if (uri.getAuthority() != null) {
            buildedUrl.append(uri.getAuthority());
        }
        buildedUrl.append(uri.getRawPath());
        if (uri.getRawQuery() != null && !uri.getRawQuery().equals("")) {
            String[] queries = uri.getRawQuery().split("&");
            int pos = 0;
            for (String query : queries) {
                pos = query.indexOf("=");
                if (pos <= 0) {
                    this.addQueryParameter(query, null);
                    continue;
                }
                this.addQueryParameter(query.substring(0, pos), query.substring(pos + 1));
            }
        }
        return buildedUrl.toString();
    }

    public T setVirtualHost(String virtualHost) {
        this.request.virtualHost = virtualHost;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setHeader(String name, String value) {
        this.request.headers.replace(name, value);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T addHeader(String name, String value) {
        this.request.headers.add(name, value);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setHeaders(FluentCaseInsensitiveStringsMap headers) {
        this.request.headers = headers == null ? new FluentCaseInsensitiveStringsMap() : new FluentCaseInsensitiveStringsMap(headers);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setHeaders(Map<String, Collection<String>> headers) {
        this.request.headers = headers == null ? new FluentCaseInsensitiveStringsMap() : new FluentCaseInsensitiveStringsMap(headers);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T addCookie(Cookie cookie) {
        this.request.cookies.add(cookie);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    private void resetParameters() {
        this.request.params = null;
    }

    private void resetNonMultipartData() {
        RequestImpl.access$602(this.request, null);
        this.request.stringData = null;
        this.request.streamData = null;
        this.request.entityWriter = null;
        this.request.length = -1L;
    }

    private void resetMultipartData() {
        this.request.parts = null;
    }

    public T setBody(File file) {
        this.request.file = file;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setBody(byte[] data) throws IllegalArgumentException {
        if (!"POST".equals(this.request.reqType) && !"PUT".equals(this.request.reqType)) {
            throw new IllegalArgumentException("Request type has to POST or PUT for content");
        }
        this.resetParameters();
        this.resetNonMultipartData();
        this.resetMultipartData();
        RequestImpl.access$602(this.request, data);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setBody(String data) throws IllegalArgumentException {
        if (!"POST".equals(this.request.reqType) && !"PUT".equals(this.request.reqType)) {
            throw new IllegalArgumentException("Request type has to POST or PUT for content");
        }
        this.resetParameters();
        this.resetNonMultipartData();
        this.resetMultipartData();
        this.request.stringData = data;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setBody(InputStream stream) throws IllegalArgumentException {
        if (!"POST".equals(this.request.reqType) && !"PUT".equals(this.request.reqType)) {
            throw new IllegalArgumentException("Request type has to POST or PUT for content");
        }
        this.resetParameters();
        this.resetNonMultipartData();
        this.resetMultipartData();
        this.request.streamData = stream;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setBody(Request.EntityWriter dataWriter) {
        return this.setBody(dataWriter, -1L);
    }

    public T setBody(Request.EntityWriter dataWriter, long length) throws IllegalArgumentException {
        if (!"POST".equals(this.request.reqType) && !"PUT".equals(this.request.reqType)) {
            throw new IllegalArgumentException("Request type has to POST or PUT for content");
        }
        this.resetParameters();
        this.resetNonMultipartData();
        this.resetMultipartData();
        this.request.entityWriter = dataWriter;
        this.request.length = length;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T addQueryParameter(String name, String value) {
        if (this.request.queryParams == null) {
            this.request.queryParams = new FluentStringsMap();
        }
        this.request.queryParams.add(name, value);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T addParameter(String key, String value) throws IllegalArgumentException {
        if (!"POST".equals(this.request.reqType) && !"PUT".equals(this.request.reqType)) {
            throw new IllegalArgumentException("Request type has to POST or PUT for form parameters");
        }
        this.resetNonMultipartData();
        this.resetMultipartData();
        if (this.request.params == null) {
            this.request.params = new FluentStringsMap();
        }
        this.request.params.add(key, value);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setParameters(FluentStringsMap parameters) throws IllegalArgumentException {
        if (!"POST".equals(this.request.reqType) && !"PUT".equals(this.request.reqType)) {
            throw new IllegalArgumentException("Request type has to POST or PUT for form parameters");
        }
        this.resetNonMultipartData();
        this.resetMultipartData();
        this.request.params = new FluentStringsMap(parameters);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setParameters(Map<String, Collection<String>> parameters) throws IllegalArgumentException {
        if (!"POST".equals(this.request.reqType) && !"PUT".equals(this.request.reqType)) {
            throw new IllegalArgumentException("Request type has to POST or PUT for form parameters");
        }
        this.resetNonMultipartData();
        this.resetMultipartData();
        this.request.params = new FluentStringsMap(parameters);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T addBodyPart(Part part) throws IllegalArgumentException {
        if (!"POST".equals(this.request.reqType) && !"PUT".equals(this.request.reqType)) {
            throw new IllegalArgumentException("Request type has to POST or PUT for parts");
        }
        this.resetParameters();
        this.resetNonMultipartData();
        if (this.request.parts == null) {
            this.request.parts = new ArrayList();
        }
        this.request.parts.add(part);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setProxyServer(ProxyServer proxyServer) {
        this.request.proxyServer = proxyServer;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setRealm(Realm realm) {
        this.request.realm = realm;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setFollowRedirects(boolean followRedirects) {
        this.request.followRedirects = followRedirects;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setPerRequestConfig(PerRequestConfig perRequestConfig) {
        this.request.perRequestConfig = perRequestConfig;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public Request build() {
        String contentLength;
        if (this.request.length < 0L && this.request.streamData == null && ("POST".equals(this.request.reqType) || "PUT".equals(this.request.reqType)) && (contentLength = this.request.headers.getFirstValue("Content-Length")) != null) {
            try {
                this.request.length = Long.parseLong(contentLength);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.request;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RequestImpl
    implements Request {
        private String reqType;
        private String url = null;
        private FluentCaseInsensitiveStringsMap headers = new FluentCaseInsensitiveStringsMap();
        private Collection<Cookie> cookies = new ArrayList<Cookie>();
        private byte[] byteData;
        private String stringData;
        private InputStream streamData;
        private Request.EntityWriter entityWriter;
        private FluentStringsMap params;
        private List<Part> parts;
        private String virtualHost;
        private long length = -1L;
        public FluentStringsMap queryParams;
        public ProxyServer proxyServer;
        private Realm realm;
        private File file;
        private boolean followRedirects;
        private PerRequestConfig perRequestConfig;

        public RequestImpl() {
        }

        public RequestImpl(Request prototype) {
            if (prototype != null) {
                this.reqType = prototype.getReqType();
                int pos = prototype.getUrl().indexOf("?");
                this.url = pos > 0 ? prototype.getUrl().substring(0, pos) : prototype.getUrl();
                this.headers = new FluentCaseInsensitiveStringsMap(prototype.getHeaders());
                this.cookies = new ArrayList<Cookie>(prototype.getCookies());
                this.byteData = prototype.getByteData();
                this.stringData = prototype.getStringData();
                this.streamData = prototype.getStreamData();
                this.entityWriter = prototype.getEntityWriter();
                this.params = prototype.getParams() == null ? null : new FluentStringsMap(prototype.getParams());
                this.queryParams = prototype.getQueryParams() == null ? null : new FluentStringsMap(prototype.getQueryParams());
                this.parts = prototype.getParts() == null ? null : new ArrayList<Part>(prototype.getParts());
                this.virtualHost = prototype.getVirtualHost();
                this.length = prototype.getLength();
                this.proxyServer = prototype.getProxyServer();
                this.realm = prototype.getRealm();
                this.file = prototype.getFile();
                this.followRedirects = prototype.isRedirectEnabled();
                this.perRequestConfig = prototype.getPerRequestConfig();
            }
        }

        @Override
        public String getReqType() {
            return this.reqType;
        }

        @Override
        public String getUrl() {
            return this.toUrl(true);
        }

        private String toUrl(boolean encode) {
            String uri;
            if (this.url == null) {
                throw new NullPointerException("url is null");
            }
            try {
                uri = URI.create(this.url).toURL().toString();
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Illegal URL: " + this.url, e);
            }
            if (this.queryParams != null) {
                StringBuilder builder = new StringBuilder();
                if (!this.url.substring(8).contains("/")) {
                    builder.append("/");
                }
                builder.append("?");
                Iterator<Map.Entry<String, List<String>>> i = this.queryParams.iterator();
                while (i.hasNext()) {
                    Map.Entry<String, List<String>> param = i.next();
                    String name = param.getKey();
                    Iterator<String> j = param.getValue().iterator();
                    while (j.hasNext()) {
                        String value = j.next();
                        if (encode) {
                            UTF8UrlEncoder.appendEncoded(builder, name);
                        } else {
                            builder.append(name);
                        }
                        if (value != null) {
                            builder.append('=');
                            if (encode) {
                                UTF8UrlEncoder.appendEncoded(builder, value);
                            } else {
                                builder.append(value);
                            }
                        }
                        if (!j.hasNext()) continue;
                        builder.append('&');
                    }
                    if (!i.hasNext()) continue;
                    builder.append('&');
                }
                uri = uri + builder.toString();
            }
            return uri;
        }

        @Override
        public String getRawUrl() {
            return this.toUrl(false);
        }

        @Override
        public FluentCaseInsensitiveStringsMap getHeaders() {
            return this.headers;
        }

        @Override
        public Collection<Cookie> getCookies() {
            return Collections.unmodifiableCollection(this.cookies);
        }

        @Override
        public byte[] getByteData() {
            return this.byteData;
        }

        @Override
        public String getStringData() {
            return this.stringData;
        }

        @Override
        public InputStream getStreamData() {
            return this.streamData;
        }

        @Override
        public Request.EntityWriter getEntityWriter() {
            return this.entityWriter;
        }

        @Override
        public long getLength() {
            return this.length;
        }

        @Override
        public FluentStringsMap getParams() {
            return this.params;
        }

        @Override
        public List<Part> getParts() {
            return this.parts;
        }

        @Override
        public String getVirtualHost() {
            return this.virtualHost;
        }

        @Override
        public FluentStringsMap getQueryParams() {
            return this.queryParams;
        }

        @Override
        public ProxyServer getProxyServer() {
            return this.proxyServer;
        }

        @Override
        public Realm getRealm() {
            return this.realm;
        }

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        public boolean isRedirectEnabled() {
            return this.followRedirects;
        }

        @Override
        public PerRequestConfig getPerRequestConfig() {
            return this.perRequestConfig;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.url);
            sb.append("\t");
            sb.append(this.reqType);
            for (String name : this.headers.keySet()) {
                sb.append("\t");
                sb.append(name);
                sb.append(":");
                sb.append(this.headers.getJoinedValue(name, ", "));
            }
            return sb.toString();
        }

        static /* synthetic */ byte[] access$602(RequestImpl x0, byte[] x1) {
            x0.byteData = x1;
            return x1;
        }
    }
}

