/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers;

import com.ning.http.client.Cookie;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.Response;
import com.ning.http.client.providers.ResponseBodyPart;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferInputStream;
import org.jboss.netty.buffer.ChannelBuffers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NettyAsyncResponse
implements Response {
    private final URI uri;
    private final Collection<HttpResponseBodyPart> bodyParts;
    private final HttpResponseHeaders headers;
    private final HttpResponseStatus status;
    private final List<Cookie> cookies = new ArrayList<Cookie>();

    public NettyAsyncResponse(HttpResponseStatus status, HttpResponseHeaders headers, Collection<HttpResponseBodyPart> bodyParts) {
        this.status = status;
        this.headers = headers;
        this.bodyParts = bodyParts;
        this.uri = status.getUrl();
    }

    @Override
    public int getStatusCode() {
        return this.status.getStatusCode();
    }

    @Override
    public String getStatusText() {
        return this.status.getStatusText();
    }

    @Override
    public String getResponseBody() throws IOException {
        String contentType = this.getContentType();
        String charset = "UTF-8";
        if (contentType != null) {
            for (String part : contentType.split(";")) {
                if (!part.startsWith("charset=")) continue;
                charset = part.substring("charset=".length());
            }
        }
        return this.contentToString(charset);
    }

    String contentToString(String charset) throws UnsupportedEncodingException {
        StringBuilder b = new StringBuilder();
        for (HttpResponseBodyPart bp : this.bodyParts) {
            b.append(new String(bp.getBodyPartBytes(), charset));
        }
        return b.toString();
    }

    @Override
    public InputStream getResponseBodyAsStream() throws IOException {
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        for (HttpResponseBodyPart bp : this.bodyParts) {
            if (!bp.getClass().isAssignableFrom(ResponseBodyPart.class)) continue;
            buf.writeBytes(bp.getBodyPartBytes());
        }
        return new ChannelBufferInputStream(buf);
    }

    @Override
    public String getResponseBodyExcerpt(int maxLength) throws IOException {
        String response;
        String contentType = this.getContentType();
        String charset = "UTF-8";
        if (contentType != null) {
            for (String part : contentType.split(";")) {
                if (!part.startsWith("charset=")) continue;
                charset = part.substring("charset=".length());
            }
        }
        return (response = this.contentToString(charset)).length() <= maxLength ? response : response.substring(0, maxLength);
    }

    @Override
    public URI getUri() throws MalformedURLException {
        return this.uri;
    }

    @Override
    public String getContentType() {
        return this.headers.getHeaders().getFirstValue("Content-Type");
    }

    @Override
    public String getHeader(String name) {
        return this.headers.getHeaders().getFirstValue(name);
    }

    @Override
    public List<String> getHeaders(String name) {
        return this.headers.getHeaders().get(name);
    }

    @Override
    public FluentCaseInsensitiveStringsMap getHeaders() {
        return this.headers.getHeaders();
    }

    @Override
    public boolean isRedirected() {
        return this.status.getStatusCode() >= 300 && this.status.getStatusCode() <= 399;
    }

    @Override
    public List<Cookie> getCookies() {
        if (this.cookies.isEmpty()) {
            for (Map.Entry<String, List<String>> header : this.headers.getHeaders().entrySet()) {
                if (!header.getKey().equalsIgnoreCase("Set-Cookie")) continue;
                for (String value : header.getValue()) {
                    String[] fields = value.split(";\\s*");
                    String[] cookie = fields[0].split("=");
                    String cookieName = cookie[0];
                    String cookieValue = cookie[1];
                    String expires = "-1";
                    String path = null;
                    String domain = null;
                    boolean secure = false;
                    for (int j = 1; j < fields.length; ++j) {
                        if ("secure".equalsIgnoreCase(fields[j])) {
                            secure = true;
                            continue;
                        }
                        if (fields[j].indexOf(61) <= 0) continue;
                        String[] f = fields[j].split("=");
                        if ("expires".equalsIgnoreCase(f[0])) {
                            expires = f[1];
                            continue;
                        }
                        if ("domain".equalsIgnoreCase(f[0])) {
                            domain = f[1];
                            continue;
                        }
                        if (!"path".equalsIgnoreCase(f[0])) continue;
                        path = f[1];
                    }
                    this.cookies.add(new Cookie(domain, cookieName, cookieValue, path, Integer.valueOf(expires), secure));
                }
            }
        }
        return Collections.unmodifiableList(this.cookies);
    }
}

