/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.ByteArrayPart;
import com.ning.http.client.Cookie;
import com.ning.http.client.FilePart;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.FluentStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.MaxRedirectException;
import com.ning.http.client.Part;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.RequestType;
import com.ning.http.client.Response;
import com.ning.http.client.StringPart;
import com.ning.http.client.logging.LogManager;
import com.ning.http.client.logging.Logger;
import com.ning.http.client.providers.NettyAsyncResponse;
import com.ning.http.client.providers.NettyResponseFuture;
import com.ning.http.client.providers.ResponseBodyPart;
import com.ning.http.client.providers.ResponseHeaders;
import com.ning.http.client.providers.ResponseStatus;
import com.ning.http.multipart.ByteArrayPartSource;
import com.ning.http.multipart.MultipartRequestEntity;
import com.ning.http.util.AuthenticatorUtils;
import com.ning.http.util.SslUtils;
import com.ning.http.util.UTF8UrlEncoder;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLEngine;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.handler.codec.http.CookieEncoder;
import org.jboss.netty.handler.codec.http.DefaultCookie;
import org.jboss.netty.handler.codec.http.DefaultHttpChunkTrailer;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpClientCodec;
import org.jboss.netty.handler.codec.http.HttpContentDecompressor;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.timeout.IdleState;
import org.jboss.netty.handler.timeout.IdleStateHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.internal.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NettyAsyncHttpProvider
extends IdleStateHandler
implements AsyncHttpProvider<HttpResponse> {
    private final Logger log = LogManager.getLogger(NettyAsyncHttpProvider.class);
    private final ClientBootstrap bootstrap;
    private static final int MAX_BUFFERED_BYTES = 8192;
    private final AsyncHttpClientConfig config;
    private final ConcurrentHashMap<String, Channel> connectionsPool = new ConcurrentHashMap();
    private final AtomicInteger activeConnectionsCount = new AtomicInteger();
    private final ConcurrentHashMap<String, AtomicInteger> connectionsPerHost = new ConcurrentHashMap();
    private final AtomicBoolean isClose = new AtomicBoolean(false);
    private final NioClientSocketChannelFactory socketChannelFactory;
    private final ChannelGroup openChannels = new DefaultChannelGroup("asyncHttpClient");

    public NettyAsyncHttpProvider(AsyncHttpClientConfig config) {
        super((Timer)new HashedWheelTimer(), 0L, 0L, (long)config.getIdleConnectionTimeoutInMs(), TimeUnit.MILLISECONDS);
        this.socketChannelFactory = new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)config.executorService());
        this.bootstrap = new ClientBootstrap((ChannelFactory)this.socketChannelFactory);
        this.config = config;
    }

    void configure(final boolean useSSL, final ConnectListener<?> cl) {
        this.bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                if (useSSL) {
                    try {
                        SSLEngine sslEngine = NettyAsyncHttpProvider.this.config.getSSLEngine();
                        if (sslEngine == null) {
                            sslEngine = SslUtils.getSSLEngine();
                        }
                        pipeline.addLast("ssl", (ChannelHandler)new SslHandler(sslEngine));
                    }
                    catch (Throwable ex) {
                        cl.future().abort(ex);
                    }
                }
                pipeline.addLast("codec", (ChannelHandler)new HttpClientCodec());
                if (NettyAsyncHttpProvider.this.config.isCompressionEnabled()) {
                    pipeline.addLast("inflater", (ChannelHandler)new HttpContentDecompressor());
                }
                pipeline.addLast("httpProcessor", (ChannelHandler)NettyAsyncHttpProvider.this);
                return pipeline;
            }
        });
    }

    private Channel lookupInCache(URI uri) {
        Channel channel = (Channel)this.connectionsPool.remove((Object)this.getBaseUrl(uri));
        if (channel != null) {
            if (channel.isOpen()) {
                channel.setReadable(true);
            } else {
                return null;
            }
        }
        return channel;
    }

    private static final <T> void executeRequest(final Channel channel, AsyncHttpClientConfig config, final NettyResponseFuture<T> future, HttpRequest nettyRequest) throws ConnectException {
        if (!channel.isConnected()) {
            String url;
            String string = url = channel.getRemoteAddress() != null ? channel.getRemoteAddress().toString() : null;
            if (url == null) {
                try {
                    url = future.getURI().toString();
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            throw new ConnectException(String.format("Connection refused to %s", url));
        }
        channel.getPipeline().getContext(NettyAsyncHttpProvider.class).setAttachment(future);
        channel.write((Object)nettyRequest);
        try {
            future.setReaperFuture(config.reaper().schedule(new Callable<Object>(){

                @Override
                public Object call() {
                    if (!future.isDone() && !future.isCancelled()) {
                        future.abort(new TimeoutException());
                        channel.getPipeline().getContext(NettyAsyncHttpProvider.class).setAttachment(ClosedEvent.class);
                    }
                    return null;
                }
            }, (long)config.getRequestTimeoutInMs(), TimeUnit.MILLISECONDS));
        }
        catch (RejectedExecutionException ex) {
            future.abort(ex);
        }
    }

    private static final HttpRequest buildRequest(AsyncHttpClientConfig config, Request request, URI uri) throws IOException {
        return NettyAsyncHttpProvider.construct(config, request, new HttpMethod(request.getType().toString()), uri);
    }

    private static final URI createUri(String u) {
        URI uri = URI.create(u);
        String scheme = uri.getScheme().toLowerCase();
        if (scheme == null || !scheme.equals("http") && !scheme.equals("https")) {
            throw new IllegalArgumentException("The URI scheme, of the URI " + u + ", must be equal (ignoring case) to 'http'");
        }
        String path = uri.getPath();
        if (path == null) {
            throw new IllegalArgumentException("The URI path, of the URI " + uri + ", must be non-null");
        }
        if (path.length() > 0 && path.charAt(0) != '/') {
            throw new IllegalArgumentException("The URI path, of the URI " + uri + ". must start with a '/'");
        }
        if (path.length() == 0) {
            return URI.create(u + "/");
        }
        return uri;
    }

    private static HttpRequest construct(AsyncHttpClientConfig config, Request request, HttpMethod m, URI uri) throws IOException {
        RequestType type;
        Realm realm;
        String host = uri.getHost();
        if (request.getVirtualHost() != null) {
            host = request.getVirtualHost();
        }
        StringBuilder path = new StringBuilder(uri.getPath());
        if (uri.getQuery() != null) {
            path.append("?").append(uri.getRawQuery());
        }
        DefaultHttpRequest nettyRequest = config.getProxyServer() != null || request.getProxyServer() != null ? new DefaultHttpRequest(HttpVersion.HTTP_1_1, m, uri.toString()) : new DefaultHttpRequest(HttpVersion.HTTP_1_1, m, path.toString());
        nettyRequest.setHeader("Host", (Object)(host + ":" + NettyAsyncHttpProvider.getPort(uri)));
        FluentCaseInsensitiveStringsMap h = request.getHeaders();
        if (h != null) {
            for (String name : h.keySet()) {
                if ("host".equalsIgnoreCase(name)) continue;
                Iterator i$ = h.get(name).iterator();
                while (i$.hasNext()) {
                    String value = (String)i$.next();
                    nettyRequest.addHeader(name, (Object)value);
                }
            }
        }
        if ((realm = request.getRealm()) != null) {
            switch (realm.getAuthScheme()) {
                case BASIC: {
                    nettyRequest.setHeader("Authorization", (Object)AuthenticatorUtils.computeBasicAuthentication(realm));
                    break;
                }
                case DIGEST: {
                    if (realm.getNonce() == null || realm.getNonce().equals("")) break;
                    try {
                        nettyRequest.setHeader("Authorization", (Object)AuthenticatorUtils.computeDigestAuthentication(realm));
                        break;
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new SecurityException(e);
                    }
                }
                default: {
                    throw new IllegalStateException("Invalie AuthType");
                }
            }
        }
        String ka = config.getKeepAlive() ? "keep-alive" : "close";
        nettyRequest.setHeader("Connection", (Object)ka);
        if (config.getProxyServer() != null || request.getProxyServer() != null) {
            nettyRequest.setHeader("Proxy-Connection", (Object)ka);
        }
        if (config.getUserAgent() != null) {
            nettyRequest.setHeader("User-Agent", (Object)config.getUserAgent());
        }
        if (request.getCookies() != null && !request.getCookies().isEmpty()) {
            CookieEncoder httpCookieEncoder = new CookieEncoder(false);
            for (Cookie c : request.getCookies()) {
                DefaultCookie cookie = new DefaultCookie(c.getName(), c.getValue());
                cookie.setPath(c.getPath());
                cookie.setMaxAge(c.getMaxAge());
                cookie.setDomain(c.getDomain());
                httpCookieEncoder.addCookie((org.jboss.netty.handler.codec.http.Cookie)cookie);
            }
            nettyRequest.setHeader("Cookie", (Object)httpCookieEncoder.encode());
        }
        if (config.isCompressionEnabled()) {
            nettyRequest.setHeader("Accept-Encoding", (Object)"gzip");
        }
        if (RequestType.POST.equals((Object)(type = request.getType())) || RequestType.PUT.equals((Object)type)) {
            nettyRequest.setHeader("Content-Length", (Object)"0");
            if (request.getByteData() != null) {
                nettyRequest.setHeader("Content-Length", (Object)String.valueOf(request.getByteData().length));
                nettyRequest.setContent(ChannelBuffers.copiedBuffer((byte[])request.getByteData()));
            } else if (request.getStringData() != null) {
                nettyRequest.setHeader("Content-Length", (Object)String.valueOf(request.getStringData().length()));
                nettyRequest.setContent(ChannelBuffers.copiedBuffer((String)request.getStringData(), (String)"UTF-8"));
            } else if (request.getStreamData() != null) {
                int[] lengthWrapper = new int[1];
                byte[] bytes = NettyAsyncHttpProvider.readFully(request.getStreamData(), lengthWrapper);
                int length = lengthWrapper[0];
                nettyRequest.setHeader("Content-Length", (Object)String.valueOf(length));
                nettyRequest.setContent(ChannelBuffers.copiedBuffer((byte[])bytes, (int)0, (int)length));
            } else if (request.getParams() != null) {
                StringBuilder sb = new StringBuilder();
                for (Map.Entry<String, List<String>> paramEntry : request.getParams()) {
                    String key = paramEntry.getKey();
                    for (String value : paramEntry.getValue()) {
                        if (sb.length() > 0) {
                            sb.append("&");
                        }
                        UTF8UrlEncoder.appendEncoded(sb, key);
                        sb.append("=");
                        UTF8UrlEncoder.appendEncoded(sb, value);
                    }
                }
                nettyRequest.setHeader("Content-Length", (Object)String.valueOf(sb.length()));
                nettyRequest.setContent(ChannelBuffers.copiedBuffer((byte[])sb.toString().getBytes("UTF-8")));
                if (!request.getHeaders().containsKey("Content-Type")) {
                    nettyRequest.setHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                }
            } else if (request.getParts() != null) {
                int lenght = NettyAsyncHttpProvider.computeAndSetContentLength(request, (HttpRequest)nettyRequest);
                if (lenght == -1) {
                    lenght = 8192;
                }
                MultipartRequestEntity mre = NettyAsyncHttpProvider.createMultipartRequestEntity(request.getParts(), request.getParams());
                nettyRequest.setHeader("Content-Type", (Object)mre.getContentType());
                nettyRequest.setHeader("Content-Length", (Object)String.valueOf(mre.getContentLength()));
                ChannelBuffer b = ChannelBuffers.dynamicBuffer((int)lenght);
                mre.writeRequest((OutputStream)new ChannelBufferOutputStream(b));
                nettyRequest.setContent(b);
            } else if (request.getEntityWriter() != null) {
                int lenght = NettyAsyncHttpProvider.computeAndSetContentLength(request, (HttpRequest)nettyRequest);
                if (lenght == -1) {
                    lenght = 8192;
                }
                ChannelBuffer b = ChannelBuffers.dynamicBuffer((int)lenght);
                request.getEntityWriter().writeEntity((OutputStream)new ChannelBufferOutputStream(b));
                nettyRequest.setHeader("Content-Length", (Object)b.writerIndex());
                nettyRequest.setContent(b);
            }
        }
        if (nettyRequest.getHeader("Content-Type") == null) {
            nettyRequest.setHeader("Content-Type", (Object)"text/html; charset=utf-8");
        }
        return nettyRequest;
    }

    @Override
    public void close() {
        this.isClose.set(true);
        this.connectionsPool.clear();
        this.openChannels.close();
        this.releaseExternalResources();
        this.config.reaper().shutdown();
        this.config.executorService().shutdown();
        this.socketChannelFactory.releaseExternalResources();
        this.bootstrap.releaseExternalResources();
    }

    @Override
    public Response prepareResponse(HttpResponseStatus status, HttpResponseHeaders headers, Collection<HttpResponseBodyPart> bodyParts) {
        return new NettyAsyncResponse(status, headers, bodyParts);
    }

    @Override
    public <T> Future<T> execute(Request request, AsyncHandler<T> asyncHandler) throws IOException {
        return this.doConnect(request, asyncHandler, null);
    }

    private <T> void execute(Request request, NettyResponseFuture<T> f) throws IOException {
        this.doConnect(request, f.getAsyncHandler(), f);
    }

    private <T> Future<T> doConnect(Request request, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> f) throws IOException {
        ChannelFuture channelFuture;
        if (this.isClose.get()) {
            throw new IOException("Closed");
        }
        if (this.config.getMaxTotalConnections() != -1 && this.activeConnectionsCount.getAndIncrement() >= this.config.getMaxTotalConnections()) {
            this.activeConnectionsCount.decrementAndGet();
            throw new IOException("Too many connections");
        }
        URI uri = NettyAsyncHttpProvider.createUri(request.getUrl());
        this.log.debug("Lookup cache: %s", uri);
        Channel channel = this.lookupInCache(uri);
        if (channel != null && channel.isOpen()) {
            this.activeConnectionsCount.decrementAndGet();
            HttpRequest nettyRequest = NettyAsyncHttpProvider.buildRequest(this.config, request, uri);
            if (f == null) {
                f = new NettyResponseFuture<T>(uri, request, asyncHandler, nettyRequest, this.config.getRequestTimeoutInMs());
            }
            NettyAsyncHttpProvider.executeRequest(channel, this.config, f, nettyRequest);
            return f;
        }
        ConnectListener<T> c = new ConnectListener.Builder<T>(this.config, request, asyncHandler, f).build();
        this.configure(uri.getScheme().compareToIgnoreCase("https") == 0, c);
        try {
            if (this.config.getProxyServer() == null && request.getProxyServer() == null) {
                channelFuture = this.bootstrap.connect((SocketAddress)new InetSocketAddress(uri.getHost(), NettyAsyncHttpProvider.getPort(uri)));
            } else {
                ProxyServer proxy = request.getProxyServer() == null ? this.config.getProxyServer() : request.getProxyServer();
                channelFuture = this.bootstrap.connect((SocketAddress)new InetSocketAddress(proxy.getHost(), proxy.getPort()));
            }
            this.bootstrap.setOption("connectTimeout", (Object)this.config.getConnectionTimeoutInMs());
        }
        catch (Throwable t) {
            if (this.config.getMaxTotalConnections() != -1) {
                this.activeConnectionsCount.decrementAndGet();
            }
            this.log.error(t);
            c.future().abort(t.getCause());
            return c.future();
        }
        channelFuture.addListener(c);
        this.openChannels.add((Object)channelFuture.getChannel());
        return c.future();
    }

    protected void channelIdle(ChannelHandlerContext ctx, IdleState state, long lastActivityTimeMillis) throws Exception {
        NettyResponseFuture future = (NettyResponseFuture)ctx.getAttachment();
        this.closeChannel(ctx);
        for (Map.Entry e : this.connectionsPool.entrySet()) {
            if (!((Channel)e.getValue()).equals(ctx.getChannel())) continue;
            this.connectionsPool.remove(e.getKey());
            if (this.config.getMaxTotalConnections() == -1) break;
            this.activeConnectionsCount.decrementAndGet();
            break;
        }
        future.abort(new IOException("No response received. Connection timed out after " + this.config.getIdleConnectionTimeoutInMs()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (ctx.getAttachment() instanceof DiscardEvent) {
            ctx.getChannel().setReadable(false);
            return;
        }
        if (!(ctx.getAttachment() instanceof NettyResponseFuture)) {
            return;
        }
        NettyResponseFuture future = (NettyResponseFuture)ctx.getAttachment();
        HttpRequest nettyRequest = future.getNettyRequest();
        AsyncHandler handler = future.getAsyncHandler();
        try {
            if (e.getMessage() instanceof HttpResponse) {
                HttpResponse response = (HttpResponse)e.getMessage();
                future.setHttpResponse(response);
                String ka = response.getHeader("Connection");
                future.setKeepAlive(ka == null || ka.toLowerCase().equals("keep-alive"));
                String wwwAuth = response.getHeader("WWW-Authenticate");
                Request request = future.getRequest();
                if (response.getStatus().getCode() == 401 && wwwAuth != null && future.getRequest().getRealm() != null && !future.isInDigestAuth()) {
                    Realm realm = new Realm.RealmBuilder().clone(request.getRealm()).parseWWWAuthenticateHeader(wwwAuth).setUri(URI.create(request.getUrl()).getPath()).setMethodName(request.getType().toString()).setScheme(Realm.AuthScheme.DIGEST).build();
                    future.setInDigestAuth(true);
                    this.log.debug("Sending authentication to %s", request.getUrl());
                    this.markAsDoneAndCacheConnection(future, ctx.getChannel(), false);
                    RequestBuilder builder = new RequestBuilder(future.getRequest());
                    this.execute(((RequestBuilder)builder.setRealm(realm)).build(), future);
                    return;
                }
                if (this.config.isRedirectEnabled() && (response.getStatus().getCode() == 302 || response.getStatus().getCode() == 301)) {
                    if (future.incrementAndGetCurrentRedirectCount() < this.config.getMaxRedirects()) {
                        String location = response.getHeader("Location");
                        if (location.startsWith("/")) {
                            location = this.getBaseUrl(future.getURI()) + location;
                        }
                        URI uri = NettyAsyncHttpProvider.createUri(location);
                        RequestBuilder builder = new RequestBuilder(future.getRequest());
                        future.setURI(uri);
                        this.closeChannel(ctx);
                        String newUrl = uri.toString();
                        this.log.debug("Redirecting to %s", newUrl);
                        this.execute(builder.setUrl(newUrl).build(), future);
                        return;
                    }
                    throw new MaxRedirectException("Maximum redirect reached: " + this.config.getMaxRedirects());
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Status: %s", response.getStatus());
                    this.log.debug("Version: %s", response.getProtocolVersion());
                    this.log.debug("\"", new Object[0]);
                    if (!response.getHeaderNames().isEmpty()) {
                        for (String name : response.getHeaderNames()) {
                            this.log.debug("Header: %s = %s", name, response.getHeaders(name));
                        }
                        this.log.debug("\"", new Object[0]);
                    }
                }
                if (this.updateStatusAndInterrupt(handler, new ResponseStatus(future.getURI(), response, this))) {
                    this.finishUpdate(future, ctx);
                    return;
                }
                if (this.updateHeadersAndInterrupt(handler, new ResponseHeaders(future.getURI(), response, this))) {
                    this.finishUpdate(future, ctx);
                    return;
                }
                if (!response.isChunked()) {
                    if (response.getContent().readableBytes() != 0) {
                        this.updateBodyAndInterrupt(handler, new ResponseBodyPart(future.getURI(), response, this));
                    }
                    this.finishUpdate(future, ctx);
                    return;
                }
                if (nettyRequest.getMethod().equals((Object)HttpMethod.HEAD)) {
                    this.markAsDoneAndCacheConnection(future, ctx.getChannel(), true);
                }
            } else if (e.getMessage() instanceof HttpChunk) {
                HttpChunk chunk = (HttpChunk)e.getMessage();
                if (handler != null && (chunk.isLast() || this.updateBodyAndInterrupt(handler, new ResponseBodyPart(future.getURI(), null, this, chunk)))) {
                    if (chunk instanceof DefaultHttpChunkTrailer) {
                        this.updateHeadersAndInterrupt(handler, new ResponseHeaders(future.getURI(), future.getHttpResponse(), this, (HttpChunkTrailer)chunk));
                    }
                    this.finishUpdate(future, ctx);
                }
            }
        }
        catch (Exception t) {
            try {
                future.abort(t);
            }
            finally {
                this.finishUpdate(future, ctx);
                throw t;
            }
        }
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        NettyResponseFuture future;
        this.log.debug("Channel closed: %s", e.getState());
        if (!this.isClose.get() && ctx.getAttachment() instanceof NettyResponseFuture && (future = (NettyResponseFuture)ctx.getAttachment()) != null && !future.isDone() && !future.isCancelled()) {
            future.getAsyncHandler().onThrowable(new IOException("No response received. Connection timed out"));
        }
        ctx.sendUpstream((ChannelEvent)e);
    }

    private void markAsDoneAndCacheConnection(NettyResponseFuture<?> future, Channel channel, boolean releaseFuture) throws MalformedURLException {
        if (future.getKeepAlive()) {
            AtomicInteger connectionPerHost = (AtomicInteger)this.connectionsPerHost.get((Object)this.getBaseUrl(future.getURI()));
            if (connectionPerHost == null) {
                connectionPerHost = new AtomicInteger(1);
                this.connectionsPerHost.put((Object)this.getBaseUrl(future.getURI()), (Object)connectionPerHost);
            }
            if (this.config.getMaxConnectionPerHost() == -1 || connectionPerHost.getAndIncrement() < this.config.getMaxConnectionPerHost()) {
                this.connectionsPool.put((Object)this.getBaseUrl(future.getURI()), (Object)channel);
            } else {
                connectionPerHost.decrementAndGet();
                this.log.warn("Maximum connections per hosts reached " + this.config.getMaxConnectionPerHost(), new Object[0]);
            }
        } else if (this.config.getMaxTotalConnections() != -1) {
            this.activeConnectionsCount.decrementAndGet();
        }
        if (releaseFuture) {
            future.done();
        }
    }

    private String getBaseUrl(URI uri) {
        String url = uri.getScheme() + "://" + uri.getAuthority();
        int port = uri.getPort();
        if (port == -1) {
            port = NettyAsyncHttpProvider.getPort(uri);
            url = url + ":" + port;
        }
        return url;
    }

    private static int getPort(URI uri) {
        int port = uri.getPort();
        if (port == -1) {
            port = uri.getScheme().equals("http") ? 80 : 443;
        }
        return port;
    }

    private void finishUpdate(NettyResponseFuture<?> future, ChannelHandlerContext ctx) throws IOException {
        this.closeChannel(ctx);
        this.markAsDoneAndCacheConnection(future, ctx.getChannel(), true);
    }

    private void closeChannel(ChannelHandlerContext ctx) {
        ctx.setAttachment((Object)new DiscardEvent());
        try {
            ctx.getChannel().setReadable(false);
        }
        catch (Exception ex) {
            this.log.debug(ex);
        }
    }

    private final boolean updateStatusAndInterrupt(AsyncHandler handler, HttpResponseStatus c) throws Exception {
        return handler.onStatusReceived(c) != AsyncHandler.STATE.CONTINUE;
    }

    private final boolean updateHeadersAndInterrupt(AsyncHandler handler, HttpResponseHeaders c) throws Exception {
        return handler.onHeadersReceived(c) != AsyncHandler.STATE.CONTINUE;
    }

    private final boolean updateBodyAndInterrupt(AsyncHandler handler, HttpResponseBodyPart c) throws Exception {
        return handler.onBodyPartReceived(c) != AsyncHandler.STATE.CONTINUE;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        NettyResponseFuture future;
        Channel ch = e.getChannel();
        Throwable cause = e.getCause();
        if (this.log.isDebugEnabled()) {
            this.log.debug("I/O Exception during read or doConnect: ", cause);
        }
        if (ctx.getAttachment() instanceof NettyResponseFuture && (future = (NettyResponseFuture)ctx.getAttachment()) != null) {
            future.getAsyncHandler().onThrowable(cause);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(e.toString(), new Object[0]);
            this.log.debug(ch.toString(), new Object[0]);
        }
    }

    private static final int computeAndSetContentLength(Request request, HttpRequest r) {
        int lenght = (int)request.getLength();
        if (lenght == -1 && r.getHeader("Content-Length") != null) {
            lenght = Integer.valueOf(r.getHeader("Content-Length"));
        }
        if (lenght != -1) {
            r.setHeader("Content-Length", (Object)String.valueOf(lenght));
        }
        return lenght;
    }

    private static final MultipartRequestEntity createMultipartRequestEntity(List<Part> params, FluentStringsMap methodParams) throws FileNotFoundException {
        com.ning.http.multipart.Part[] parts = new com.ning.http.multipart.Part[params.size()];
        int i = 0;
        for (Part part : params) {
            if (part instanceof StringPart) {
                parts[i] = new com.ning.http.multipart.StringPart(part.getName(), ((StringPart)part).getValue(), "UTF-8");
            } else if (part instanceof FilePart) {
                parts[i] = new com.ning.http.multipart.FilePart(part.getName(), ((FilePart)part).getFile(), ((FilePart)part).getMimeType(), ((FilePart)part).getCharSet());
            } else if (part instanceof ByteArrayPart) {
                ByteArrayPartSource source = new ByteArrayPartSource(((ByteArrayPart)part).getFileName(), ((ByteArrayPart)part).getData());
                parts[i] = new com.ning.http.multipart.FilePart(part.getName(), source, ((ByteArrayPart)part).getMimeType(), ((ByteArrayPart)part).getCharSet());
            } else {
                if (part == null) {
                    throw new NullPointerException("Part cannot be null");
                }
                throw new IllegalArgumentException(String.format("Unsupported part type for multipart parameter %s", part.getName()));
            }
            ++i;
        }
        return new MultipartRequestEntity(parts, methodParams);
    }

    private static byte[] readFully(InputStream in, int[] lengthWrapper) throws IOException {
        int left;
        int count;
        byte[] b = new byte[Math.max(512, in.available())];
        int offset = 0;
        while ((count = in.read(b, offset, left = b.length - offset)) >= 0) {
            offset += count;
            if (count != left) continue;
            b = NettyAsyncHttpProvider.doubleUp(b);
        }
        lengthWrapper[0] = offset;
        return b;
    }

    private static byte[] doubleUp(byte[] b) {
        int len = b.length;
        byte[] b2 = new byte[len + len];
        System.arraycopy(b, 0, b2, 0, len);
        return b2;
    }

    private static final class ClosedEvent {
        private ClosedEvent() {
        }
    }

    private static final class DiscardEvent {
        private DiscardEvent() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ConnectListener<T>
    implements ChannelFutureListener {
        private final AsyncHttpClientConfig config;
        private final NettyResponseFuture<T> future;
        private final HttpRequest nettyRequest;

        private ConnectListener(AsyncHttpClientConfig config, NettyResponseFuture<T> future, HttpRequest nettyRequest) {
            this.config = config;
            this.future = future;
            this.nettyRequest = nettyRequest;
        }

        public NettyResponseFuture<T> future() {
            return this.future;
        }

        public final void operationComplete(ChannelFuture f) throws Exception {
            try {
                NettyAsyncHttpProvider.executeRequest(f.getChannel(), this.config, this.future, this.nettyRequest);
            }
            catch (ConnectException ex) {
                this.future.abort(ex);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Builder<T> {
            private final Logger log = LogManager.getLogger(Builder.class);
            private final AsyncHttpClientConfig config;
            private final Request request;
            private final AsyncHandler<T> asyncHandler;
            private NettyResponseFuture<T> future;

            public Builder(AsyncHttpClientConfig config, Request request, AsyncHandler<T> asyncHandler) {
                this.config = config;
                this.request = request;
                this.asyncHandler = asyncHandler;
                this.future = null;
            }

            public Builder(AsyncHttpClientConfig config, Request request, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> future) {
                this.config = config;
                this.request = request;
                this.asyncHandler = asyncHandler;
                this.future = future;
            }

            public ConnectListener<T> build() throws IOException {
                URI uri = NettyAsyncHttpProvider.createUri(this.request.getRawUrl());
                HttpRequest nettyRequest = NettyAsyncHttpProvider.buildRequest(this.config, this.request, uri);
                this.log.debug("Executing the doConnect operation: %s", this.asyncHandler);
                if (this.future == null) {
                    this.future = new NettyResponseFuture<T>(uri, this.request, this.asyncHandler, nettyRequest, this.config.getRequestTimeoutInMs());
                }
                return new ConnectListener(this.config, this.future, nettyRequest);
            }
        }
    }
}

