/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client;

import com.ning.http.client.AsyncCompletionHandlerBase;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.Response;
import com.ning.http.client.logging.LogManager;
import com.ning.http.client.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AsyncCompletionHandler<T>
implements AsyncHandler<T> {
    private final Logger log = LogManager.getLogger(AsyncCompletionHandlerBase.class);
    private final Collection<HttpResponseBodyPart> bodies = Collections.synchronizedCollection(new ArrayList());
    private HttpResponseStatus status;
    private HttpResponseHeaders headers;

    @Override
    public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
        this.bodies.add(content);
        return AsyncHandler.STATE.CONTINUE;
    }

    @Override
    public final AsyncHandler.STATE onStatusReceived(HttpResponseStatus status) throws Exception {
        this.status = status;
        return AsyncHandler.STATE.CONTINUE;
    }

    @Override
    public final AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        this.headers = headers;
        return AsyncHandler.STATE.CONTINUE;
    }

    @Override
    public final T onCompleted() throws Exception {
        return this.onCompleted(this.status == null ? null : this.status.provider().prepareResponse(this.status, this.headers, this.bodies));
    }

    @Override
    public void onThrowable(Throwable t) {
        this.log.debug(t);
    }

    public abstract T onCompleted(Response var1) throws Exception;
}

