/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.shaded.com.google.collections.collect;

import com.google.common.annotations.GwtCompatible;
import com.ning.http.shaded.com.google.collections.base.Preconditions;
import com.ning.http.shaded.com.google.collections.collect.AbstractMapBasedMultiset;
import com.ning.http.shaded.com.google.collections.collect.Iterables;
import com.ning.http.shaded.com.google.collections.collect.Serialization;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EnumMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
public final class EnumMultiset<E extends Enum<E>>
extends AbstractMapBasedMultiset<E> {
    private transient Class<E> type;
    private static final long serialVersionUID = 0L;

    public static <E extends Enum<E>> EnumMultiset<E> create(Class<E> type) {
        return new EnumMultiset<E>(type);
    }

    public static <E extends Enum<E>> EnumMultiset<E> create(Iterable<E> elements) {
        Iterator<E> iterator = elements.iterator();
        Preconditions.checkArgument(iterator.hasNext(), "EnumMultiset constructor passed empty Iterable");
        EnumMultiset multiset = new EnumMultiset(((Enum)iterator.next()).getDeclaringClass());
        Iterables.addAll(multiset, elements);
        return multiset;
    }

    private EnumMultiset(Class<E> type) {
        super(new EnumMap(type));
        this.type = type;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeObject(this.type);
        Serialization.writeMultiset(this, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        Class localType;
        stream.defaultReadObject();
        this.type = localType = (Class)stream.readObject();
        this.setBackingMap(new EnumMap(this.type));
        Serialization.populateMultiset(this, stream);
    }
}

