/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.multipart;

import java.io.UnsupportedEncodingException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class MultipartEncodingUtil {
    private static final Logger LOG = LogManager.getLogger(MultipartEncodingUtil.class);

    public static byte[] getAsciiBytes(String data) {
        try {
            return data.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getAsciiString(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        try {
            return new String(data, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] getBytes(String data, String charset) {
        if (data == null) {
            throw new IllegalArgumentException("data may not be null");
        }
        if (charset == null || charset.length() == 0) {
            throw new IllegalArgumentException("charset may not be null or empty");
        }
        try {
            return data.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            if (LOG.isDebugEnabled()) {
                LOG.warn((Object)("Unsupported encoding: " + charset + ". System encoding used."));
            }
            return data.getBytes();
        }
    }
}

