/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.ByteArrayPart;
import com.ning.http.client.Cookie;
import com.ning.http.client.FilePart;
import com.ning.http.client.Headers;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.MaxRedirectException;
import com.ning.http.client.Part;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.RequestType;
import com.ning.http.client.Response;
import com.ning.http.client.StringPart;
import com.ning.http.client.providers.NettyAsyncResponse;
import com.ning.http.client.providers.NettyResponseFuture;
import com.ning.http.client.providers.ResponseBodyPart;
import com.ning.http.client.providers.ResponseHeaders;
import com.ning.http.client.providers.ResponseStatus;
import com.ning.http.multipart.ByteArrayPartSource;
import com.ning.http.multipart.MultipartRequestEntity;
import com.ning.http.shaded.com.google.collections.collect.Multimap;
import com.ning.http.url.Url;
import com.ning.http.util.SslUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLEngine;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.handler.codec.http.CookieEncoder;
import org.jboss.netty.handler.codec.http.DefaultCookie;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpClientCodec;
import org.jboss.netty.handler.codec.http.HttpContentDecompressor;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.timeout.IdleState;
import org.jboss.netty.handler.timeout.IdleStateHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.internal.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NettyAsyncHttpProvider
extends SimpleChannelUpstreamHandler
implements AsyncHttpProvider<HttpResponse> {
    private static final Logger log = LogManager.getLogger(NettyAsyncHttpProvider.class);
    private final ClientBootstrap bootstrap;
    private static final int MAX_BUFFERRED_BYTES = 8192;
    private final AsyncHttpClientConfig config;
    private final ConcurrentHashMap<String, Channel> connectionsPool = new ConcurrentHashMap();
    private final AtomicInteger activeConnectionsCount = new AtomicInteger();
    private final ConcurrentHashMap<String, AtomicInteger> connectionsPerHost = new ConcurrentHashMap();
    private final HashedWheelTimer timer = new HashedWheelTimer();
    private final AtomicBoolean isClose = new AtomicBoolean(false);
    private final NioClientSocketChannelFactory socketChannelFactory;
    private final ChannelGroup openChannels = new DefaultChannelGroup("asyncHttpClient");

    public NettyAsyncHttpProvider(AsyncHttpClientConfig config) {
        this.socketChannelFactory = new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)config.executorService());
        this.bootstrap = new ClientBootstrap((ChannelFactory)this.socketChannelFactory);
        this.config = config;
    }

    void configure(final boolean useSSL, final ConnectListener<?> cl) {
        this.bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                if (useSSL) {
                    try {
                        SSLEngine sslEngine = NettyAsyncHttpProvider.this.config.getSSLEngine();
                        if (sslEngine == null) {
                            sslEngine = SslUtils.getSSLEngine();
                        }
                        pipeline.addLast("ssl", (ChannelHandler)new SslHandler(sslEngine));
                    }
                    catch (Throwable ex) {
                        cl.future().abort(ex);
                    }
                }
                pipeline.addLast("codec", (ChannelHandler)new HttpClientCodec());
                if (NettyAsyncHttpProvider.this.config.isCompressionEnabled()) {
                    pipeline.addLast("inflater", (ChannelHandler)new HttpContentDecompressor());
                }
                IdleStateHandler h = new IdleStateHandler((Timer)NettyAsyncHttpProvider.this.timer, 0L, 0L, NettyAsyncHttpProvider.this.config.getIdleConnectionTimeoutInMs(), TimeUnit.MILLISECONDS){

                    protected void channelIdle(ChannelHandlerContext ctx, IdleState state, long lastActivityTimeMillis) throws Exception {
                        ctx.getChannel().close();
                        for (Map.Entry e : NettyAsyncHttpProvider.this.connectionsPool.entrySet()) {
                            if (!((Channel)e.getValue()).equals(ctx.getChannel())) continue;
                            NettyAsyncHttpProvider.this.connectionsPool.remove(e.getKey());
                            NettyAsyncHttpProvider.this.activeConnectionsCount.decrementAndGet();
                            return;
                        }
                    }
                };
                pipeline.addLast("timeout", (ChannelHandler)h);
                pipeline.addLast("httpProcessor", (ChannelHandler)NettyAsyncHttpProvider.this);
                return pipeline;
            }
        });
    }

    private Channel lookupInCache(Url url) {
        Channel channel = (Channel)this.connectionsPool.remove((Object)url.getBaseUrl());
        if (channel != null) {
            if (channel.isOpen()) {
                channel.setReadable(true);
            } else {
                return null;
            }
        }
        return channel;
    }

    private static final <T> void executeRequest(final Channel channel, AsyncHttpClientConfig config, final NettyResponseFuture<T> future, HttpRequest nettyRequest) throws ConnectException {
        if (!channel.isConnected()) {
            String url;
            String string = url = channel.getRemoteAddress() != null ? channel.getRemoteAddress().toString() : null;
            if (url == null) {
                try {
                    url = future.getUrl().toStringWithoutParams();
                }
                catch (MalformedURLException e) {
                    log.debug((Object)e);
                }
            }
            throw new ConnectException(String.format("Connection refused to %s", url));
        }
        channel.getPipeline().getContext(NettyAsyncHttpProvider.class).setAttachment(future);
        channel.write((Object)nettyRequest);
        try {
            future.setReaperFuture(config.reaper().schedule(new Callable<Object>(){

                @Override
                public Object call() {
                    if (!future.isDone() && !future.isCancelled()) {
                        future.abort(new TimeoutException());
                        channel.getPipeline().getContext(NettyAsyncHttpProvider.class).setAttachment(ClosedEvent.class);
                    }
                    return null;
                }
            }, (long)config.getRequestTimeoutInMs(), TimeUnit.MILLISECONDS));
        }
        catch (RejectedExecutionException ex) {
            future.abort(ex);
        }
    }

    private static final HttpRequest buildRequest(AsyncHttpClientConfig config, Request request, Url url) throws IOException {
        return NettyAsyncHttpProvider.construct(config, request, new HttpMethod(request.getType().toString()), url);
    }

    private static final Url createUrl(String u) {
        URI uri = URI.create(u);
        String scheme = uri.getScheme().toLowerCase();
        if (scheme == null || !scheme.equals("http") && !scheme.equals("https")) {
            throw new IllegalArgumentException("The URI scheme, of the URI " + u + ", must be equal (ignoring case) to 'http'");
        }
        String path = uri.getPath();
        if (path == null) {
            throw new IllegalArgumentException("The URI path, of the URI " + uri + ", must be non-null");
        }
        if (path.length() > 0 && path.charAt(0) != '/') {
            throw new IllegalArgumentException("The URI path, of the URI " + uri + ". must start with a '/'");
        }
        int port = uri.getPort();
        if (port == -1) {
            port = scheme.equals("http") ? 80 : 443;
        }
        return new Url(uri.getScheme(), uri.getHost(), port, uri.getPath(), uri.getQuery());
    }

    private static HttpRequest construct(AsyncHttpClientConfig config, Request request, HttpMethod m, Url url) throws IOException {
        RequestType type;
        String queryString;
        String host = url.getHost();
        if (request.getVirtualHost() != null) {
            host = request.getVirtualHost();
        }
        DefaultHttpRequest nettyRequest = (queryString = url.getQueryString()) != null ? new DefaultHttpRequest(HttpVersion.HTTP_1_1, m, url.getUri()) : new DefaultHttpRequest(HttpVersion.HTTP_1_1, m, url.getPath());
        nettyRequest.setHeader("Host", (Object)(host + ":" + url.getPort()));
        Headers h = request.getHeaders();
        if (h != null) {
            for (String name : h.getHeaderNames()) {
                if ("host".equalsIgnoreCase(name)) continue;
                for (String value : h.getHeaderValues(name)) {
                    nettyRequest.addHeader(name, (Object)value);
                }
            }
        }
        String ka = config.getKeepAlive() ? "keep-alive" : "close";
        nettyRequest.setHeader("Connection", (Object)ka);
        if (config.getProxyServer() != null) {
            nettyRequest.setHeader("Proxy-Connection", (Object)ka);
        }
        if (config.getUserAgent() != null) {
            nettyRequest.setHeader("User-Agent", (Object)config.getUserAgent());
        }
        if (request.getCookies() != null && !request.getCookies().isEmpty()) {
            CookieEncoder httpCookieEncoder = new CookieEncoder(false);
            for (Cookie c : request.getCookies()) {
                DefaultCookie cookie = new DefaultCookie(c.getName(), c.getValue());
                cookie.setPath(c.getPath());
                cookie.setMaxAge(c.getMaxAge());
                cookie.setDomain(c.getDomain());
                httpCookieEncoder.addCookie((org.jboss.netty.handler.codec.http.Cookie)cookie);
            }
            nettyRequest.setHeader("Cookie", (Object)httpCookieEncoder.encode());
        }
        if (config.isCompressionEnabled()) {
            nettyRequest.setHeader("Accept-Encoding", (Object)"gzip");
        }
        if (RequestType.POST.equals((Object)(type = request.getType())) || RequestType.PUT.equals((Object)type)) {
            nettyRequest.setHeader("Content-Length", (Object)"0");
            if (request.getByteData() != null) {
                nettyRequest.setHeader("Content-Length", (Object)String.valueOf(request.getByteData().length));
                nettyRequest.setContent(ChannelBuffers.copiedBuffer((byte[])request.getByteData()));
            } else if (request.getStringData() != null) {
                nettyRequest.setHeader("Content-Length", (Object)String.valueOf(request.getStringData().length()));
                nettyRequest.setContent(ChannelBuffers.copiedBuffer((String)request.getStringData(), (String)"UTF-8"));
            } else if (request.getStreamData() != null) {
                nettyRequest.setHeader("Content-Length", (Object)String.valueOf(request.getStreamData().available()));
                byte[] b = new byte[request.getStreamData().available()];
                request.getStreamData().read(b);
                nettyRequest.setContent(ChannelBuffers.copiedBuffer((byte[])b));
            } else if (request.getParams() != null) {
                StringBuilder sb = new StringBuilder();
                for (Map.Entry<String, String> param : request.getParams().entries()) {
                    sb.append(param.getKey());
                    sb.append("=");
                    sb.append(param.getValue());
                    sb.append("&");
                }
                sb.deleteCharAt(sb.length() - 1);
                nettyRequest.setHeader("Content-Length", (Object)String.valueOf(sb.length()));
                nettyRequest.setContent(ChannelBuffers.copiedBuffer((byte[])sb.toString().getBytes()));
                if (!request.getHeaders().isDefined("Content-Type")) {
                    nettyRequest.setHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                }
            } else if (request.getParts() != null) {
                int lenght = NettyAsyncHttpProvider.computeAndSetContentLength(request, (HttpRequest)nettyRequest);
                if (lenght == -1) {
                    lenght = 8192;
                }
                MultipartRequestEntity mre = NettyAsyncHttpProvider.createMultipartRequestEntity(request.getParts(), request.getParams());
                nettyRequest.setHeader("Content-Type", (Object)mre.getContentType());
                nettyRequest.setHeader("Content-Length", (Object)String.valueOf(mre.getContentLength()));
                ChannelBuffer b = ChannelBuffers.dynamicBuffer((int)lenght);
                mre.writeRequest((OutputStream)new ChannelBufferOutputStream(b));
                nettyRequest.setContent(b);
            } else if (request.getEntityWriter() != null) {
                int lenght = NettyAsyncHttpProvider.computeAndSetContentLength(request, (HttpRequest)nettyRequest);
                if (lenght == -1) {
                    lenght = 8192;
                }
                ChannelBuffer b = ChannelBuffers.dynamicBuffer((int)lenght);
                request.getEntityWriter().writeEntity((OutputStream)new ChannelBufferOutputStream(b));
                nettyRequest.setHeader("Content-Length", (Object)b.writerIndex());
                nettyRequest.setContent(b);
            }
        }
        if (nettyRequest.getHeader("Content-Type") == null) {
            nettyRequest.setHeader("Content-Type", (Object)"text/html; charset=utf-8");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Constructed request: " + nettyRequest));
        }
        return nettyRequest;
    }

    @Override
    public void close() {
        this.isClose.set(true);
        this.connectionsPool.clear();
        this.openChannels.close();
        this.timer.stop();
        this.config.reaper().shutdown();
        this.config.executorService().shutdown();
        this.socketChannelFactory.releaseExternalResources();
        this.bootstrap.releaseExternalResources();
    }

    @Override
    public Response prepareResponse(HttpResponseStatus status, HttpResponseHeaders headers, Collection<HttpResponseBodyPart> bodyParts) {
        return new NettyAsyncResponse(status, headers, bodyParts);
    }

    @Override
    public <T> Future<T> execute(Request request, AsyncHandler<T> asyncHandler) throws IOException {
        return this.doConnect(request, asyncHandler, null);
    }

    private <T> void execute(Request request, NettyResponseFuture<T> f) throws IOException {
        this.doConnect(request, f.getAsyncHandler(), f);
    }

    private <T> Future<T> doConnect(Request request, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> f) throws IOException {
        ChannelFuture channelFuture;
        Channel channel;
        if (this.isClose.get()) {
            throw new IOException("Closed");
        }
        if (this.activeConnectionsCount.getAndIncrement() >= this.config.getMaxTotalConnections()) {
            throw new IOException("Too many connections");
        }
        Url url = NettyAsyncHttpProvider.createUrl(request.getUrl());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Lookup cache: " + url.toString()));
        }
        if ((channel = this.lookupInCache(url)) != null && channel.isOpen()) {
            HttpRequest nettyRequest = NettyAsyncHttpProvider.buildRequest(this.config, request, url);
            if (f == null) {
                f = new NettyResponseFuture<T>(url, request, asyncHandler, nettyRequest, this.config.getRequestTimeoutInMs());
            }
            NettyAsyncHttpProvider.executeRequest(channel, this.config, f, nettyRequest);
            return f;
        }
        ConnectListener<T> c = new ConnectListener.Builder<T>(this.config, request, asyncHandler, f).build();
        this.configure(url.getProtocol().compareTo(Url.Protocol.HTTPS) == 0, c);
        try {
            channelFuture = this.config.getProxyServer() == null ? this.bootstrap.connect((SocketAddress)new InetSocketAddress(url.getHost(), url.getPort())) : this.bootstrap.connect((SocketAddress)new InetSocketAddress(this.config.getProxyServer().getHost(), this.config.getProxyServer().getPort()));
            this.bootstrap.setOption("connectTimeout", (Object)this.config.getConnectionTimeoutInMs());
        }
        catch (Throwable t) {
            this.activeConnectionsCount.decrementAndGet();
            log.error((Object)t);
            c.future().abort(t.getCause());
            return c.future();
        }
        channelFuture.addListener(c);
        this.openChannels.add((Object)channelFuture.getChannel());
        return c.future();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        block24: {
            if (ctx.getAttachment() instanceof DiscardEvent) {
                ctx.getChannel().setReadable(false);
                return;
            }
            NettyResponseFuture future = (NettyResponseFuture)ctx.getAttachment();
            HttpRequest nettyRequest = future.getNettyRequest();
            AsyncHandler handler = future.getAsyncHandler();
            try {
                if (e.getMessage() instanceof HttpResponse) {
                    HttpResponse response = (HttpResponse)e.getMessage();
                    future.setHttpResponse(response);
                    String ka = response.getHeader("Connection");
                    future.setKeepAlive(ka == null || ka.toLowerCase().equals("keep-alive"));
                    if (this.config.isRedirectEnabled() && (response.getStatus().getCode() == 302 || response.getStatus().getCode() == 301)) {
                        if (future.incrementAndGetCurrentRedirectCount() < this.config.getMaxRedirects()) {
                            RequestBuilder builder;
                            Url url;
                            block23: {
                                String location = response.getHeader("Location");
                                if (location.startsWith("/")) {
                                    location = future.getUrl().getBaseUrl() + location;
                                }
                                url = NettyAsyncHttpProvider.createUrl(location);
                                builder = new RequestBuilder(future.getRequest());
                                future.setUrl(url);
                                ctx.setAttachment((Object)new DiscardEvent());
                                try {
                                    ctx.getChannel().setReadable(false);
                                }
                                catch (Exception ex) {
                                    if (!log.isTraceEnabled()) break block23;
                                    log.trace((Object)ex);
                                }
                            }
                            String newUrl = url.toString();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)String.format("Redirecting to %s", newUrl));
                            }
                            this.execute(builder.setUrl(newUrl).build(), future);
                            return;
                        }
                        throw new MaxRedirectException("Maximum redirect reached: " + this.config.getMaxRedirects());
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Status: " + response.getStatus()));
                        log.debug((Object)("Version: " + response.getProtocolVersion()));
                        log.debug((Object)"\"");
                        if (!response.getHeaderNames().isEmpty()) {
                            for (String name : response.getHeaderNames()) {
                                log.debug((Object)("Header: " + name + " = " + response.getHeaders(name)));
                            }
                            log.debug((Object)"\"");
                        }
                    }
                    if (this.updateStatusAndInterrupt(handler, new ResponseStatus(future.getUrl(), response, this))) {
                        this.finishUpdate(future, ctx);
                        return;
                    }
                    if (this.updateHeadersAndInterrupt(handler, new ResponseHeaders(future.getUrl(), response, this))) {
                        this.finishUpdate(future, ctx);
                        return;
                    }
                    if (!response.isChunked()) {
                        this.updateBodyAndInterrupt(handler, new ResponseBodyPart(future.getUrl(), response, this));
                        this.finishUpdate(future, ctx);
                        return;
                    }
                    if (response.getStatus().getCode() != 200 || nettyRequest.getMethod().equals((Object)HttpMethod.HEAD)) {
                        this.markAsDoneAndCacheConnection(future, ctx.getChannel());
                    }
                    break block24;
                }
                if (e.getMessage() instanceof HttpChunk) {
                    HttpChunk chunk = (HttpChunk)e.getMessage();
                    if (handler != null && (this.updateBodyAndInterrupt(handler, new ResponseBodyPart(future.getUrl(), null, this, chunk)) || chunk.isLast())) {
                        if (chunk instanceof HttpChunkTrailer) {
                            this.updateHeadersAndInterrupt(handler, new ResponseHeaders(future.getUrl(), future.getHttpResponse(), this, (HttpChunkTrailer)chunk));
                        }
                        this.finishUpdate(future, ctx);
                    }
                }
            }
            catch (Exception t) {
                try {
                    future.abort(t);
                }
                finally {
                    this.finishUpdate(future, ctx);
                    throw t;
                }
            }
        }
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        NettyResponseFuture future;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Channel closed: " + e.getState().toString()));
        }
        if (!this.isClose.get() && ctx.getAttachment() instanceof NettyResponseFuture && (future = (NettyResponseFuture)ctx.getAttachment()) != null && !future.isDone() && !future.isCancelled()) {
            future.getAsyncHandler().onThrowable(new IOException("No response received. Connection timed out"));
        }
        ctx.sendUpstream((ChannelEvent)e);
    }

    private void markAsDoneAndCacheConnection(NettyResponseFuture<?> future, Channel channel) throws MalformedURLException {
        if (future.getKeepAlive()) {
            AtomicInteger connectionPerHost = (AtomicInteger)this.connectionsPerHost.get((Object)future.getUrl().getBaseUrl());
            if (connectionPerHost == null) {
                connectionPerHost = new AtomicInteger(1);
                this.connectionsPerHost.put((Object)future.getUrl().getBaseUrl(), (Object)connectionPerHost);
            }
            if (connectionPerHost.getAndIncrement() < this.config.getMaxConnectionPerHost()) {
                this.connectionsPool.put((Object)future.getUrl().getBaseUrl(), (Object)channel);
            } else {
                log.warn((Object)("Maximum connections per hosts reached " + this.config.getMaxConnectionPerHost()));
            }
        } else {
            this.activeConnectionsCount.decrementAndGet();
        }
        future.done();
    }

    private void finishUpdate(NettyResponseFuture<?> future, ChannelHandlerContext ctx) throws IOException {
        block2: {
            ctx.setAttachment((Object)new DiscardEvent());
            try {
                ctx.getChannel().setReadable(false);
            }
            catch (Exception ex) {
                if (!log.isTraceEnabled()) break block2;
                log.trace((Object)ex);
            }
        }
        this.markAsDoneAndCacheConnection(future, ctx.getChannel());
    }

    private final boolean updateStatusAndInterrupt(AsyncHandler handler, HttpResponseStatus c) throws Exception {
        return handler.onStatusReceived(c) != AsyncHandler.STATE.CONTINUE;
    }

    private final boolean updateHeadersAndInterrupt(AsyncHandler handler, HttpResponseHeaders c) throws Exception {
        return handler.onHeadersReceived(c) != AsyncHandler.STATE.CONTINUE;
    }

    private final boolean updateBodyAndInterrupt(AsyncHandler handler, HttpResponseBodyPart c) throws Exception {
        return handler.onBodyPartReceived(c) != AsyncHandler.STATE.CONTINUE;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        NettyResponseFuture future;
        Channel ch = e.getChannel();
        Throwable cause = e.getCause();
        if (log.isDebugEnabled()) {
            log.debug((Object)"I/O Exception during read or doConnect: ", cause);
        }
        if (ctx.getAttachment() instanceof NettyResponseFuture && (future = (NettyResponseFuture)ctx.getAttachment()) != null) {
            future.getAsyncHandler().onThrowable(cause);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)e);
            log.debug((Object)ch);
        }
    }

    private static final int computeAndSetContentLength(Request request, HttpRequest r) {
        int lenght = (int)request.getLength();
        if (lenght == -1 && r.getHeader("Content-Length") != null) {
            lenght = Integer.valueOf(r.getHeader("Content-Length"));
        }
        if (lenght != -1) {
            r.setHeader("Content-Length", (Object)String.valueOf(lenght));
        }
        return lenght;
    }

    private static final MultipartRequestEntity createMultipartRequestEntity(List<Part> params, Multimap<String, String> methodParams) throws FileNotFoundException {
        com.ning.http.multipart.Part[] parts = new com.ning.http.multipart.Part[params.size()];
        int i = 0;
        for (Part part : params) {
            if (part instanceof StringPart) {
                parts[i] = new com.ning.http.multipart.StringPart(part.getName(), ((StringPart)part).getValue(), "UTF-8");
            } else if (part instanceof FilePart) {
                parts[i] = new com.ning.http.multipart.FilePart(part.getName(), ((FilePart)part).getFile(), ((FilePart)part).getMimeType(), ((FilePart)part).getCharSet());
            } else if (part instanceof ByteArrayPart) {
                ByteArrayPartSource source = new ByteArrayPartSource(((ByteArrayPart)part).getFileName(), ((ByteArrayPart)part).getData());
                parts[i] = new com.ning.http.multipart.FilePart(part.getName(), source, ((ByteArrayPart)part).getMimeType(), ((ByteArrayPart)part).getCharSet());
            } else {
                if (part == null) {
                    throw new NullPointerException("Part cannot be null");
                }
                throw new IllegalArgumentException(String.format("Unsupported part type for multipart parameter %s", part.getName()));
            }
            ++i;
        }
        return new MultipartRequestEntity(parts, methodParams);
    }

    private static final class ClosedEvent {
        private ClosedEvent() {
        }
    }

    private static final class DiscardEvent {
        private DiscardEvent() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ConnectListener<T>
    implements ChannelFutureListener {
        private final AsyncHttpClientConfig config;
        private final NettyResponseFuture<T> future;
        private final HttpRequest nettyRequest;

        private ConnectListener(AsyncHttpClientConfig config, NettyResponseFuture<T> future, HttpRequest nettyRequest) {
            this.config = config;
            this.future = future;
            this.nettyRequest = nettyRequest;
        }

        public NettyResponseFuture<T> future() {
            return this.future;
        }

        public final void operationComplete(ChannelFuture f) throws Exception {
            try {
                NettyAsyncHttpProvider.executeRequest(f.getChannel(), this.config, this.future, this.nettyRequest);
            }
            catch (ConnectException ex) {
                this.future.abort(ex);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Builder<T> {
            private final AsyncHttpClientConfig config;
            private final Request request;
            private final AsyncHandler<T> asyncHandler;
            private NettyResponseFuture<T> future;

            public Builder(AsyncHttpClientConfig config, Request request, AsyncHandler<T> asyncHandler) {
                this.config = config;
                this.request = request;
                this.asyncHandler = asyncHandler;
                this.future = null;
            }

            public Builder(AsyncHttpClientConfig config, Request request, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> future) {
                this.config = config;
                this.request = request;
                this.asyncHandler = asyncHandler;
                this.future = future;
            }

            public ConnectListener<T> build() throws IOException {
                Url url = NettyAsyncHttpProvider.createUrl(this.request.getUrl());
                HttpRequest nettyRequest = NettyAsyncHttpProvider.buildRequest(this.config, this.request, url);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Executing the doConnect operation: " + this.asyncHandler));
                }
                if (this.future == null) {
                    this.future = new NettyResponseFuture<T>(url, this.request, this.asyncHandler, nettyRequest, this.config.getRequestTimeoutInMs());
                }
                return new ConnectListener(this.config, this.future, nettyRequest);
            }
        }
    }
}

