/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Headers
implements Iterable<Map.Entry<String, List<String>>> {
    private final Map<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
    private final Map<String, String> headerNames = new LinkedHashMap<String, String>();

    public static Headers unmodifiableHeaders(Headers headers) {
        return new UnmodifiableHeaders(headers);
    }

    public Headers() {
    }

    public Headers(Headers src) {
        if (src != null) {
            for (Map.Entry<String, List<String>> header : src) {
                this.add(header.getKey(), (Collection<String>)header.getValue());
            }
        }
    }

    public Headers(Map<String, Collection<String>> src) {
        if (src != null) {
            for (Map.Entry<String, Collection<String>> header : src.entrySet()) {
                this.add(header.getKey(), header.getValue());
            }
        }
    }

    public Headers add(String name, String ... values) {
        if (values != null && values.length > 0) {
            this.add(name, Arrays.asList(values));
        }
        return this;
    }

    private List<String> getNonNullValues(Collection<String> values) {
        ArrayList<String> result = null;
        if (values != null) {
            for (String value : values) {
                if (value == null) continue;
                if (result == null) {
                    result = new ArrayList<String>();
                }
                result.add(value);
            }
        }
        return result;
    }

    public Headers add(String name, Collection<String> values) {
        List<String> nonNullValues = this.getNonNullValues(values);
        if (nonNullValues != null) {
            String key = name.toLowerCase();
            String usedName = this.headerNames.get(key);
            List<String> curValues = null;
            if (usedName == null) {
                usedName = name;
                this.headerNames.put(key, name);
            } else {
                curValues = this.headers.get(usedName);
            }
            if (curValues == null) {
                curValues = new ArrayList<String>();
                this.headers.put(usedName, curValues);
            }
            curValues.addAll(nonNullValues);
        }
        return this;
    }

    public Headers addAll(Headers src) {
        if (src != null) {
            for (Map.Entry<String, List<String>> header : src) {
                this.add(header.getKey(), (Collection<String>)header.getValue());
            }
        }
        return this;
    }

    public Headers addAll(Map<String, Collection<String>> src) {
        if (src != null) {
            for (Map.Entry<String, Collection<String>> header : src.entrySet()) {
                this.add(header.getKey(), header.getValue());
            }
        }
        return this;
    }

    public Headers replace(String name, String ... values) {
        return this.replace(name, Arrays.asList(values));
    }

    public Headers replace(String name, Collection<String> values) {
        List<String> nonNullValues = this.getNonNullValues(values);
        String key = name.toLowerCase();
        String usedName = this.headerNames.get(key);
        if (nonNullValues == null) {
            this.headerNames.remove(key);
            if (usedName != null) {
                this.headers.remove(usedName);
            }
        } else {
            if (!name.equals(usedName)) {
                this.headerNames.put(key, name);
                this.headers.remove(usedName);
            }
            this.headers.put(name, nonNullValues);
        }
        return this;
    }

    public Headers replaceAll(Headers src) {
        if (src != null) {
            for (Map.Entry<String, List<String>> header : src) {
                this.replace(header.getKey(), (Collection<String>)header.getValue());
            }
        }
        return this;
    }

    public Headers replaceAll(Map<String, Collection<String>> src) {
        if (src != null) {
            for (Map.Entry<String, Collection<String>> header : src.entrySet()) {
                this.replace(header.getKey(), header.getValue());
            }
        }
        return this;
    }

    @Override
    public Iterator<Map.Entry<String, List<String>>> iterator() {
        return Collections.unmodifiableSet(this.headers.entrySet()).iterator();
    }

    public Set<String> getHeaderNames() {
        return new LinkedHashSet<String>(this.headerNames.values());
    }

    public boolean isDefined(String name) {
        return this.headerNames.containsKey(name.toLowerCase());
    }

    public String getFirstHeaderValue(String name) {
        List<String> values = this.getHeaderValues(name);
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return "";
        }
        return values.get(0);
    }

    public String getHeaderValue(String name) {
        List<String> values = this.getHeaderValues(name);
        if (values == null) {
            return null;
        }
        if (values.size() == 1) {
            return values.get(0);
        }
        StringBuilder result = new StringBuilder();
        for (String value : values) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(value);
        }
        return result.toString();
    }

    public List<String> getHeaderValues(String name) {
        String key = name.toLowerCase();
        String usedName = this.headerNames.get(key);
        if (usedName == null) {
            return null;
        }
        List<String> values = this.headers.get(usedName);
        return values == null ? Collections.emptyList() : Collections.unmodifiableList(values);
    }

    public Headers remove(String name) {
        String key = name.toLowerCase();
        String usedName = this.headerNames.remove(key);
        if (usedName != null) {
            this.headers.remove(usedName);
        }
        return this;
    }

    public Headers removeAll(String ... names) {
        if (names != null) {
            for (String name : names) {
                this.remove(name);
            }
        }
        return this;
    }

    public Headers removeAll(Collection<String> names) {
        if (names != null) {
            for (String name : names) {
                this.remove(name);
            }
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Headers other = (Headers)obj;
        return !(this.headers == null ? other.headers != null : !((Object)this.headers).equals(other.headers));
    }

    public int hashCode() {
        return this.headers == null ? 0 : ((Object)this.headers).hashCode();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
            if (result.length() > 0) {
                result.append("; ");
            }
            result.append("\"");
            result.append(entry.getKey());
            result.append("=");
            boolean needsComma = false;
            for (String value : entry.getValue()) {
                if (needsComma) {
                    result.append(", ");
                } else {
                    needsComma = true;
                }
                result.append(value);
            }
            result.append("\"");
        }
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableHeaders
    extends Headers {
        final Headers headers;

        UnmodifiableHeaders(Headers headers) {
            this.headers = headers;
        }

        @Override
        public Headers add(String name, String ... values) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Headers add(String name, Collection<String> values) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Headers addAll(Headers src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Headers addAll(Map<String, Collection<String>> src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof Headers && this.headers.equals(obj);
        }

        @Override
        public int hashCode() {
            return this.headers.hashCode();
        }

        @Override
        public String getHeaderValue(String name) {
            return this.headers.getHeaderValue(name);
        }

        @Override
        public Set<String> getHeaderNames() {
            return this.headers.getHeaderNames();
        }

        @Override
        public List<String> getHeaderValues(String name) {
            return this.headers.getHeaderValues(name);
        }

        @Override
        public boolean isDefined(String name) {
            return this.headers.isDefined(name);
        }

        @Override
        public Iterator<Map.Entry<String, List<String>>> iterator() {
            return this.headers.iterator();
        }

        @Override
        public Headers remove(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Headers replace(String header, String ... values) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Headers replace(String header, Collection<String> values) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toString() {
            return this.headers.toString();
        }
    }
}

