/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client;

import com.ning.http.client.AsyncCompletionHandlerBase;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.Cookie;
import com.ning.http.client.Headers;
import com.ning.http.client.Part;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilderBase;
import com.ning.http.client.RequestType;
import com.ning.http.client.Response;
import com.ning.http.shaded.com.google.collections.collect.Multimap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncHttpClient {
    private static final String DEFAULT_PROVIDER = "com.ning.http.client.providers.NettyAsyncHttpProvider";
    private final AsyncHttpProvider<?> httpProvider;
    private final AsyncHttpClientConfig config;

    public AsyncHttpClient() {
        this(new AsyncHttpClientConfig.Builder().build());
    }

    public AsyncHttpClient(AsyncHttpProvider<?> provider) {
        this(provider, new AsyncHttpClientConfig.Builder().build());
    }

    public AsyncHttpClient(AsyncHttpClientConfig config) {
        this(AsyncHttpClient.loadDefaultProvider(DEFAULT_PROVIDER, config), config);
    }

    public AsyncHttpClient(AsyncHttpProvider<?> httpProvider, AsyncHttpClientConfig config) {
        this.config = config;
        this.httpProvider = httpProvider;
    }

    public AsyncHttpClient(String providerClass, AsyncHttpClientConfig config) {
        this.config = new AsyncHttpClientConfig.Builder().build();
        this.httpProvider = AsyncHttpClient.loadDefaultProvider(providerClass, config);
    }

    public AsyncHttpProvider<?> getProvider() {
        return this.httpProvider;
    }

    public void close() {
        this.httpProvider.close();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public AsyncHttpClientConfig getConfig() {
        return this.config;
    }

    public BoundRequestBuilder prepareGet(String url) {
        return new BoundRequestBuilder(RequestType.GET).setUrl(url);
    }

    public BoundRequestBuilder prepareOptions(String url) {
        return new BoundRequestBuilder(RequestType.OPTIONS).setUrl(url);
    }

    public BoundRequestBuilder prepareHead(String url) {
        return new BoundRequestBuilder(RequestType.HEAD).setUrl(url);
    }

    public BoundRequestBuilder preparePost(String url) {
        return new BoundRequestBuilder(RequestType.POST).setUrl(url);
    }

    public BoundRequestBuilder preparePut(String url) {
        return new BoundRequestBuilder(RequestType.PUT).setUrl(url);
    }

    public BoundRequestBuilder prepareDelete(String url) {
        return new BoundRequestBuilder(RequestType.DELETE).setUrl(url);
    }

    public BoundRequestBuilder prepareRequest(Request request) {
        return new BoundRequestBuilder(request);
    }

    public <T> Future<T> executeRequest(Request request, AsyncHandler<T> handler) throws IOException {
        return this.httpProvider.execute(request, handler);
    }

    public Future<Response> executeRequest(Request request) throws IOException {
        return this.httpProvider.execute(request, new AsyncCompletionHandlerBase());
    }

    private static final AsyncHttpProvider<?> loadDefaultProvider(String className, AsyncHttpClientConfig config) {
        try {
            Class<?> providerClass = Thread.currentThread().getContextClassLoader().loadClass(className);
            return (AsyncHttpProvider)providerClass.getDeclaredConstructor(AsyncHttpClientConfig.class).newInstance(config);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BoundRequestBuilder
    extends RequestBuilderBase<BoundRequestBuilder> {
        private BoundRequestBuilder(RequestType type) {
            super(BoundRequestBuilder.class, type);
        }

        private BoundRequestBuilder(Request prototype) {
            super(BoundRequestBuilder.class, prototype);
        }

        public <T> Future<T> execute(AsyncHandler<T> handler) throws IOException {
            return AsyncHttpClient.this.executeRequest(this.build(), handler);
        }

        public Future<Response> execute() throws IOException {
            return AsyncHttpClient.this.executeRequest(this.build(), new AsyncCompletionHandlerBase());
        }

        @Override
        public BoundRequestBuilder addBodyPart(Part part) throws IllegalArgumentException {
            return (BoundRequestBuilder)super.addBodyPart(part);
        }

        @Override
        public BoundRequestBuilder addCookie(Cookie cookie) {
            return (BoundRequestBuilder)super.addCookie(cookie);
        }

        @Override
        public BoundRequestBuilder addHeader(String name, String value) {
            return (BoundRequestBuilder)super.addHeader(name, value);
        }

        @Override
        public BoundRequestBuilder addParameter(String key, String value) throws IllegalArgumentException {
            return (BoundRequestBuilder)super.addParameter(key, value);
        }

        @Override
        public BoundRequestBuilder addQueryParameter(String name, String value) {
            return (BoundRequestBuilder)super.addQueryParameter(name, value);
        }

        @Override
        public Request build() {
            return super.build();
        }

        @Override
        public BoundRequestBuilder setBody(byte[] data) throws IllegalArgumentException {
            return (BoundRequestBuilder)super.setBody(data);
        }

        @Override
        public BoundRequestBuilder setBody(Request.EntityWriter dataWriter, long length) throws IllegalArgumentException {
            return (BoundRequestBuilder)super.setBody(dataWriter, length);
        }

        @Override
        public BoundRequestBuilder setBody(Request.EntityWriter dataWriter) {
            return (BoundRequestBuilder)super.setBody(dataWriter);
        }

        @Override
        public BoundRequestBuilder setBody(InputStream stream) throws IllegalArgumentException {
            return (BoundRequestBuilder)super.setBody(stream);
        }

        @Override
        public BoundRequestBuilder setBody(String data) throws IllegalArgumentException {
            return (BoundRequestBuilder)super.setBody(data);
        }

        @Override
        public BoundRequestBuilder setHeader(String name, String value) {
            return (BoundRequestBuilder)super.setHeader(name, value);
        }

        @Override
        public BoundRequestBuilder setHeaders(Headers headers) {
            return (BoundRequestBuilder)super.setHeaders(headers);
        }

        @Override
        public BoundRequestBuilder setHeaders(Map<String, Collection<String>> headers) {
            return (BoundRequestBuilder)super.setHeaders(headers);
        }

        @Override
        public BoundRequestBuilder setParameters(Map<String, String> parameters) throws IllegalArgumentException {
            return (BoundRequestBuilder)super.setParameters(parameters);
        }

        @Override
        public BoundRequestBuilder setParameters(Multimap<String, String> parameters) throws IllegalArgumentException {
            return (BoundRequestBuilder)super.setParameters(parameters);
        }

        @Override
        public BoundRequestBuilder setUrl(String url) {
            return (BoundRequestBuilder)super.setUrl(url);
        }

        @Override
        public BoundRequestBuilder setVirtualHost(String virtualHost) {
            return (BoundRequestBuilder)super.setVirtualHost(virtualHost);
        }
    }
}

