/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.monitor;

import com.codahale.metrics.CachedGauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class MonitorRegistries {
    private static MetricRegistry metricRegistry;
    private static HealthCheckRegistry healthCheckRegistry;
    private static long entryCountCacheTimeout;

    public static MetricRegistry getMetricRegistry() {
        if (metricRegistry == null) {
            metricRegistry = new MetricRegistry();
        }
        return metricRegistry;
    }

    public static HealthCheckRegistry getHealthCheckRegistry() {
        if (healthCheckRegistry == null) {
            healthCheckRegistry = new HealthCheckRegistry();
        }
        return healthCheckRegistry;
    }

    public static void register(MetricSet metricSet) {
        if (metricSet == null) {
            return;
        }
        for (Map.Entry entry : metricSet.getMetrics().entrySet()) {
            MonitorRegistries.register((String)entry.getKey(), (Metric)entry.getValue());
        }
    }

    public static void register(String name, Metric metric) {
        if (name == null) {
            return;
        }
        if (metric != null) {
            if (MonitorRegistries.getMetricRegistry().getNames().contains(name)) {
                MonitorRegistries.getMetricRegistry().remove(name);
            }
            MonitorRegistries.getMetricRegistry().register(name, metric);
        } else {
            MonitorRegistries.getMetricRegistry().remove(name);
        }
    }

    public static void registerEntryCountGauge(String name, final Supplier<Integer> supplier) {
        Object metricToRegister = entryCountCacheTimeout < 0L ? () -> -1 : (entryCountCacheTimeout == 0L ? supplier::get : new CachedGauge<Integer>(entryCountCacheTimeout, TimeUnit.SECONDS){

            protected Integer loadValue() {
                return (Integer)supplier.get();
            }
        });
        MonitorRegistries.register(name, (Metric)metricToRegister);
    }

    public static long getEntryCountCacheTimeout() {
        return entryCountCacheTimeout;
    }

    public static void setEntryCountCacheTimeout(long entryCountCacheTimeout) {
        MonitorRegistries.entryCountCacheTimeout = entryCountCacheTimeout;
    }

    public static void register(String name, HealthCheck check) {
        if (name == null) {
            return;
        }
        if (check != null) {
            if (MonitorRegistries.getHealthCheckRegistry().getNames().contains(name)) {
                MonitorRegistries.getHealthCheckRegistry().unregister(name);
            }
            MonitorRegistries.getHealthCheckRegistry().register(name, check);
        } else {
            MonitorRegistries.getHealthCheckRegistry().unregister(name);
        }
    }

    private MonitorRegistries() {
    }

    static {
        entryCountCacheTimeout = 1800L;
    }
}

