/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.ldap;

import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.schema.ObjectClassDefinition;
import com.unboundid.ldap.sdk.schema.Schema;

public class SchemaUtils {
    public static String dumpObjectClassDefinition(LDAPConnection ldapCon, String objectClass) {
        Schema schema;
        try {
            schema = ldapCon.getSchema();
        }
        catch (LDAPException e) {
            return e.getMessage();
        }
        if (schema == null) {
            return "LDAP schema not available (check permissions)";
        }
        ObjectClassDefinition objClassDef = schema.getObjectClass(objectClass);
        if (objClassDef == null) {
            return "No such objectClass: " + objectClass;
        }
        return objClassDef.toString();
    }

    private SchemaUtils() {
    }
}

