/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.ldap;

import com.nimbusds.common.config.CustomKeyStoreConfiguration;
import com.nimbusds.common.config.CustomTrustStoreConfiguration;
import com.nimbusds.common.config.LDAPServerDetails;
import com.nimbusds.common.ldap.LDAPConnectionException;
import com.nimbusds.common.ldap.LDAPConnectionFactory;
import com.nimbusds.common.ldap.LDAPServerSetFactory;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.ServerSet;
import javax.net.SocketFactory;

public class PresetLDAPConnectionFactory
extends LDAPConnectionFactory {
    private final LDAPServerDetails ldapServer;
    private final ServerSet ldapServerSet;

    public PresetLDAPConnectionFactory(LDAPServerDetails ldapServer, CustomTrustStoreConfiguration customTrustStore, CustomKeyStoreConfiguration customKeyStore) throws LDAPConnectionException {
        super(customTrustStore, customKeyStore);
        if (ldapServer == null) {
            throw new IllegalArgumentException("The LDAP server details must not be null");
        }
        this.ldapServer = ldapServer;
        SocketFactory socketFactory = PresetLDAPConnectionFactory.getSocketFactory(ldapServer.security, customTrustStore, customKeyStore, ldapServer.trustSelfSignedCerts);
        LDAPConnectionOptions opts = new LDAPConnectionOptions();
        opts.setConnectTimeoutMillis(ldapServer.connectTimeout);
        this.ldapServerSet = LDAPServerSetFactory.create(ldapServer.url, ldapServer.selectionAlgorithm, socketFactory, opts);
    }

    public LDAPServerDetails getLDAPServerDetails() {
        return this.ldapServer;
    }

    public LDAPConnection createLDAPConnection() throws LDAPConnectionException {
        return this.createLDAPConnection(this.ldapServerSet, this.ldapServer.security, this.ldapServer.trustSelfSignedCerts);
    }
}

