/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.jsonrpc2;

import com.nimbusds.common.jsonrpc2.WsDetector;
import com.nimbusds.common.jsonrpc2.WsInfo;
import java.net.URL;
import org.apache.logging.log4j.Logger;

public class LoggingWsDetector
extends WsDetector
implements Runnable {
    private final String expectedWsName;
    private final Logger log;
    private WsInfo wsInfo;

    public LoggingWsDetector(URL url, String expectedWsName, Logger log) {
        super(url);
        if (expectedWsName == null) {
            throw new IllegalArgumentException("The web service name must not be null");
        }
        this.expectedWsName = expectedWsName;
        if (log == null) {
            throw new IllegalArgumentException("The logger must not be null");
        }
        this.log = log;
    }

    public WsInfo getWsInfo() {
        return this.wsInfo;
    }

    @Override
    public void run() {
        WsInfo wsInfo;
        try {
            wsInfo = this.detect();
        }
        catch (Exception e) {
            this.log.warn("Couldn't detect remote {} web service: {}", (Object)this.expectedWsName, (Object)e.getMessage());
            return;
        }
        if (!this.expectedWsName.equalsIgnoreCase(wsInfo.getName())) {
            this.log.warn("Remote web service is not {}, detected {} {}", (Object)this.expectedWsName, (Object)wsInfo.getName(), (Object)wsInfo.getVersion());
            return;
        }
        this.log.info("Detected remote web service {} {}", (Object)wsInfo.getName(), (Object)wsInfo.getVersion());
    }
}

