/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.jsonrpc2;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import com.thetransactioncompany.jsonrpc2.client.JSONRPC2Session;
import com.thetransactioncompany.jsonrpc2.client.JSONRPC2SessionException;
import com.thetransactioncompany.jsonrpc2.server.MessageContext;
import com.thetransactioncompany.jsonrpc2.server.RequestHandler;
import java.net.URL;
import java.util.concurrent.atomic.AtomicLong;

public class JSONRPC2ServiceConnector {
    private final RequestHandler jsonrpc2Service;
    private final JSONRPC2Session session;
    private final String apiKey;
    private final AtomicLong reqID = new AtomicLong();

    public JSONRPC2ServiceConnector(RequestHandler jsonrpc2Service, String apiKey) {
        if (jsonrpc2Service == null) {
            throw new IllegalArgumentException("The JSON-RPC 2.0 service request handler must not be null");
        }
        this.jsonrpc2Service = jsonrpc2Service;
        this.session = null;
        this.apiKey = apiKey;
    }

    public JSONRPC2ServiceConnector(URL url, boolean trustSelfSignedCerts, String apiKey, int connectTimeout, int readTimeout) {
        if (url == null) {
            throw new IllegalArgumentException("The JSON-RPC 2.0 service URL must not be null");
        }
        this.session = new JSONRPC2Session(url);
        this.session.getOptions().trustAllCerts(trustSelfSignedCerts);
        this.session.getOptions().setConnectTimeout(connectTimeout);
        this.session.getOptions().setReadTimeout(readTimeout);
        this.jsonrpc2Service = null;
        this.apiKey = apiKey;
    }

    public String getAPIKey() {
        return this.apiKey;
    }

    public long getNextRequestID() {
        return this.reqID.incrementAndGet();
    }

    public boolean isLocal() {
        return this.jsonrpc2Service != null;
    }

    public boolean isRemote() {
        return this.session != null;
    }

    public JSONRPC2Response send(JSONRPC2Request request) throws JSONRPC2SessionException {
        if (this.isLocal()) {
            boolean secure = true;
            MessageContext mctx = new MessageContext("localhost", "127.0.0.1", secure);
            return this.jsonrpc2Service.process(request, mctx);
        }
        return this.session.send(request);
    }
}

