/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.id;

import com.nimbusds.common.id.AuthzId;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.PLAINBindRequest;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import java.text.ParseException;

public class AuthzIdResolver {
    public static AuthzId resolve(SimpleBindRequest bindRequest) {
        DN user;
        if (bindRequest == null) {
            throw new IllegalArgumentException("The bind request must not be null");
        }
        try {
            user = new DN(bindRequest.getBindDN());
        }
        catch (LDAPException e) {
            return null;
        }
        return new AuthzId(user);
    }

    public static AuthzId resolve(PLAINBindRequest bindRequest) {
        if (bindRequest == null) {
            throw new IllegalArgumentException("The bind request must not be null");
        }
        String user = bindRequest.getAuthorizationID() != null ? bindRequest.getAuthorizationID() : bindRequest.getAuthenticationID();
        try {
            return AuthzId.parse(user);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static AuthzId resolve(BindRequest bindRequest) {
        if (bindRequest == null) {
            throw new IllegalArgumentException("The bind request must not be null");
        }
        if (bindRequest instanceof SimpleBindRequest) {
            return AuthzIdResolver.resolve((SimpleBindRequest)bindRequest);
        }
        if (bindRequest instanceof PLAINBindRequest) {
            return AuthzIdResolver.resolve((PLAINBindRequest)bindRequest);
        }
        return null;
    }

    private AuthzIdResolver() {
    }
}

