/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.id;

import com.nimbusds.common.id.IdentifierWithHMAC;
import com.nimbusds.common.id.IdentifierWithHMACGenerator;
import com.nimbusds.common.id.InvalidIdentifierException;
import com.nimbusds.jose.util.Base64URL;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public abstract class AbstractIdentifierWithHMACGenerator<T>
implements IdentifierWithHMACGenerator<T> {
    private final SecretKey hmacKey;

    public AbstractIdentifierWithHMACGenerator(SecretKey hmacKey) {
        if (hmacKey.getEncoded().length != 32) {
            throw new IllegalArgumentException("The HMAC key must be 256 bits long");
        }
        this.hmacKey = new SecretKeySpec(hmacKey.getEncoded(), "HmacSha256");
    }

    public SecretKey getHMACKey() {
        return this.hmacKey;
    }

    @Override
    public Base64URL validateAndExtractValue(T identifier) throws InvalidIdentifierException {
        IdentifierWithHMAC id = IdentifierWithHMAC.parseAndValidate(identifier.toString(), this.getHMACKey());
        return new Base64URL(id.toString().split("\\.")[0]);
    }

    @Override
    public Base64URL extractValue(T identifier) {
        return new Base64URL(identifier.toString().split("\\.")[0]);
    }
}

