/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.ldap;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.util.NamedParamsRetriever;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.controls.ServerSideSortRequestControl;
import com.unboundid.ldap.sdk.controls.SimplePagedResultsControl;
import com.unboundid.ldap.sdk.controls.SortKey;
import com.unboundid.ldap.sdk.controls.VirtualListViewRequestControl;
import com.unboundid.util.Base64;
import java.text.ParseException;
import java.util.List;
import java.util.Map;

public class LDAPControlRequestParser {
    public static ServerSideSortRequestControl parseServerSideSortRequestControl(List<Object> sortParams) throws JSONRPC2Error {
        if (sortParams == null || sortParams.isEmpty()) {
            return null;
        }
        SortKey[] sortKeys = new SortKey[sortParams.size()];
        for (int i = 0; i < sortParams.size(); ++i) {
            Map entry;
            try {
                entry = (Map)sortParams.get(i);
            }
            catch (Exception e) {
                throw JSONRPC2Error.INVALID_PARAMS.appendMessage(": Invalid server-side sort control specification");
            }
            NamedParamsRetriever np = new NamedParamsRetriever(entry);
            String key = np.getString("key");
            boolean reverseOrder = np.getOptBoolean("reverseOrder", false);
            String orderingRule = np.getOptString("orderingRule", true, null);
            sortKeys[i] = new SortKey(key, orderingRule, reverseOrder);
        }
        boolean isCritical = true;
        return new ServerSideSortRequestControl(isCritical, sortKeys);
    }

    public static SimplePagedResultsControl parseSimplePagedResultsControl(Map<String, Object> pageParams) throws JSONRPC2Error {
        if (pageParams == null) {
            return null;
        }
        NamedParamsRetriever np = new NamedParamsRetriever(pageParams);
        int size = np.getInt("size");
        if (size < 1) {
            throw JSONRPC2Error.INVALID_PARAMS.appendMessage(": Invalid simple paged results control specification: Size must be positive");
        }
        ASN1OctetString cookie = null;
        String cookieBase64 = np.getOptString("cookie", true, null);
        try {
            if (cookieBase64 != null) {
                cookie = new ASN1OctetString(Base64.decode((String)cookieBase64));
            }
        }
        catch (ParseException e) {
            throw JSONRPC2Error.INVALID_PARAMS.appendMessage(": Invalid simple paged results control specification: Unexpected cookie format");
        }
        boolean isCritical = true;
        return new SimplePagedResultsControl(size, cookie, isCritical);
    }

    public static VirtualListViewRequestControl parseVirtualListViewControl(Map<String, Object> vlvParams) throws JSONRPC2Error {
        if (vlvParams == null) {
            return null;
        }
        NamedParamsRetriever np = new NamedParamsRetriever(vlvParams);
        int offset = np.getOptInt("offset", 1);
        if (offset < 1) {
            throw JSONRPC2Error.INVALID_PARAMS.appendMessage(": Invalid virtual list view control specification: Offset must be positive (1 based)");
        }
        int before = np.getOptInt("before", 0);
        if (before < 0) {
            throw JSONRPC2Error.INVALID_PARAMS.appendMessage(": Invalid virtual list view control specification: Before count must zero or positive");
        }
        int after = np.getInt("after");
        if (after < 0) {
            throw JSONRPC2Error.INVALID_PARAMS.appendMessage(": Invalid virtual list view control specification: After count must zero or positive");
        }
        int totalEntryCount = np.getOptInt("totalEntryCount", 0);
        if (totalEntryCount < 0) {
            throw JSONRPC2Error.INVALID_PARAMS.appendMessage(": Invalid virtual list view control specification: Total entry count estimate must zero or positive");
        }
        ASN1OctetString cookie = null;
        String cookieBase64 = np.getOptString("cookie", true, null);
        try {
            if (cookieBase64 != null) {
                cookie = new ASN1OctetString(Base64.decode((String)cookieBase64));
            }
        }
        catch (ParseException e) {
            throw JSONRPC2Error.INVALID_PARAMS.appendMessage(": Invalid virtual list view control specification: Unexpected cookie format");
        }
        boolean isCritical = true;
        return new VirtualListViewRequestControl(offset, before, after, totalEntryCount, cookie, isCritical);
    }

    private LDAPControlRequestParser() {
    }
}

