/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.id;

import com.nimbusds.common.id.BaseIdentifier;
import com.nimbusds.common.id.InvalidIdentifierException;
import com.nimbusds.jose.util.Base64URL;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.ArrayUtils;

public class IdentifierWithHMAC
extends BaseIdentifier {
    public static final int DEFAULT_BYTE_LENGTH = 16;

    private static byte[] computeHMAC(byte[] message, SecretKey hmacKey) {
        Mac hmacComputer;
        if (hmacKey.getEncoded().length < 32) {
            throw new IllegalArgumentException("The HMAC key must be at least 256 bits long");
        }
        try {
            hmacComputer = Mac.getInstance("HmacSHA256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        SecretKeySpec secret_key = new SecretKeySpec(hmacKey.getEncoded(), "HmacSHA256");
        try {
            hmacComputer.init(secret_key);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        byte[] hmac256bit = hmacComputer.doFinal(message);
        return ArrayUtils.subarray((byte[])hmac256bit, (int)0, (int)16);
    }

    private static String generate(SecretKey hmacKey) {
        byte[] n = new byte[16];
        SECURE_RANDOM.nextBytes(n);
        byte[] hmac = IdentifierWithHMAC.computeHMAC(n, hmacKey);
        return Base64URL.encode((byte[])n) + "." + Base64URL.encode((byte[])hmac);
    }

    public IdentifierWithHMAC(byte[] value, SecretKey hmacKey) {
        super(Base64URL.encode((byte[])value) + "." + Base64URL.encode((byte[])IdentifierWithHMAC.computeHMAC(value, hmacKey)));
    }

    public IdentifierWithHMAC(SecretKey hmacKey) {
        super(IdentifierWithHMAC.generate(hmacKey));
    }

    private IdentifierWithHMAC(String value) {
        super(value);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof IdentifierWithHMAC && this.toString().equals(object.toString());
    }

    public static IdentifierWithHMAC parseAndValidate(String value, SecretKey hmacKey) throws InvalidIdentifierException {
        String[] parts = value.split("\\.");
        if (parts.length != 2) {
            throw new InvalidIdentifierException("Illegal identifier with HMAC format");
        }
        if (parts[0].trim().isEmpty()) {
            throw new InvalidIdentifierException("Missing identifier value");
        }
        if (parts[1].trim().isEmpty()) {
            throw new InvalidIdentifierException("Missing HMAC for the identifier value");
        }
        byte[] n = new Base64URL(parts[0]).decode();
        if (n.length == 0) {
            throw new InvalidIdentifierException("Illegal identifier value");
        }
        byte[] hmac = new Base64URL(parts[1]).decode();
        if (hmac.length == 0) {
            throw new InvalidIdentifierException("Illegal HMAC value");
        }
        byte[] expectedHMAC = IdentifierWithHMAC.computeHMAC(n, hmacKey);
        if (!MessageDigest.isEqual(expectedHMAC, hmac)) {
            throw new InvalidIdentifierException("Invalid HMAC");
        }
        return new IdentifierWithHMAC(value);
    }
}

