/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.webcontainer.service;

import java.io.IOException;
import java.security.AccessControlException;
import nextapp.echo.webcontainer.Connection;
import nextapp.echo.webcontainer.Service;
import nextapp.echo.webcontainer.util.GZipCompressor;
import nextapp.echo.webcontainer.util.JavaScriptCompressor;
import nextapp.echo.webcontainer.util.Resource;

public class JavaScriptService
implements Service {
    private static boolean allowIEcompression = false;
    private String id;
    private String content;
    private byte[] gzipContent;

    public static JavaScriptService forResource(String id, String resourceName) {
        String content = Resource.getResourceAsString(resourceName);
        return new JavaScriptService(id, content);
    }

    public static JavaScriptService forResources(String id, String[] resourceNames) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < resourceNames.length; ++i) {
            out.append(Resource.getResourceAsString(resourceNames[i]));
            out.append("\n\n");
        }
        return new JavaScriptService(id, out.toString());
    }

    public JavaScriptService(String id, String content) {
        this.id = id;
        this.content = JavaScriptCompressor.compress(content);
        try {
            this.gzipContent = GZipCompressor.compress(this.content);
        }
        catch (IOException ex) {
            throw new RuntimeException("Exception compressing JavaScript source.", ex);
        }
    }

    public String getId() {
        return this.id;
    }

    public int getVersion() {
        return -1;
    }

    public void service(Connection conn) throws IOException {
        String userAgent = conn.getRequest().getHeader("user-agent");
        if (!(allowIEcompression || userAgent != null && userAgent.indexOf("MSIE") == -1)) {
            this.servicePlain(conn);
        } else {
            String acceptEncoding = conn.getRequest().getHeader("accept-encoding");
            if (acceptEncoding != null && acceptEncoding.indexOf("gzip") != -1) {
                this.serviceGZipCompressed(conn);
            } else {
                this.servicePlain(conn);
            }
        }
    }

    private void serviceGZipCompressed(Connection conn) throws IOException {
        conn.getResponse().setContentType("text/plain");
        conn.getResponse().setHeader("Content-Encoding", "gzip");
        conn.getOutputStream().write(this.gzipContent);
    }

    private void servicePlain(Connection conn) throws IOException {
        conn.getResponse().setContentType("text/plain");
        conn.getWriter().print(this.content);
    }

    static {
        try {
            if ("true".equals(System.getProperty("echo.allowiecompression"))) {
                allowIEcompression = true;
            }
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }
}

