/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.webcontainer;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import nextapp.echo.app.util.Context;
import nextapp.echo.app.util.DomUtil;
import nextapp.echo.webcontainer.SynchronizationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ClientMessage {
    public static final String TYPE_INITIALIZE = "init";
    private static final Map processorNameToClass = new HashMap();
    private Document document;
    private String type;
    private String windowId;
    private int transactionId;
    private String initId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(String name, Class processorClass) {
        Map map = processorNameToClass;
        synchronized (map) {
            if (processorNameToClass.containsKey(name)) {
                throw new IllegalStateException("A ClientMessage Processor has already been registered for the directive \"" + name + "\"");
            }
            processorNameToClass.put(name, processorClass);
        }
    }

    public ClientMessage(Document document) throws IOException {
        this.document = document;
        Element cmsg = document.getDocumentElement();
        this.type = cmsg.getAttribute("t");
        this.initId = cmsg.hasAttribute("ii") ? cmsg.getAttribute("ii") : null;
        this.transactionId = Integer.parseInt(cmsg.getAttribute("i"));
        this.windowId = cmsg.hasAttribute("w") ? cmsg.getAttribute("w") : null;
    }

    public Document getDocument() {
        return this.document;
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public String getInitId() {
        return this.initId;
    }

    public String getWindowId() {
        return this.windowId;
    }

    public String getType() {
        return this.type;
    }

    public void process(Context context) throws IOException {
        Element[] dirElements = DomUtil.getChildElementsByTagName((Element)this.document.getDocumentElement(), (String)"dir");
        for (int i = 0; i < dirElements.length; ++i) {
            String processorName = dirElements[i].getAttribute("proc");
            Class processorClass = (Class)processorNameToClass.get(processorName);
            if (processorClass == null) {
                throw new SynchronizationException("No processor exists for processor name: " + processorName, null);
            }
            try {
                Processor processor = (Processor)processorClass.newInstance();
                processor.process(context, dirElements[i]);
                continue;
            }
            catch (InstantiationException ex) {
                throw new SynchronizationException("Cannot instantiate process class: " + processorClass.getName(), ex);
            }
            catch (IllegalAccessException ex) {
                throw new SynchronizationException("Cannot instantiate process class: " + processorClass.getName(), ex);
            }
        }
    }

    public static interface Processor {
        public void process(Context var1, Element var2) throws IOException;
    }
}

