/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app.reflect;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import nextapp.echo.app.reflect.ObjectIntrospector;

public class ComponentIntrospector
extends ObjectIntrospector {
    private Map styleConstantNames = new HashMap();

    protected ComponentIntrospector(String typeName, ClassLoader classLoader) throws ClassNotFoundException {
        super(typeName, classLoader);
        this.loadStyleConstantData();
    }

    public String getStyleConstantName(String propertyName) {
        return (String)this.styleConstantNames.get(propertyName);
    }

    private void loadStyleConstantData() {
        Field[] fields = this.getObjectClass().getFields();
        for (int index = 0; index < fields.length; ++index) {
            if (fields[index].getType() != String.class || (fields[index].getModifiers() & 0x19) == 0 || !fields[index].getName().startsWith("PROPERTY_")) continue;
            String styleConstant = fields[index].getName();
            try {
                String propertyName = (String)fields[index].get(null);
                this.styleConstantNames.put(propertyName, styleConstant);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }
}

