/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app.button;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import nextapp.echo.app.ApplicationInstance;
import nextapp.echo.app.RadioButton;
import nextapp.echo.app.RenderIdSupport;

public class ButtonGroup
implements RenderIdSupport,
Serializable {
    private static final long serialVersionUID = 20070101L;
    private static final RadioButton[] EMPTY = new RadioButton[0];
    private String id = ApplicationInstance.generateSystemId();
    private Set buttons;

    public void addButton(RadioButton radioButton) {
        if (this.buttons == null) {
            this.buttons = new HashSet();
        }
        this.buttons.add(radioButton);
        this.updateSelection(radioButton);
    }

    public RadioButton[] getButtons() {
        if (this.buttons == null) {
            return EMPTY;
        }
        return this.buttons.toArray(new RadioButton[this.buttons.size()]);
    }

    public String getRenderId() {
        return this.id;
    }

    public void removeButton(RadioButton radioButton) {
        if (this.buttons != null) {
            this.buttons.remove(radioButton);
        }
    }

    public void updateSelection(RadioButton changedButton) {
        if (this.buttons == null || !changedButton.isSelected()) {
            return;
        }
        for (RadioButton button : this.buttons) {
            if (button.equals(changedButton)) continue;
            button.setSelected(false);
        }
    }
}

