/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import nextapp.echo.app.BorderedComponent;
import nextapp.echo.app.Color;
import nextapp.echo.app.Component;
import nextapp.echo.app.Extent;
import nextapp.echo.app.FillImage;
import nextapp.echo.app.Font;
import nextapp.echo.app.IllegalChildException;
import nextapp.echo.app.Insets;
import nextapp.echo.app.Label;
import nextapp.echo.app.event.ActionEvent;
import nextapp.echo.app.event.ActionListener;
import nextapp.echo.app.event.ChangeEvent;
import nextapp.echo.app.event.ChangeListener;
import nextapp.echo.app.event.TableColumnModelEvent;
import nextapp.echo.app.event.TableColumnModelListener;
import nextapp.echo.app.event.TableModelEvent;
import nextapp.echo.app.event.TableModelListener;
import nextapp.echo.app.list.DefaultListSelectionModel;
import nextapp.echo.app.list.ListSelectionModel;
import nextapp.echo.app.table.DefaultTableCellRenderer;
import nextapp.echo.app.table.DefaultTableColumnModel;
import nextapp.echo.app.table.DefaultTableModel;
import nextapp.echo.app.table.TableCellRenderer;
import nextapp.echo.app.table.TableColumn;
import nextapp.echo.app.table.TableColumnModel;
import nextapp.echo.app.table.TableModel;

public class Table
extends BorderedComponent {
    private static final long serialVersionUID = 20070101L;
    public static final TableCellRenderer DEFAULT_TABLE_CELL_RENDERER = new DefaultTableCellRenderer();
    public static final String PROPERTY_ACTION_COMMAND = "actionCommand";
    public static final String PROPERTY_INSETS = "insets";
    public static final String PROPERTY_ROLLOVER_BACKGROUND = "rolloverBackground";
    public static final String PROPERTY_ROLLOVER_BACKGROUND_IMAGE = "rolloverBackgroundImage";
    public static final String PROPERTY_ROLLOVER_ENABLED = "rolloverEnabled";
    public static final String PROPERTY_ROLLOVER_FONT = "rolloverFont";
    public static final String PROPERTY_ROLLOVER_FOREGROUND = "rolloverForeground";
    public static final String PROPERTY_SELECTION_BACKGROUND = "selectionBackground";
    public static final String PROPERTY_SELECTION_BACKGROUND_IMAGE = "selectionBackgroundImage";
    public static final String PROPERTY_SELECTION_ENABLED = "selectionEnabled";
    public static final String PROPERTY_SELECTION_FONT = "selectionFont";
    public static final String PROPERTY_SELECTION_FOREGROUND = "selectionForeground";
    public static final String PROPERTY_WIDTH = "width";
    public static final String INPUT_ACTION = "action";
    public static final String ACTION_LISTENERS_CHANGED_PROPERTY = "actionListeners";
    public static final String AUTO_CREATE_COLUMNS_FROM_MODEL_CHANGED_PROPERTY = "autoCreateColumnsFromModel";
    public static final String COLUMN_MODEL_CHANGED_PROPERTY = "columnModel";
    public static final String DEFAULT_HEADER_RENDERER_CHANGED_PROPERTY = "defaultHeaderRenderer";
    public static final String DEFAULT_RENDERER_CHANGED_PROPERTY = "defaultRenderer";
    public static final String HEADER_VISIBLE_CHANGED_PROPERTY = "headerVisible";
    public static final String MODEL_CHANGED_PROPERTY = "model";
    public static final String SELECTION_CHANGED_PROPERTY = "selection";
    public static final String SELECTION_MODEL_CHANGED_PROPERTY = "selectionModel";
    public static final int HEADER_ROW = -1;
    private boolean autoCreateColumnsFromModel;
    private boolean headerVisible = true;
    private TableModel model;
    private TableColumnModel columnModel;
    private boolean valid;
    private Map defaultRendererMap = new HashMap();
    private TableCellRenderer defaultHeaderRenderer;
    private ListSelectionModel selectionModel;
    private boolean suppressChangeNotifications;
    private boolean rendering = false;
    private TableModelListener modelListener = new TableModelListener(){
        private static final long serialVersionUID = 20070101L;

        public void tableChanged(TableModelEvent e) {
            Table.this.invalidate();
            if ((e == null || e.getType() == 4) && Table.this.isAutoCreateColumnsFromModel()) {
                Table.this.createDefaultColumnsFromModel();
            }
        }
    };
    private TableColumnModelListener columnModelListener = new TableColumnModelListener(){
        private static final long serialVersionUID = 20070101L;

        public void columnAdded(TableColumnModelEvent e) {
            Table.this.invalidate();
        }

        public void columnMoved(TableColumnModelEvent e) {
            Table.this.invalidate();
        }

        public void columnRemoved(TableColumnModelEvent e) {
            Table.this.invalidate();
        }
    };
    private ChangeListener changeHandler = new ChangeListener(){
        private static final long serialVersionUID = 20070101L;

        public void stateChanged(ChangeEvent e) {
            if (!Table.this.suppressChangeNotifications) {
                Table.this.firePropertyChange(Table.SELECTION_CHANGED_PROPERTY, null, null);
            }
        }
    };

    public Table() {
        this(new DefaultTableModel());
    }

    public Table(int columns, int rows) {
        this(new DefaultTableModel(columns, rows));
    }

    public Table(TableModel model) {
        this(model, null);
    }

    public Table(TableModel model, TableColumnModel columnModel) {
        if (columnModel == null) {
            this.setColumnModel(new DefaultTableColumnModel());
            this.setAutoCreateColumnsFromModel(true);
        } else {
            this.setColumnModel(columnModel);
        }
        this.setSelectionModel(new DefaultListSelectionModel());
        this.setModel(model);
        this.addPropertyChangeListener("childVisible", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                Table.this.invalidate();
            }
        });
    }

    public String getActionCommand() {
        return (String)this.get(PROPERTY_ACTION_COMMAND);
    }

    public void add(Component c, int n) throws IllegalChildException {
        if (!this.rendering) {
            throw new IllegalStateException("Programmatic addition or removal of Table children is prohibited.");
        }
        super.add(c, n);
    }

    public void addActionListener(ActionListener l) {
        this.getEventListenerList().addListener(ActionListener.class, l);
        this.firePropertyChange(ACTION_LISTENERS_CHANGED_PROPERTY, null, l);
    }

    public void createDefaultColumnsFromModel() {
        if (this.model != null) {
            while (this.columnModel.getColumnCount() > 0) {
                this.columnModel.removeColumn(this.columnModel.getColumn(0));
            }
            int columnCount = this.model.getColumnCount();
            for (int index = 0; index < columnCount; ++index) {
                this.columnModel.addColumn(new TableColumn(index));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRender() {
        Component renderedComponent;
        int columnIndex;
        try {
            this.rendering = true;
            this.removeAll();
        }
        finally {
            this.rendering = false;
        }
        int rowCount = this.model.getRowCount();
        int columnCount = this.columnModel.getColumnCount();
        TableColumn[] tableColumns = new TableColumn[columnCount];
        TableCellRenderer[] columnRenderers = new TableCellRenderer[columnCount];
        for (columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
            Class columnClass;
            tableColumns[columnIndex] = this.columnModel.getColumn(columnIndex);
            TableCellRenderer renderer = tableColumns[columnIndex].getCellRenderer();
            if (renderer == null && (renderer = this.getDefaultRenderer(columnClass = this.model.getColumnClass(tableColumns[columnIndex].getModelIndex()))) == null) {
                renderer = DEFAULT_TABLE_CELL_RENDERER;
            }
            columnRenderers[columnIndex] = renderer;
        }
        if (this.isHeaderVisible()) {
            for (columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                TableCellRenderer headerRenderer;
                int modelColumnIndex = tableColumns[columnIndex].getModelIndex();
                Object headerValue = tableColumns[columnIndex].getHeaderValue();
                if (headerValue == null) {
                    headerValue = this.model.getColumnName(modelColumnIndex);
                }
                if ((headerRenderer = tableColumns[columnIndex].getHeaderRenderer()) == null && (headerRenderer = this.defaultHeaderRenderer) == null) {
                    headerRenderer = DEFAULT_TABLE_CELL_RENDERER;
                }
                if ((renderedComponent = headerRenderer.getTableCellRendererComponent(this, headerValue, modelColumnIndex, -1)) == null || !renderedComponent.isVisible()) {
                    renderedComponent = new Label();
                }
                try {
                    this.rendering = true;
                    this.add(renderedComponent);
                    continue;
                }
                finally {
                    this.rendering = false;
                }
            }
        }
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            for (int columnIndex2 = 0; columnIndex2 < columnCount; ++columnIndex2) {
                int modelColumnIndex = tableColumns[columnIndex2].getModelIndex();
                Object modelValue = this.model.getValueAt(modelColumnIndex, rowIndex);
                renderedComponent = columnRenderers[columnIndex2].getTableCellRendererComponent(this, modelValue, modelColumnIndex, rowIndex);
                if (renderedComponent == null || !renderedComponent.isVisible()) {
                    renderedComponent = new Label();
                }
                try {
                    this.rendering = true;
                    this.add(renderedComponent);
                    continue;
                }
                finally {
                    this.rendering = false;
                }
            }
        }
    }

    private void fireActionEvent() {
        if (!this.hasEventListenerList()) {
            return;
        }
        EventListener[] listeners = this.getEventListenerList().getListeners(ActionListener.class);
        ActionEvent e = null;
        for (int i = 0; i < listeners.length; ++i) {
            if (e == null) {
                e = new ActionEvent(this, (String)this.getRenderProperty(PROPERTY_ACTION_COMMAND));
            }
            ((ActionListener)listeners[i]).actionPerformed(e);
        }
    }

    public TableColumnModel getColumnModel() {
        return this.columnModel;
    }

    public TableCellRenderer getDefaultHeaderRenderer() {
        return this.defaultHeaderRenderer;
    }

    public TableCellRenderer getDefaultRenderer(Class columnClass) {
        return (TableCellRenderer)this.defaultRendererMap.get(columnClass);
    }

    public Insets getInsets() {
        return (Insets)this.get(PROPERTY_INSETS);
    }

    public TableModel getModel() {
        return this.model;
    }

    public Color getRolloverBackground() {
        return (Color)this.get(PROPERTY_ROLLOVER_BACKGROUND);
    }

    public FillImage getRolloverBackgroundImage() {
        return (FillImage)this.get(PROPERTY_ROLLOVER_BACKGROUND_IMAGE);
    }

    public Font getRolloverFont() {
        return (Font)this.get(PROPERTY_ROLLOVER_FONT);
    }

    public Color getRolloverForeground() {
        return (Color)this.get(PROPERTY_ROLLOVER_FOREGROUND);
    }

    public Color getSelectionBackground() {
        return (Color)this.get(PROPERTY_SELECTION_BACKGROUND);
    }

    public FillImage getSelectionBackgroundImage() {
        return (FillImage)this.get(PROPERTY_SELECTION_BACKGROUND_IMAGE);
    }

    public Font getSelectionFont() {
        return (Font)this.get(PROPERTY_SELECTION_FONT);
    }

    public Color getSelectionForeground() {
        return (Color)this.get(PROPERTY_SELECTION_FOREGROUND);
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public Extent getWidth() {
        return (Extent)this.get(PROPERTY_WIDTH);
    }

    public boolean hasActionListeners() {
        return this.getEventListenerList().getListenerCount(ActionListener.class) != 0;
    }

    protected void invalidate() {
        this.valid = false;
    }

    public boolean isAutoCreateColumnsFromModel() {
        return this.autoCreateColumnsFromModel;
    }

    public boolean isHeaderVisible() {
        return this.headerVisible;
    }

    public boolean isRolloverEnabled() {
        Boolean value = (Boolean)this.get(PROPERTY_ROLLOVER_ENABLED);
        return value == null ? false : value;
    }

    public boolean isSelectionEnabled() {
        Boolean value = (Boolean)this.get(PROPERTY_SELECTION_ENABLED);
        return value == null ? false : value;
    }

    public void processInput(String inputName, Object inputValue) {
        super.processInput(inputName, inputValue);
        if (inputName.equals(SELECTION_CHANGED_PROPERTY)) {
            this.setSelectedIndices((int[])inputValue);
        } else if (INPUT_ACTION.equals(inputName)) {
            this.fireActionEvent();
        }
    }

    public void remove(Component c) {
        if (!this.rendering) {
            throw new IllegalStateException("Programmatic addition or removal of Table children is prohibited.");
        }
        super.remove(c);
    }

    public void removeActionListener(ActionListener l) {
        if (!this.hasEventListenerList()) {
            return;
        }
        this.getEventListenerList().removeListener(ActionListener.class, l);
        this.firePropertyChange(ACTION_LISTENERS_CHANGED_PROPERTY, l, null);
    }

    public void setActionCommand(String newValue) {
        this.set(PROPERTY_ACTION_COMMAND, newValue);
    }

    public void setAutoCreateColumnsFromModel(boolean newValue) {
        boolean oldValue = this.autoCreateColumnsFromModel;
        this.autoCreateColumnsFromModel = newValue;
        if (!oldValue && newValue) {
            this.createDefaultColumnsFromModel();
        }
        this.firePropertyChange(AUTO_CREATE_COLUMNS_FROM_MODEL_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setColumnModel(TableColumnModel newValue) {
        this.invalidate();
        if (newValue == null) {
            throw new IllegalArgumentException("The model may not be null.");
        }
        TableColumnModel oldValue = this.columnModel;
        if (oldValue != null) {
            oldValue.removeColumnModelListener(this.columnModelListener);
        }
        this.columnModel = newValue;
        newValue.addColumnModelListener(this.columnModelListener);
        this.firePropertyChange(COLUMN_MODEL_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setDefaultHeaderRenderer(TableCellRenderer newValue) {
        this.invalidate();
        TableCellRenderer oldValue = this.defaultHeaderRenderer;
        this.defaultHeaderRenderer = newValue;
        this.firePropertyChange(DEFAULT_HEADER_RENDERER_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setDefaultRenderer(Class columnClass, TableCellRenderer newValue) {
        this.invalidate();
        if (newValue == null) {
            this.defaultRendererMap.remove(columnClass);
        } else {
            this.defaultRendererMap.put(columnClass, newValue);
        }
        this.firePropertyChange(DEFAULT_RENDERER_CHANGED_PROPERTY, null, null);
    }

    public void setHeaderVisible(boolean newValue) {
        this.invalidate();
        boolean oldValue = this.headerVisible;
        this.headerVisible = newValue;
        this.firePropertyChange(HEADER_VISIBLE_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setInsets(Insets newValue) {
        this.set(PROPERTY_INSETS, newValue);
    }

    public void setModel(TableModel newValue) {
        this.invalidate();
        if (newValue == null) {
            throw new IllegalArgumentException("The model may not be null.");
        }
        TableModel oldValue = this.model;
        if (oldValue != null) {
            oldValue.removeTableModelListener(this.modelListener);
        }
        this.model = newValue;
        newValue.addTableModelListener(this.modelListener);
        if (this.isAutoCreateColumnsFromModel()) {
            this.createDefaultColumnsFromModel();
        }
        this.firePropertyChange(MODEL_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setRolloverBackground(Color newValue) {
        this.set(PROPERTY_ROLLOVER_BACKGROUND, newValue);
    }

    public void setRolloverBackgroundImage(FillImage newValue) {
        this.set(PROPERTY_ROLLOVER_BACKGROUND_IMAGE, newValue);
    }

    public void setRolloverEnabled(boolean newValue) {
        this.set(PROPERTY_ROLLOVER_ENABLED, new Boolean(newValue));
    }

    public void setRolloverFont(Font newValue) {
        this.set(PROPERTY_ROLLOVER_FONT, newValue);
    }

    public void setRolloverForeground(Color newValue) {
        this.set(PROPERTY_ROLLOVER_FOREGROUND, newValue);
    }

    private void setSelectedIndices(int[] selectedIndices) {
        this.suppressChangeNotifications = true;
        ListSelectionModel selectionModel = this.getSelectionModel();
        selectionModel.clearSelection();
        for (int i = 0; i < selectedIndices.length; ++i) {
            selectionModel.setSelectedIndex(selectedIndices[i], true);
        }
        this.suppressChangeNotifications = false;
        this.firePropertyChange(SELECTION_CHANGED_PROPERTY, null, selectedIndices);
    }

    public void setSelectionBackground(Color newValue) {
        this.set(PROPERTY_SELECTION_BACKGROUND, newValue);
    }

    public void setSelectionBackgroundImage(FillImage newValue) {
        this.set(PROPERTY_SELECTION_BACKGROUND_IMAGE, newValue);
    }

    public void setSelectionEnabled(boolean newValue) {
        this.set(PROPERTY_SELECTION_ENABLED, newValue);
    }

    public void setSelectionForeground(Color newValue) {
        this.set(PROPERTY_SELECTION_FOREGROUND, newValue);
    }

    public void setSelectionFont(Font newValue) {
        this.set(PROPERTY_SELECTION_FONT, newValue);
    }

    public void setSelectionModel(ListSelectionModel newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("Selection model may not be null.");
        }
        ListSelectionModel oldValue = this.selectionModel;
        if (oldValue != null) {
            oldValue.removeChangeListener(this.changeHandler);
        }
        newValue.addChangeListener(this.changeHandler);
        this.selectionModel = newValue;
        this.firePropertyChange(SELECTION_MODEL_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setWidth(Extent newValue) {
        this.set(PROPERTY_WIDTH, newValue);
    }

    public void validate() {
        super.validate();
        while (!this.valid) {
            this.valid = true;
            this.doRender();
        }
    }
}

