/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import nextapp.echo.app.Style;
import nextapp.echo.app.StyleSheet;

public class MutableStyleSheet
implements StyleSheet {
    private static final long serialVersionUID = 20070101L;
    private Map namedStyleMap = new HashMap();
    private Map defaultStyleMap = new HashMap();

    public void addStyle(Class componentClass, String styleName, Style style) {
        if (styleName == null) {
            this.defaultStyleMap.put(componentClass, style);
        } else {
            HashMap<Class, Style> styleMap = (HashMap<Class, Style>)this.namedStyleMap.get(styleName);
            if (styleMap == null) {
                styleMap = new HashMap<Class, Style>();
                this.namedStyleMap.put(styleName, styleMap);
            }
            styleMap.put(componentClass, style);
        }
    }

    public void addStyleSheet(MutableStyleSheet styleSheet) {
        this.namedStyleMap.putAll(styleSheet.namedStyleMap);
        this.defaultStyleMap.putAll(styleSheet.defaultStyleMap);
    }

    public Iterator getComponentTypes(String styleName) {
        if (styleName == null) {
            return Collections.unmodifiableSet(this.defaultStyleMap.keySet()).iterator();
        }
        Map styleMap = (Map)this.namedStyleMap.get(styleName);
        return Collections.unmodifiableSet(styleMap.keySet()).iterator();
    }

    public Style getStyle(String styleName, Class componentClass, boolean searchSuperClasses) {
        if (styleName == null) {
            while (componentClass != Object.class) {
                Style style = (Style)this.defaultStyleMap.get(componentClass);
                if (!searchSuperClasses || style != null) {
                    return style;
                }
                componentClass = componentClass.getSuperclass();
            }
            return null;
        }
        Map styleMap = (Map)this.namedStyleMap.get(styleName);
        if (styleMap == null) {
            return null;
        }
        while (componentClass != Object.class) {
            Style style = (Style)styleMap.get(componentClass);
            if (!searchSuperClasses || style != null) {
                return style;
            }
            componentClass = componentClass.getSuperclass();
        }
        return null;
    }

    public Iterator getStyleNames() {
        return new Iterator(){
            boolean returnDefault;
            Iterator namedStyleIterator;
            {
                this.returnDefault = MutableStyleSheet.this.defaultStyleMap.size() > 0;
                this.namedStyleIterator = MutableStyleSheet.this.namedStyleMap.keySet().iterator();
            }

            public boolean hasNext() {
                if (this.returnDefault) {
                    return true;
                }
                return this.namedStyleIterator.hasNext();
            }

            public Object next() {
                if (this.returnDefault) {
                    this.returnDefault = false;
                    return null;
                }
                return this.namedStyleIterator.next();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

