/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app;

import java.io.Serializable;
import nextapp.echo.app.Color;
import nextapp.echo.app.Extent;

public class BoxShadow
implements Serializable {
    private static final long serialVersionUID = 20111221L;
    private final Extent hShadowPos;
    private final Extent vShadowPos;
    private final Extent blurDistance;
    private final Extent spreadSize;
    private final Color color;
    private final BoxStyle style;

    public BoxShadow(Extent hShadow, Extent vShadow, Extent blur, Extent spread, Color color, BoxStyle style) {
        this.hShadowPos = hShadow;
        this.vShadowPos = vShadow;
        this.blurDistance = blur;
        this.spreadSize = spread;
        this.color = color;
        this.style = style;
    }

    public BoxShadow(int hShadowPx, int vShadowPx) {
        this(new Extent(hShadowPx), new Extent(vShadowPx), new Extent(0), new Extent(0), Color.BLACK, BoxStyle.DEFAULT);
    }

    public BoxShadow(int hShadowPx, int vShadowPx, Color color) {
        this(new Extent(hShadowPx), new Extent(vShadowPx), new Extent(0), new Extent(0), color, BoxStyle.DEFAULT);
    }

    public Extent getHorizontalShadowPosition() {
        return this.hShadowPos;
    }

    public Extent getVerticalShadowPosition() {
        return this.vShadowPos;
    }

    public Extent getBlurDistance() {
        return this.blurDistance;
    }

    public Extent getSpreadSize() {
        return this.spreadSize;
    }

    public Color getColor() {
        return this.color;
    }

    public BoxStyle getStyle() {
        return this.style;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BoxShadow other = (BoxShadow)obj;
        if (!(this.hShadowPos == other.hShadowPos || this.hShadowPos != null && this.hShadowPos.equals(other.hShadowPos))) {
            return false;
        }
        if (!(this.vShadowPos == other.vShadowPos || this.vShadowPos != null && this.vShadowPos.equals(other.vShadowPos))) {
            return false;
        }
        if (!(this.blurDistance == other.blurDistance || this.blurDistance != null && this.blurDistance.equals(other.blurDistance))) {
            return false;
        }
        if (!(this.spreadSize == other.spreadSize || this.spreadSize != null && this.spreadSize.equals(other.spreadSize))) {
            return false;
        }
        if (!(this.color == other.color || this.color != null && this.color.equals(other.color))) {
            return false;
        }
        return this.style == other.style;
    }

    public String toString() {
        return this.vShadowPos + " " + this.hShadowPos + " " + this.blurDistance + " " + this.spreadSize + " " + this.color + (this.style == BoxStyle.DEFAULT ? "" : (this.style == BoxStyle.INSET ? "inset" : "outset"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BoxStyle {
        DEFAULT,
        INSET;

    }
}

