/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app.update;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import nextapp.echo.app.Component;
import nextapp.echo.app.update.PropertyUpdate;

public class ServerComponentUpdate
implements Serializable {
    private static final long serialVersionUID = 20070101L;
    private static final Component[] EMPTY_COMPONENT_ARRAY = new Component[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private Set addedChildren;
    private Component parent;
    private Map propertyUpdates;
    private Set removedChildren;
    private Set removedDescendants;
    private Set updatedLayoutDataChildren;

    public ServerComponentUpdate(Component parent) {
        this.parent = parent;
    }

    public void addChild(Component child) {
        if (this.addedChildren == null) {
            this.addedChildren = new HashSet();
        }
        this.addedChildren.add(child);
    }

    public void cancelUpdateProperty(String propertyName) {
        if (this.propertyUpdates == null) {
            return;
        }
        this.propertyUpdates.remove(propertyName);
        if (this.propertyUpdates.size() == 0) {
            this.propertyUpdates = null;
        }
    }

    public void appendRemovedDescendants(ServerComponentUpdate update) {
        if (update.removedDescendants != null) {
            if (this.removedDescendants == null) {
                this.removedDescendants = new HashSet();
            }
            this.removedDescendants.addAll(update.removedDescendants);
        }
        if (update.removedChildren != null) {
            if (this.removedDescendants == null) {
                this.removedDescendants = new HashSet();
            }
            this.removedDescendants.addAll(update.removedChildren);
        }
    }

    public Component[] getAddedChildren() {
        if (this.addedChildren == null) {
            return EMPTY_COMPONENT_ARRAY;
        }
        return this.addedChildren.toArray(new Component[this.addedChildren.size()]);
    }

    public Component getParent() {
        return this.parent;
    }

    public Component[] getRemovedChildren() {
        if (this.removedChildren == null) {
            return EMPTY_COMPONENT_ARRAY;
        }
        return this.removedChildren.toArray(new Component[this.removedChildren.size()]);
    }

    public Component[] getRemovedDescendants() {
        if (this.removedDescendants == null) {
            return EMPTY_COMPONENT_ARRAY;
        }
        return this.removedDescendants.toArray(new Component[this.removedDescendants.size()]);
    }

    public Component[] getUpdatedLayoutDataChildren() {
        if (this.updatedLayoutDataChildren == null) {
            return EMPTY_COMPONENT_ARRAY;
        }
        return this.updatedLayoutDataChildren.toArray(new Component[this.updatedLayoutDataChildren.size()]);
    }

    public PropertyUpdate getUpdatedProperty(String name) {
        return this.propertyUpdates == null ? null : (PropertyUpdate)this.propertyUpdates.get(name);
    }

    public String[] getUpdatedPropertyNames() {
        if (this.propertyUpdates == null) {
            return EMPTY_STRING_ARRAY;
        }
        return this.propertyUpdates.keySet().toArray(new String[this.propertyUpdates.size()]);
    }

    public boolean hasAddedChild(Component component) {
        return this.addedChildren != null && this.addedChildren.contains(component);
    }

    public boolean hasAddedChildren() {
        return this.addedChildren != null;
    }

    public boolean hasRemovedChild(Component component) {
        return this.removedChildren != null && this.removedChildren.contains(component);
    }

    public boolean hasRemovedChildren() {
        return this.removedChildren != null;
    }

    public boolean hasRemovedDescendant(Component component) {
        return this.removedChildren != null && (this.removedChildren.contains(component) || this.removedDescendants != null && this.removedDescendants.contains(component));
    }

    public boolean hasRemovedDescendants() {
        return this.removedDescendants != null;
    }

    public boolean hasUpdatedLayoutDataChildren() {
        return this.updatedLayoutDataChildren != null;
    }

    public boolean hasUpdatedProperties() {
        return this.propertyUpdates != null;
    }

    public boolean hasUpdatedProperty(String propertyName) {
        return this.propertyUpdates != null && this.propertyUpdates.containsKey(propertyName);
    }

    public void removeChild(Component child) {
        if (this.addedChildren != null && this.addedChildren.contains(child)) {
            this.addedChildren.remove(child);
        }
        if (this.updatedLayoutDataChildren != null && this.updatedLayoutDataChildren.contains(child)) {
            this.updatedLayoutDataChildren.remove(child);
        }
        if (this.removedChildren == null) {
            this.removedChildren = new HashSet();
        }
        this.removedChildren.add(child);
        Component[] descendants = child.getComponents();
        for (int i = 0; i < descendants.length; ++i) {
            this.removeDescendant(descendants[i]);
        }
    }

    public void removeDescendant(Component descendant) {
        if (this.removedDescendants == null) {
            this.removedDescendants = new HashSet();
        }
        this.removedDescendants.add(descendant);
        Component[] descendants = descendant.getComponents();
        for (int i = 0; i < descendants.length; ++i) {
            this.removeDescendant(descendants[i]);
        }
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append(ServerComponentUpdate.class.getName() + "\n");
        out.append("- Parent: " + this.getParent() + "\n");
        out.append("- Adds: " + this.addedChildren + "\n");
        out.append("- Removes: " + this.removedChildren + "\n");
        out.append("- DescendantRemoves: " + this.removedDescendants + "\n");
        out.append("- ChildLayoutDataUpdates: " + this.updatedLayoutDataChildren + "\n");
        out.append("- PropertyUpdates: " + this.propertyUpdates + "\n");
        return out.toString();
    }

    public void updateLayoutData(Component child) {
        if (this.updatedLayoutDataChildren == null) {
            this.updatedLayoutDataChildren = new HashSet();
        }
        this.updatedLayoutDataChildren.add(child);
    }

    public void updateProperty(String propertyName, Object oldValue, Object newValue) {
        if (this.propertyUpdates == null) {
            this.propertyUpdates = new HashMap();
        }
        PropertyUpdate propertyUpdate = new PropertyUpdate(oldValue, newValue);
        this.propertyUpdates.put(propertyName, propertyUpdate);
    }
}

