/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app.serial.property;

import nextapp.echo.app.Color;
import nextapp.echo.app.FillImage;
import nextapp.echo.app.FillImageBorder;
import nextapp.echo.app.Insets;
import nextapp.echo.app.serial.PropertyPeerFactory;
import nextapp.echo.app.serial.SerialContext;
import nextapp.echo.app.serial.SerialException;
import nextapp.echo.app.serial.SerialPropertyPeer;
import nextapp.echo.app.serial.property.ColorPeer;
import nextapp.echo.app.serial.property.FillImagePeer;
import nextapp.echo.app.serial.property.InsetsPeer;
import nextapp.echo.app.util.Context;
import nextapp.echo.app.util.DomUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FillImageBorderPeer
implements SerialPropertyPeer {
    public Object toProperty(Context context, Class objectClass, Element propertyElement) throws SerialException {
        PropertyPeerFactory propertyPeerFactory = (PropertyPeerFactory)context.get(PropertyPeerFactory.class);
        FillImagePeer fillImagePeer = (FillImagePeer)propertyPeerFactory.getPeerForProperty(FillImage.class);
        Element fibElement = DomUtil.getChildElementByTagName(propertyElement, "fib");
        Color borderColor = fibElement.hasAttribute("bc") ? ColorPeer.fromString(fibElement.getAttribute("bc")) : null;
        Insets borderInsets = fibElement.hasAttribute("bi") ? InsetsPeer.fromString(fibElement.getAttribute("bi")) : null;
        Insets contentInsets = fibElement.hasAttribute("ci") ? InsetsPeer.fromString(fibElement.getAttribute("ci")) : null;
        FillImageBorder border = new FillImageBorder(borderColor, borderInsets, contentInsets);
        int fiCount = 0;
        NodeList fibChildNodes = fibElement.getChildNodes();
        for (int i = 0; i < fibChildNodes.getLength() && fiCount < 8; ++i) {
            Node fiNode = fibChildNodes.item(i);
            if ("fi".equals(fiNode.getNodeName())) {
                border.setFillImage(fiCount, fillImagePeer.fromElement(context, (Element)fiNode));
                ++fiCount;
                continue;
            }
            if (!"null-fi".equals(fiNode.getNodeName())) continue;
            ++fiCount;
        }
        if (fiCount != 8) {
            throw new SerialException("Invalid FillImageBorder image count: " + fiCount, null);
        }
        return border;
    }

    public void toXml(Context context, Class objectClass, Element propertyElement, Object propertyValue) throws SerialException {
        SerialContext serialContext = (SerialContext)context.get(SerialContext.class);
        FillImageBorder border = (FillImageBorder)propertyValue;
        propertyElement.setAttribute("t", (serialContext.getFlags() & 1) == 0 ? "FillImageBorder" : "FIB");
        PropertyPeerFactory propertyPeerFactory = (PropertyPeerFactory)context.get(PropertyPeerFactory.class);
        FillImagePeer fillImagePeer = (FillImagePeer)propertyPeerFactory.getPeerForProperty(FillImage.class);
        Element fibElement = serialContext.getDocument().createElement("fib");
        if (border.getBorderInsets() != null) {
            fibElement.setAttribute("bi", InsetsPeer.toString(border.getBorderInsets()));
        }
        if (border.getContentInsets() != null) {
            fibElement.setAttribute("ci", InsetsPeer.toString(border.getContentInsets()));
        }
        if (border.getColor() != null) {
            fibElement.setAttribute("bc", ColorPeer.toString(border.getColor()));
        }
        if (border.hasFillImages()) {
            for (int i = 0; i < 8; ++i) {
                FillImage fillImage = border.getFillImage(i);
                if (fillImage == null) {
                    fibElement.appendChild(serialContext.getDocument().createElement("null-fi"));
                    continue;
                }
                fibElement.appendChild(fillImagePeer.toElement(context, fillImage));
            }
        }
        propertyElement.appendChild(fibElement);
    }
}

