/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app.serial.property;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import nextapp.echo.app.serial.SerialContext;
import nextapp.echo.app.serial.SerialException;
import nextapp.echo.app.serial.SerialPropertyPeer;
import nextapp.echo.app.util.Context;
import nextapp.echo.app.util.DomUtil;
import org.w3c.dom.Element;

public class DatePeer
implements SerialPropertyPeer {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy.MM.dd");

    public Object toProperty(Context context, Class objectClass, Element propertyElement) throws SerialException {
        String text = DomUtil.getElementText(propertyElement);
        try {
            return DATE_FORMAT.parse(text);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public void toXml(Context context, Class objectClass, Element propertyElement, Object propertyValue) throws SerialException {
        SerialContext serialContext = (SerialContext)context.get(SerialContext.class);
        propertyElement.setAttribute("t", "d");
        Date date = (Date)propertyValue;
        propertyElement.appendChild(serialContext.getDocument().createTextNode(DATE_FORMAT.format(date)));
    }
}

