/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app;

import nextapp.echo.app.Alignment;
import nextapp.echo.app.Component;
import nextapp.echo.app.Extent;
import nextapp.echo.app.ImageReference;

public class Label
extends Component {
    private static final long serialVersionUID = 20070101L;
    public static final String PROPERTY_FORMAT_WHITESPACE = "formatWhitespace";
    public static final String PROPERTY_ICON = "icon";
    public static final String PROPERTY_ICON_TEXT_MARGIN = "iconTextMargin";
    public static final String PROPERTY_LINE_WRAP = "lineWrap";
    public static final String PROPERTY_TEXT = "text";
    public static final String PROPERTY_TEXT_ALIGNMENT = "textAlignment";
    public static final String PROPERTY_TEXT_POSITION = "textPosition";
    public static final String PROPERTY_TOOL_TIP_TEXT = "toolTipText";

    public Label() {
        this(null, null);
    }

    public Label(String text) {
        this(text, null);
    }

    public Label(ImageReference icon) {
        this(null, icon);
    }

    public Label(String text, ImageReference icon) {
        this.setIcon(icon);
        this.setText(text);
    }

    public ImageReference getIcon() {
        return (ImageReference)this.get(PROPERTY_ICON);
    }

    public Extent getIconTextMargin() {
        return (Extent)this.get(PROPERTY_ICON_TEXT_MARGIN);
    }

    public String getText() {
        return (String)this.get(PROPERTY_TEXT);
    }

    public Alignment getTextAlignment() {
        return (Alignment)this.get(PROPERTY_TEXT_ALIGNMENT);
    }

    public Alignment getTextPosition() {
        return (Alignment)this.get(PROPERTY_TEXT_POSITION);
    }

    public String getToolTipText() {
        return (String)this.get(PROPERTY_TOOL_TIP_TEXT);
    }

    public boolean isFormatWhitespace() {
        Boolean value = (Boolean)this.get(PROPERTY_FORMAT_WHITESPACE);
        return value == null ? false : value;
    }

    public boolean isLineWrap() {
        Boolean value = (Boolean)this.get(PROPERTY_LINE_WRAP);
        return value == null ? true : value;
    }

    public boolean isValidChild(Component component) {
        return false;
    }

    public void setFormatWhitespace(boolean newValue) {
        this.set(PROPERTY_FORMAT_WHITESPACE, newValue ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setIcon(ImageReference newValue) {
        this.set(PROPERTY_ICON, newValue);
    }

    public void setIconTextMargin(Extent newValue) {
        this.set(PROPERTY_ICON_TEXT_MARGIN, newValue);
    }

    public void setLineWrap(boolean newValue) {
        this.set(PROPERTY_LINE_WRAP, new Boolean(newValue));
    }

    public void setText(String newValue) {
        this.set(PROPERTY_TEXT, newValue);
    }

    public void setTextAlignment(Alignment newValue) {
        this.set(PROPERTY_TEXT_ALIGNMENT, newValue);
    }

    public void setTextPosition(Alignment newValue) {
        this.set(PROPERTY_TEXT_POSITION, newValue);
    }

    public void setToolTipText(String newValue) {
        this.set(PROPERTY_TOOL_TIP_TEXT, newValue);
    }
}

