/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app.serial.property;

import nextapp.echo.app.Extent;
import nextapp.echo.app.Font;
import nextapp.echo.app.serial.SerialContext;
import nextapp.echo.app.serial.SerialException;
import nextapp.echo.app.serial.SerialPropertyPeer;
import nextapp.echo.app.serial.property.ExtentPeer;
import nextapp.echo.app.util.Context;
import nextapp.echo.app.util.DomUtil;
import org.w3c.dom.Element;

public class FontPeer
implements SerialPropertyPeer {
    private static final boolean isTrue(String value) {
        return "true".equals(value) || "1".equals(value);
    }

    public Object toProperty(Context context, Class objectClass, Element propertyElement) throws SerialException {
        Element fElement = DomUtil.getChildElementByTagName(propertyElement, "f");
        int style = 0;
        style |= FontPeer.isTrue(fElement.getAttribute("bo")) ? 1 : 0;
        style |= FontPeer.isTrue(fElement.getAttribute("it")) ? 2 : 0;
        style |= FontPeer.isTrue(fElement.getAttribute("un")) ? 4 : 0;
        style |= FontPeer.isTrue(fElement.getAttribute("ov")) ? 8 : 0;
        style |= FontPeer.isTrue(fElement.getAttribute("lt")) ? 16 : 0;
        Extent size = null;
        if (fElement.hasAttribute("sz")) {
            size = ExtentPeer.fromString(fElement.getAttribute("sz"));
        }
        Element[] tfElements = DomUtil.getChildElementsByTagName(fElement, "tf");
        Font.Typeface typeface = null;
        for (int i = tfElements.length - 1; i >= 0; --i) {
            String name = tfElements[i].hasAttribute("n") ? tfElements[i].getAttribute("n") : DomUtil.getElementText(tfElements[i]).trim();
            typeface = typeface == null ? new Font.Typeface(name) : new Font.Typeface(name, typeface);
        }
        return new Font(typeface, style, size);
    }

    public void toXml(Context context, Class objectClass, Element propertyElement, Object propertyValue) throws SerialException {
        SerialContext serialContext = (SerialContext)context.get(SerialContext.class);
        propertyElement.setAttribute("t", (serialContext.getFlags() & 1) == 0 ? "Font" : "F");
        Font font = (Font)propertyValue;
        Element element = serialContext.getDocument().createElement("f");
        for (Font.Typeface typeface = font.getTypeface(); typeface != null; typeface = typeface.getAlternate()) {
            Element tfElement = serialContext.getDocument().createElement("tf");
            tfElement.appendChild(serialContext.getDocument().createTextNode(typeface.getName()));
            element.appendChild(tfElement);
        }
        Extent size = font.getSize();
        if (size != null) {
            element.setAttribute("sz", ExtentPeer.toString(size));
        }
        if (!font.isPlain()) {
            if (font.isBold()) {
                element.setAttribute("bo", "1");
            }
            if (font.isItalic()) {
                element.setAttribute("it", "1");
            }
            if (font.isUnderline()) {
                element.setAttribute("un", "1");
            }
            if (font.isOverline()) {
                element.setAttribute("ov", "1");
            }
            if (font.isLineThrough()) {
                element.setAttribute("lt", "1");
            }
        }
        propertyElement.appendChild(element);
    }
}

