/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app;

import nextapp.echo.app.list.AbstractListComponent;
import nextapp.echo.app.list.DefaultListModel;
import nextapp.echo.app.list.ListModel;
import nextapp.echo.app.list.ListSelectionModel;

public class ListBox
extends AbstractListComponent {
    private static final long serialVersionUID = 20070101L;

    public ListBox() {
    }

    public ListBox(ListModel model) {
        super(model, null);
    }

    public ListBox(ListModel model, ListSelectionModel selectionModel) {
        super(model, selectionModel);
    }

    public ListBox(Object[] itemArray) {
        super(new DefaultListModel(itemArray), null);
    }

    public int getMaxSelectedIndex() {
        return this.getSelectionModel().getMaxSelectedIndex();
    }

    public int getMinSelectedIndex() {
        return this.getSelectionModel().getMinSelectedIndex();
    }

    public int[] getSelectedIndices() {
        int size;
        ListModel model = this.getModel();
        int min = this.getMinSelectedIndex();
        if (min == -1) {
            return new int[0];
        }
        int selectionCount = 0;
        int max = this.getMaxSelectedIndex();
        if (max >= (size = model.size()) - 1) {
            max = size - 1;
        }
        for (int index = min; index <= max; ++index) {
            if (!this.isSelectedIndex(index)) continue;
            ++selectionCount;
        }
        int[] selectedIndices = new int[selectionCount];
        selectionCount = 0;
        for (int index = min; index <= max; ++index) {
            if (!this.isSelectedIndex(index)) continue;
            selectedIndices[selectionCount] = index;
            ++selectionCount;
        }
        return selectedIndices;
    }

    public Object getSelectedValue() {
        ListModel model = this.getModel();
        int selectedIndex = this.getMinSelectedIndex();
        Object value = selectedIndex == -1 ? null : model.get(this.getMinSelectedIndex());
        return value;
    }

    public Object[] getSelectedValues() {
        int size;
        ListModel model = this.getModel();
        int min = this.getMinSelectedIndex();
        if (min == -1) {
            return new Object[0];
        }
        int selectionCount = 0;
        int max = this.getMaxSelectedIndex();
        if (max >= (size = model.size()) - 1) {
            max = size - 1;
        }
        for (int index = min; index <= max; ++index) {
            if (!this.isSelectedIndex(index)) continue;
            ++selectionCount;
        }
        Object[] selectedValues = new Object[selectionCount];
        selectionCount = 0;
        for (int index = min; index <= max; ++index) {
            if (!this.isSelectedIndex(index)) continue;
            selectedValues[selectionCount] = model.get(index);
            ++selectionCount;
        }
        return selectedValues;
    }

    public int getSelectionMode() {
        return this.getSelectionModel().getSelectionMode();
    }

    public boolean isSelectedIndex(int index) {
        return this.getSelectionModel().isSelectedIndex(index);
    }

    public void setSelectedIndex(int index) {
        ListSelectionModel selectionModel = this.getSelectionModel();
        selectionModel.clearSelection();
        selectionModel.setSelectedIndex(index, true);
    }

    public void setSelectedIndex(int index, boolean selected) {
        this.getSelectionModel().setSelectedIndex(index, selected);
    }

    public void setSelectedIndices(int[] indices) {
        ListSelectionModel selectionModel = this.getSelectionModel();
        selectionModel.clearSelection();
        for (int i = 0; i < indices.length; ++i) {
            selectionModel.setSelectedIndex(indices[i], true);
        }
    }

    public void setSelectionMode(int newValue) {
        this.getSelectionModel().setSelectionMode(newValue);
    }
}

