/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app.serial.property;

import nextapp.echo.app.Alignment;
import nextapp.echo.app.serial.SerialContext;
import nextapp.echo.app.serial.SerialException;
import nextapp.echo.app.serial.SerialPropertyPeer;
import nextapp.echo.app.util.ConstantMap;
import nextapp.echo.app.util.Context;
import nextapp.echo.app.util.DomUtil;
import org.w3c.dom.Element;

public class AlignmentPeer
implements SerialPropertyPeer {
    private static final ConstantMap HORIZONTAL_CONSTANTS = new ConstantMap();
    private static final ConstantMap VERTICAL_CONSTANTS;

    public Object toProperty(Context context, Class objectClass, Element propertyElement) throws SerialException {
        Element alignmentElement = DomUtil.getChildElementByTagName(propertyElement, "a");
        String horizontal = alignmentElement.getAttribute("h");
        String vertical = alignmentElement.getAttribute("v");
        return new Alignment(HORIZONTAL_CONSTANTS.get(horizontal, 0), VERTICAL_CONSTANTS.get(vertical, 0));
    }

    public void toXml(Context context, Class objectClass, Element propertyElement, Object propertyValue) throws SerialException {
        String vertical;
        SerialContext serialContext = (SerialContext)context.get(SerialContext.class);
        propertyElement.setAttribute("t", (serialContext.getFlags() & 1) == 0 ? "Alignment" : "AL");
        Alignment alignment = (Alignment)propertyValue;
        Element aElement = serialContext.getDocument().createElement("a");
        String horizontal = HORIZONTAL_CONSTANTS.get(alignment.getHorizontal());
        if (horizontal != null) {
            aElement.setAttribute("h", horizontal);
        }
        if ((vertical = VERTICAL_CONSTANTS.get(alignment.getVertical())) != null) {
            aElement.setAttribute("v", vertical);
        }
        propertyElement.appendChild(aElement);
    }

    static {
        HORIZONTAL_CONSTANTS.add(1, "leading");
        HORIZONTAL_CONSTANTS.add(2, "trailing");
        HORIZONTAL_CONSTANTS.add(3, "left");
        HORIZONTAL_CONSTANTS.add(4, "center");
        HORIZONTAL_CONSTANTS.add(5, "right");
        VERTICAL_CONSTANTS = new ConstantMap();
        VERTICAL_CONSTANTS.add(6, "top");
        VERTICAL_CONSTANTS.add(4, "center");
        VERTICAL_CONSTANTS.add(7, "bottom");
    }
}

