/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app.serial.property;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import nextapp.echo.app.Border;
import nextapp.echo.app.Color;
import nextapp.echo.app.Extent;
import nextapp.echo.app.serial.SerialContext;
import nextapp.echo.app.serial.SerialException;
import nextapp.echo.app.serial.SerialPropertyPeer;
import nextapp.echo.app.serial.property.ColorPeer;
import nextapp.echo.app.serial.property.ExtentPeer;
import nextapp.echo.app.util.ConstantMap;
import nextapp.echo.app.util.Context;
import nextapp.echo.app.util.DomUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BorderPeer
implements SerialPropertyPeer {
    private static final ConstantMap STYLE_CONSTANT_MAP = new ConstantMap();
    private static final String[] borderSideAttributeNames;

    public static final Border.Side fromString(String value) throws SerialException {
        try {
            StringTokenizer st = new StringTokenizer(value, " ");
            String sizeString = st.nextToken();
            String styleString = st.nextToken();
            String colorString = st.nextToken();
            Extent size = ExtentPeer.fromString(sizeString);
            int style = STYLE_CONSTANT_MAP.get(styleString, 1);
            Color color = ColorPeer.fromString(colorString);
            return new Border.Side(size, color, style);
        }
        catch (NoSuchElementException ex) {
            throw new SerialException("Unable to parse border side value: " + value, ex);
        }
    }

    public static final Node toNode(Context context, Border border) throws SerialException {
        SerialContext serialContext = (SerialContext)context.get(SerialContext.class);
        if (border.isMultisided()) {
            Element borderElement = serialContext.getDocument().createElement("b");
            Border.Side[] sides = border.getSides();
            for (int i = 0; i < sides.length; ++i) {
                if (sides[i] == null) {
                    borderElement.setAttribute(borderSideAttributeNames[i], "");
                    continue;
                }
                borderElement.setAttribute(borderSideAttributeNames[i], BorderPeer.toString(sides[i]));
            }
            return borderElement;
        }
        return serialContext.getDocument().createTextNode(BorderPeer.toString(border));
    }

    public static final String toString(Border border) throws SerialException {
        return BorderPeer.toString(border.getSides()[0]);
    }

    public static final String toString(Border.Side side) throws SerialException {
        StringBuffer out = new StringBuffer();
        out.append(ExtentPeer.toString(side.getSize()));
        out.append(" ");
        out.append(STYLE_CONSTANT_MAP.get(side.getStyle()));
        out.append(" ");
        out.append(ColorPeer.toString(side.getColor()));
        return out.toString();
    }

    public Object toProperty(Context context, Class objectClass, Element propertyElement) throws SerialException {
        int sideCount;
        String value = DomUtil.getElementText(propertyElement);
        if (value != null) {
            value = value.trim();
        }
        if (value != null && value.length() > 0) {
            Border.Side side = BorderPeer.fromString(value);
            return new Border(new Border.Side[]{side});
        }
        if (propertyElement.hasAttribute("v")) {
            Border.Side side = BorderPeer.fromString(propertyElement.getAttribute("v"));
            return new Border(new Border.Side[]{side});
        }
        Element borderElement = DomUtil.getChildElementByTagName(propertyElement, "b");
        for (sideCount = 0; sideCount < borderSideAttributeNames.length && borderElement.hasAttribute(borderSideAttributeNames[sideCount]); ++sideCount) {
        }
        Border.Side[] sides = new Border.Side[sideCount];
        for (int i = 0; i < sides.length; ++i) {
            sides[i] = BorderPeer.fromString(borderElement.getAttribute(borderSideAttributeNames[i]));
        }
        return new Border(sides);
    }

    public void toXml(Context context, Class objectClass, Element propertyElement, Object propertyValue) throws SerialException {
        SerialContext serialContext = (SerialContext)context.get(SerialContext.class);
        propertyElement.setAttribute("t", (serialContext.getFlags() & 1) == 0 ? "Border" : "BO");
        Border border = (Border)propertyValue;
        propertyElement.appendChild(BorderPeer.toNode(context, border));
    }

    static {
        STYLE_CONSTANT_MAP.add(0, "none");
        STYLE_CONSTANT_MAP.add(1, "solid");
        STYLE_CONSTANT_MAP.add(2, "inset");
        STYLE_CONSTANT_MAP.add(3, "outset");
        STYLE_CONSTANT_MAP.add(4, "groove");
        STYLE_CONSTANT_MAP.add(5, "ridge");
        STYLE_CONSTANT_MAP.add(7, "dotted");
        STYLE_CONSTANT_MAP.add(8, "dashed");
        STYLE_CONSTANT_MAP.add(6, "double");
        borderSideAttributeNames = new String[]{"t", "r", "b", "l"};
    }
}

