/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import nextapp.echo.app.ApplicationInstance;
import nextapp.echo.app.Color;
import nextapp.echo.app.Font;
import nextapp.echo.app.IllegalChildException;
import nextapp.echo.app.LayoutData;
import nextapp.echo.app.LayoutDirection;
import nextapp.echo.app.MutableStyle;
import nextapp.echo.app.RenderIdSupport;
import nextapp.echo.app.Style;
import nextapp.echo.app.event.EventListenerList;

public abstract class Component
implements RenderIdSupport,
Serializable {
    private static final long serialVersionUID = 20070101L;
    private static final int CHILD_LIST_CAPACITY = 3;
    private static final Component[] EMPTY_COMPONENT_ARRAY = new Component[0];
    private static final int FLAG_DISPOSE_IN_PROGRESS = 32;
    private static final int FLAG_ENABLED = 1;
    private static final int FLAG_VISIBLE = 2;
    private static final int FLAG_INIT_IN_PROGRESS = 16;
    private static final int FLAG_INITIALIZED = 64;
    private static final int FLAG_REGISTERING = 8;
    public static final String CHILD_VISIBLE_CHANGED_PROPERTY = "childVisible";
    public static final String CHILDREN_CHANGED_PROPERTY = "children";
    public static final String ENABLED_CHANGED_PROPERTY = "enabled";
    public static final String FOCUS_NEXT_ID_CHANGED_PROPERTY = "focusNextId";
    public static final String FOCUS_PREVIOUS_ID_CHANGED_PROPERTY = "focusPreviousId";
    public static final String LAYOUT_DIRECTION_CHANGED_PROPERTY = "layoutDirection";
    public static final String LOCALE_CHANGED_PROPERTY = "locale";
    public static final String STYLE_CHANGED_PROPERTY = "style";
    public static final String STYLE_NAME_CHANGED_PROPERTY = "styleName";
    public static final String VISIBLE_CHANGED_PROPERTY = "visible";
    public static final String PROPERTY_BACKGROUND = "background";
    public static final String PROPERTY_FONT = "font";
    public static final String PROPERTY_FOREGROUND = "foreground";
    public static final String PROPERTY_LAYOUT_DATA = "layoutData";
    private ApplicationInstance applicationInstance;
    private List children;
    private int flags = 3;
    private String id;
    private LayoutDirection layoutDirection;
    private EventListenerList listenerList;
    private Locale locale;
    private MutableStyle localStyle = new MutableStyle();
    private Component parent;
    private PropertyChangeSupport propertyChangeSupport;
    private String renderId;
    private Style sharedStyle;
    private String styleName;
    private String focusPreviousId;
    private String focusNextId;

    private static final boolean isRenderIdStart(char ch) {
        return ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z';
    }

    private static final boolean isRenderIdPart(char ch) {
        return ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '_';
    }

    public void add(Component c) {
        this.add(c, -1);
    }

    public void add(Component c, int n) throws IllegalChildException {
        if (!this.isValidChild(c)) {
            throw new IllegalChildException(this, c);
        }
        if (!c.isValidParent(this)) {
            throw new IllegalChildException(this, c);
        }
        if (c.parent != null) {
            c.parent.remove(c);
        }
        if (this.children == null) {
            this.children = new ArrayList(3);
        }
        c.parent = this;
        if (n == -1) {
            this.children.add(c);
        } else {
            this.children.add(n, c);
        }
        if (this.applicationInstance != null) {
            c.register(this.applicationInstance);
        }
        this.firePropertyChange(CHILDREN_CHANGED_PROPERTY, null, c);
        c.doInit();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, l);
    }

    void assignRenderId(String renderId) {
        this.renderId = renderId;
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doDispose() {
        if (this.applicationInstance == null) {
            return;
        }
        if ((this.flags & 0x30) != 0) {
            throw new IllegalStateException("Attempt to dispose component when initialize or dispose operation already in progress.");
        }
        this.flags |= 0x20;
        try {
            if (this.children != null) {
                Iterator it = this.children.iterator();
                while (it.hasNext()) {
                    ((Component)it.next()).doDispose();
                }
            }
            if ((this.flags & 0x40) == 0) {
                return;
            }
            this.dispose();
            this.flags &= 0xFFFFFFBF;
        }
        finally {
            this.flags &= 0xFFFFFFDF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doInit() {
        if (this.applicationInstance == null) {
            return;
        }
        if ((this.flags & 0x40) != 0) {
            return;
        }
        if ((this.flags & 0x30) != 0) {
            throw new IllegalStateException("Attempt to initialize component when initialize or dispose operation already in progress.");
        }
        this.flags |= 0x10;
        try {
            this.init();
            this.flags |= 0x40;
            if (this.children != null) {
                Iterator it = this.children.iterator();
                while (it.hasNext()) {
                    ((Component)it.next()).doInit();
                }
            }
        }
        finally {
            this.flags &= 0xFFFFFFEF;
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
        if (this.applicationInstance != null) {
            this.applicationInstance.notifyComponentPropertyChange(this, propertyName, oldValue, newValue);
        }
    }

    public final Object get(String propertyName) {
        return this.localStyle.get(propertyName);
    }

    public ApplicationInstance getApplicationInstance() {
        return this.applicationInstance;
    }

    public Color getBackground() {
        return (Color)this.localStyle.get(PROPERTY_BACKGROUND);
    }

    public final Component getComponent(int n) {
        if (this.children == null) {
            throw new IndexOutOfBoundsException();
        }
        return (Component)this.children.get(n);
    }

    public final Component getComponent(String id) {
        if (id.equals(this.id)) {
            return this;
        }
        if (this.children == null) {
            return null;
        }
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            Component testComponent = (Component)it.next();
            Component targetComponent = testComponent.getComponent(id);
            if (targetComponent == null) continue;
            return targetComponent;
        }
        return null;
    }

    public final int getComponentCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public final Component[] getComponents() {
        if (this.children == null) {
            return EMPTY_COMPONENT_ARRAY;
        }
        return this.children.toArray(new Component[this.children.size()]);
    }

    protected EventListenerList getEventListenerList() {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        return this.listenerList;
    }

    public String getFocusNextId() {
        return this.focusNextId;
    }

    public String getFocusPreviousId() {
        return this.focusPreviousId;
    }

    public Font getFont() {
        return (Font)this.localStyle.get(PROPERTY_FONT);
    }

    public Color getForeground() {
        return (Color)this.localStyle.get(PROPERTY_FOREGROUND);
    }

    public String getId() {
        return this.id;
    }

    public final Object getIndex(String propertyName, int propertyIndex) {
        return this.localStyle.getIndex(propertyName, propertyIndex);
    }

    public LayoutData getLayoutData() {
        return (LayoutData)this.localStyle.get(PROPERTY_LAYOUT_DATA);
    }

    public LayoutDirection getLayoutDirection() {
        return this.layoutDirection;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Style getLocalStyle() {
        return this.localStyle;
    }

    public final Component getParent() {
        return this.parent;
    }

    public String getRenderId() {
        return this.renderId;
    }

    public final Object getRenderIndexedProperty(String propertyName, int propertyIndex) {
        return this.getRenderIndexedProperty(propertyName, propertyIndex, null);
    }

    public final Object getRenderIndexedProperty(String propertyName, int propertyIndex, Object defaultValue) {
        Style applicationStyle;
        if (this.localStyle.isIndexedPropertySet(propertyName, propertyIndex)) {
            return this.localStyle.getIndex(propertyName, propertyIndex);
        }
        if (this.sharedStyle != null && this.sharedStyle.isIndexedPropertySet(propertyName, propertyIndex)) {
            return this.sharedStyle.getIndex(propertyName, propertyIndex);
        }
        if (this.applicationInstance != null && (applicationStyle = this.applicationInstance.getStyle(this.getClass(), this.styleName)) != null && applicationStyle.isIndexedPropertySet(propertyName, propertyIndex)) {
            return applicationStyle.getIndex(propertyName, propertyIndex);
        }
        return defaultValue;
    }

    public final Locale getRenderLocale() {
        if (this.locale == null) {
            if (this.parent == null) {
                if (this.applicationInstance == null) {
                    return null;
                }
                return this.applicationInstance.getLocale();
            }
            return this.parent.getRenderLocale();
        }
        return this.locale;
    }

    public final Object getRenderProperty(String propertyName) {
        return this.getRenderProperty(propertyName, null);
    }

    public final Object getRenderProperty(String propertyName, Object defaultValue) {
        Style applicationStyle;
        Object propertyValue = this.localStyle.get(propertyName);
        if (propertyValue != null) {
            return propertyValue;
        }
        if (this.sharedStyle != null && (propertyValue = this.sharedStyle.get(propertyName)) != null) {
            return propertyValue;
        }
        if (this.applicationInstance != null && (applicationStyle = this.applicationInstance.getStyle(this.getClass(), this.styleName)) != null && (propertyValue = applicationStyle.get(propertyName)) != null) {
            return propertyValue;
        }
        return defaultValue;
    }

    public final Style getStyle() {
        return this.sharedStyle;
    }

    public final String getStyleName() {
        return this.styleName;
    }

    public final Component getVisibleComponent(int n) {
        if (this.children == null) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        int visibleComponentCount = 0;
        Component component = null;
        Iterator it = this.children.iterator();
        while (visibleComponentCount <= n) {
            if (!it.hasNext()) {
                throw new IndexOutOfBoundsException(Integer.toString(n));
            }
            component = (Component)it.next();
            if (!component.isVisible()) continue;
            ++visibleComponentCount;
        }
        return component;
    }

    public final int getVisibleComponentCount() {
        if (this.children == null) {
            return 0;
        }
        int visibleComponentCount = 0;
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            Component component = (Component)it.next();
            if (!component.isVisible()) continue;
            ++visibleComponentCount;
        }
        return visibleComponentCount;
    }

    public final Component[] getVisibleComponents() {
        if (this.children == null) {
            return EMPTY_COMPONENT_ARRAY;
        }
        Iterator it = this.children.iterator();
        ArrayList<Component> visibleChildList = new ArrayList<Component>();
        while (it.hasNext()) {
            Component component = (Component)it.next();
            if (!component.isVisible()) continue;
            visibleChildList.add(component);
        }
        return visibleChildList.toArray(new Component[visibleChildList.size()]);
    }

    protected boolean hasEventListenerList() {
        return this.listenerList != null;
    }

    public final int indexOf(Component c) {
        return this.children == null ? -1 : this.children.indexOf(c);
    }

    public void init() {
    }

    public final boolean isAncestorOf(Component c) {
        while (c != null && c != this) {
            c = c.parent;
        }
        return c == this;
    }

    public final boolean isEnabled() {
        return (this.flags & 1) != 0;
    }

    public boolean isFocusTraversalParticipant() {
        return false;
    }

    public final boolean isRegistered() {
        return this.applicationInstance != null;
    }

    public final boolean isRenderEnabled() {
        Component component = this;
        while (component != null) {
            if ((component.flags & 1) == 0) {
                return false;
            }
            component = component.parent;
        }
        return true;
    }

    public final boolean isRenderVisible() {
        Component component = this;
        while (component != null) {
            if ((component.flags & 2) == 0) {
                return false;
            }
            component = component.parent;
        }
        return true;
    }

    public boolean isValidChild(Component child) {
        return true;
    }

    public boolean isValidParent(Component parent) {
        return true;
    }

    public final boolean isVisible() {
        return (2 & this.flags) != 0;
    }

    public void processInput(String inputName, Object inputValue) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(ApplicationInstance newValue) {
        if ((this.flags & 8) != 0) {
            throw new IllegalStateException("Illegal attempt to register/unregister Component from within invocation of registration change life-cycle method.");
        }
        try {
            Iterator it;
            this.flags |= 8;
            if (this.applicationInstance == newValue) {
                return;
            }
            if (this.applicationInstance != null && newValue != null) {
                throw new IllegalStateException("Illegal attempt to re-register Component to alternate ApplicationInstance.");
            }
            if (newValue == null) {
                if (this.children != null) {
                    it = this.children.iterator();
                    while (it.hasNext()) {
                        ((Component)it.next()).register(null);
                    }
                }
                this.applicationInstance.unregisterComponent(this);
            }
            this.applicationInstance = newValue;
            if (newValue != null) {
                this.applicationInstance.registerComponent(this);
                if (this.children != null) {
                    it = this.children.iterator();
                    while (it.hasNext()) {
                        ((Component)it.next()).register(newValue);
                    }
                }
            }
        }
        finally {
            this.flags &= 0xFFFFFFF7;
        }
    }

    public void remove(Component c) {
        if (this.children == null || !this.children.contains(c)) {
            return;
        }
        c.doDispose();
        if (this.applicationInstance != null) {
            c.register(null);
        }
        this.children.remove(c);
        c.parent = null;
        this.firePropertyChange(CHILDREN_CHANGED_PROPERTY, c, null);
    }

    public void remove(int n) {
        if (this.children == null) {
            throw new IndexOutOfBoundsException();
        }
        this.remove(this.getComponent(n));
    }

    public void removeAll() {
        if (this.children != null) {
            while (this.children.size() > 0) {
                Component c = (Component)this.children.get(this.children.size() - 1);
                this.remove(c);
            }
            this.children = null;
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.removePropertyChangeListener(l);
        }
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyName, l);
        }
    }

    public void set(String propertyName, Object newValue) {
        Object oldValue = this.localStyle.get(propertyName);
        this.localStyle.set(propertyName, newValue);
        this.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void setBackground(Color newValue) {
        this.set(PROPERTY_BACKGROUND, newValue);
    }

    public void setComponents(Component[] components) {
        this.removeAll();
        for (int i = 0; i < components.length; ++i) {
            this.add(components[i]);
        }
    }

    public void setEnabled(boolean newValue) {
        boolean oldValue;
        boolean bl = oldValue = (this.flags & 1) != 0;
        if (oldValue != newValue) {
            this.flags ^= 1;
            this.firePropertyChange(ENABLED_CHANGED_PROPERTY, new Boolean(oldValue), new Boolean(newValue));
        }
    }

    public void setFocusTraversalParticipant(boolean newValue) {
    }

    public void setFocusNextId(String newValue) {
        String oldValue = this.focusNextId;
        this.focusNextId = newValue;
        this.firePropertyChange(FOCUS_NEXT_ID_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setFocusPreviousId(String newValue) {
        String oldValue = this.focusPreviousId;
        this.focusPreviousId = newValue;
        this.firePropertyChange(FOCUS_PREVIOUS_ID_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setFont(Font newValue) {
        this.set(PROPERTY_FONT, newValue);
    }

    public void setForeground(Color newValue) {
        this.set(PROPERTY_FOREGROUND, newValue);
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setIndex(String propertyName, int propertyIndex, Object newValue) {
        this.localStyle.setIndex(propertyName, propertyIndex, newValue);
        this.firePropertyChange(propertyName, null, null);
    }

    public void setLayoutData(LayoutData newValue) {
        this.set(PROPERTY_LAYOUT_DATA, newValue);
    }

    public void setLayoutDirection(LayoutDirection newValue) {
        LayoutDirection oldValue = this.layoutDirection;
        this.layoutDirection = newValue;
        this.firePropertyChange(LAYOUT_DIRECTION_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setLocale(Locale newValue) {
        Locale oldValue = this.locale;
        this.locale = newValue;
        this.firePropertyChange(LOCALE_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setRenderId(String renderId) {
        if (this.renderId != null && renderId != null && this.applicationInstance != null) {
            throw new IllegalStateException("Cannot set renderId while component is registered.");
        }
        if (renderId != null) {
            int length = renderId.length();
            if (!Component.isRenderIdStart(renderId.charAt(0))) {
                throw new IllegalArgumentException("Invalid identifier:" + renderId);
            }
            for (int i = 1; i < length; ++i) {
                if (Component.isRenderIdPart(renderId.charAt(i))) continue;
                throw new IllegalArgumentException("Invalid identifier:" + renderId);
            }
        }
        this.assignRenderId(renderId);
    }

    public void setStyle(Style newValue) {
        Style oldValue = this.sharedStyle;
        this.sharedStyle = newValue;
        this.firePropertyChange(STYLE_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setStyleName(String newValue) {
        String oldValue = this.styleName;
        this.styleName = newValue;
        this.firePropertyChange(STYLE_NAME_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setVisible(boolean newValue) {
        boolean oldValue;
        boolean bl = oldValue = (this.flags & 2) != 0;
        if (oldValue != newValue) {
            this.flags ^= 2;
            this.firePropertyChange(VISIBLE_CHANGED_PROPERTY, oldValue, newValue);
            if (this.parent != null) {
                this.parent.firePropertyChange(CHILD_VISIBLE_CHANGED_PROPERTY, newValue ? null : this, newValue ? this : null);
            }
        }
    }

    public void validate() {
    }

    public boolean verifyInput(String inputName, Object inputValue) {
        if (this.applicationInstance != null && !this.applicationInstance.verifyModalContext(this)) {
            return false;
        }
        return this.isVisible() && this.isEnabled();
    }

    public final int visibleIndexOf(Component c) {
        if (!c.isVisible()) {
            return -1;
        }
        if (this.children == null) {
            return -1;
        }
        int visibleIndex = 0;
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            Component component = (Component)it.next();
            if (!component.isVisible()) continue;
            if (component.equals(c)) {
                return visibleIndex;
            }
            ++visibleIndex;
        }
        return -1;
    }
}

