/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.voice.ncco;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.nexmo.client.voice.ncco.Endpoint;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class WebSocketEndpoint
implements Endpoint {
    private static final String TYPE = "websocket";
    private String uri;
    private String contentType;
    private Map<String, String> headers;

    private WebSocketEndpoint(Builder builder) {
        this.uri = builder.uri;
        this.contentType = builder.contentType;
        this.headers = builder.headers;
    }

    public String getUri() {
        return this.uri;
    }

    @JsonProperty(value="content-type")
    public String getContentType() {
        return this.contentType;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public static Builder builder(String uri, String contentType) {
        return new Builder(uri, contentType);
    }

    public static class Builder {
        private String uri;
        private String contentType;
        private Map<String, String> headers;

        public Builder(String uri, String contentType) {
            this.uri = uri;
            this.contentType = contentType;
        }

        public Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder headers(String ... entries) {
            if (entries.length % 2 != 0) {
                throw new IllegalArgumentException("Entries must be key, value and every key must have a value.");
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            for (int i = 0; i < entries.length - 1; i += 2) {
                headers.put(entries[i], entries[i + 1]);
            }
            return this.headers(headers);
        }

        public WebSocketEndpoint build() {
            return new WebSocketEndpoint(this);
        }
    }
}

