/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.sms;

import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.NexmoResponseParseException;
import com.nexmo.client.sms.SearchRejectedMessagesEndpoint;
import com.nexmo.client.sms.SearchRejectedMessagesRequest;
import com.nexmo.client.sms.SearchRejectedMessagesResponse;
import com.nexmo.client.sms.SearchSmsRequest;
import com.nexmo.client.sms.SearchSmsResponse;
import com.nexmo.client.sms.SendMessageEndpoint;
import com.nexmo.client.sms.SmsDateSearchRequest;
import com.nexmo.client.sms.SmsIdSearchRequest;
import com.nexmo.client.sms.SmsSearchEndpoint;
import com.nexmo.client.sms.SmsSingleSearchEndpoint;
import com.nexmo.client.sms.SmsSingleSearchResponse;
import com.nexmo.client.sms.SmsSubmissionResponse;
import com.nexmo.client.sms.messages.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;

public class SmsClient {
    private SendMessageEndpoint message;
    private SmsSearchEndpoint search;
    private SearchRejectedMessagesEndpoint rejected;
    private SmsSingleSearchEndpoint singleSearch;

    public SmsClient(HttpWrapper httpWrapper) {
        this.message = new SendMessageEndpoint(httpWrapper);
        this.search = new SmsSearchEndpoint(httpWrapper);
        this.rejected = new SearchRejectedMessagesEndpoint(httpWrapper);
        this.singleSearch = new SmsSingleSearchEndpoint(httpWrapper);
    }

    public SmsSubmissionResponse submitMessage(Message message) throws NexmoResponseParseException, NexmoClientException {
        return (SmsSubmissionResponse)this.message.execute(message);
    }

    public SearchSmsResponse searchMessages(SearchSmsRequest request) throws NexmoResponseParseException, NexmoClientException {
        return (SearchSmsResponse)this.search.execute(request);
    }

    public SearchSmsResponse searchMessages(String id, String ... ids) throws NexmoResponseParseException, NexmoClientException {
        ArrayList<String> idList = new ArrayList<String>(ids.length + 1);
        idList.add(id);
        idList.addAll(Arrays.asList(ids));
        return this.searchMessages(new SmsIdSearchRequest(idList));
    }

    public SearchSmsResponse searchMessages(Date date, String to) throws NexmoResponseParseException, NexmoClientException {
        return this.searchMessages(new SmsDateSearchRequest(date, to));
    }

    public SearchRejectedMessagesResponse searchRejectedMessages(SearchRejectedMessagesRequest request) throws NexmoResponseParseException, NexmoClientException {
        return (SearchRejectedMessagesResponse)this.rejected.execute(request);
    }

    public SearchRejectedMessagesResponse searchRejectedMessages(Date date, String to) throws NexmoResponseParseException, NexmoClientException {
        return this.searchRejectedMessages(new SearchRejectedMessagesRequest(date, to));
    }

    public SmsSingleSearchResponse getSms(String id) throws NexmoResponseParseException, NexmoClientException {
        return (SmsSingleSearchResponse)this.singleSearch.execute(id);
    }
}

