/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.numbers;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum Type {
    LANDLINE("landline"),
    MOBILE_LVN("mobile-lvn"),
    LANDLINE_TOLL_FREE("landline-toll-free"),
    UNKNOWN("unknown");

    private static final Map<String, Type> TYPE_INDEX;
    private String type;

    private Type(String type) {
        this.type = type;
    }

    @JsonValue
    public String getType() {
        return this.type;
    }

    @JsonCreator
    public static Type fromString(String type) {
        Type foundType = TYPE_INDEX.get(type);
        return foundType != null ? foundType : UNKNOWN;
    }

    static {
        TYPE_INDEX = new HashMap<String, Type>();
        for (Type type : Type.values()) {
            TYPE_INDEX.put(type.type, type);
        }
    }
}

